//==============================================================================
// Stripe Payment Gateway Pro v303.16
// 
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
// 
// All code within this file is copyright Clear Thinking, LLC.
// You may not copy or reuse code within this file without written permission.
//==============================================================================

$(document).ready(function(){
	$('body').append('<style type="text/css">#quick-buy-popup-background {display: none;background: #000;opacity: 0.5;position: fixed;top: 0;left: 0;width: 100%;height: 100%;z-index: 99999;}#quick-buy-popup {display: none;background: white;border-radius: 10px;box-shadow: 0 0 20px #000;width: 75%;min-width: 340px;max-width: 800px;max-height: 90%;overflow: scroll;overflow-x: auto;overflow-y: auto;padding: 20px;position: fixed;top: 5%;left: 0;right: 0;margin-left: auto;margin-right: auto;z-index: 100000;}#quick-buy-popup h3 {margin: 0 0 20px 0;}#hide-quick-buy-popup {color: black;cursor: pointer;float: right;font-size: 24px;font-weight: bold;text-decoration: none;}</style><div id="quick-buy-popup-background" onclick="hideQuickBuy()"></div><div id="quick-buy-popup"><a id="hide-quick-buy-popup" onclick="hideQuickBuy()">&times;</a><h3></h3><div id="collapse-shipping-address"></div></div>');
	
	showQuickBuy();
});

function hideQuickBuy() {
	$('#quick-buy-popup-background, #quick-buy-popup').hide();
}

function showQuickBuy() {
	$.ajax({
		type: 'GET',
		cache: false,
		url: 'index.php?route=extension/quick_buy',
		success: function(data) {
			$('#quick-buy-script').after(data);
			$('#quick-buy-script').next().find('a').attr('onclick', 'startQuickBuy()');
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
}

function startQuickBuy() {
	$.ajax({
		type: 'POST',
		url: 'index.php?route=extension/quick_buy/start',
		data: $('#product :input'),
		beforeSend: function() {
			$('#quick-buy-popup-background').show();
			$('#quick-buy-popup h3').html('<i class="fa fa-spin fa-spinner"></i>');
			$('#collapse-shipping-address').html('');
			$('#quick-buy-popup').show();
		},
		success: function(data) {
			loadShipping(data);
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
}

function loadShipping(heading) {
	$.ajax({
		type: 'GET',
		cache: false,
		url: 'index.php?route=checkout/guest_shipping',
		success: function(data) {
			if (!$.isFunction('datetimepicker')) { 
				$.fn.datetimepicker = function() {
					return this;
				};
			}
			$('#quick-buy-popup h3').html(heading);
			$('#collapse-shipping-address').html(data);
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
}

$(document).on('click', '#button-guest-shipping', function(){
	$.ajax({
		type: 'POST',
		url: 'index.php?route=extension/quick_buy/setShippingAddress',
		data: $('#collapse-shipping-address :input'),
		dataType: 'json',
		beforeSend: function() {
			$('#button-guest-shipping').attr('disabled', 'disabled');
		},
		success: function(json) {
			if (json.error) {
				alert(json.error);
				$('#button-guest-shipping').removeAttr('disabled');
			} else {
				getShippingRates(json.text);
			}
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		},
	});
});

function getShippingRates(heading) {
	$.ajax({
		type: 'GET',
		cache: false,
		url: 'index.php?route=checkout/shipping_method',
		success: function(data) {
			$('#quick-buy-popup h3').html(heading);
			$('#collapse-shipping-address').html(data);
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
}

$(document).on('click', '#button-shipping-method', function(){
	$.ajax({
		type: 'POST',
		url: 'index.php?route=extension/quick_buy/setShippingMethod',
		data: {shipping_method: $('#collapse-shipping-address input[name="shipping_method"]:checked').val(), comment: $('#collapse-shipping-address textarea[name="comment"]').val()},
		beforeSend: function() {
			$('#button-shipping-method').attr('disabled', 'disabled');
		},
		success: function(data) {
			data = data.trim();
			if (data) {
				alert(data);
				$('#button-shipping-method').removeAttr('disabled');
			} else {
				redirectToStripe();
			}
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
});

function redirectToStripe() {
	$.ajax({
		type: 'POST',
		url: 'index.php?route=extension/payment/stripe/createCheckoutSession',
		data: {quick_buy: true},
		dataType: 'json',
		success: function(json) {
			if (json.error) {
				alert(json.error);
				$('#button-shipping-method').removeAttr('disabled');
			} else {
				$.getScript('https://js.stripe.com/v3', function() {
					var stripe = Stripe(json.key, {stripeAccount: json.account_id});
					stripe.redirectToCheckout({
						sessionId: json.session_id,
					}).then(function(result) {
						console.log(result.error.message);
						alert(result.error.message);
					});
				});
			}
		},
		error: function(xhr, status, error) {
			alert(xhr.responseText ? xhr.responseText : error);
		}
	});
}
