<?php
//==============================================================================
// Stripe Payment Gateway Pro v303.16
// 
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
// 
// All code within this file is copyright Clear Thinking, LLC.
// You may not copy or reuse code within this file without written permission.
//==============================================================================

class ControllerExtensionQuickBuy extends Controller {
	private $type = 'extension';
	private $name = 'quick_buy';
	
	//==============================================================================
	// index()
	//==============================================================================
	public function index() {
		$prefix = (version_compare(VERSION, '3.0', '<')) ? '' : 'payment_';
		
		$button_html = $this->config->get($prefix . 'stripe_quick_buy_html');
		$button_text = $this->config->get($prefix . 'stripe_quick_buy_text_' . $this->session->data['language']);
		$quick_buy_html = str_replace('[button_text]', $button_text, $button_html);
		
		echo html_entity_decode($quick_buy_html, ENT_QUOTES, 'UTF-8');
	}
	
	//==============================================================================
	// start()
	//==============================================================================
	public function start() {
		if ($this->customer->isLogged() && $this->customer->getAddressId()) {
			if (empty($this->session->data['shipping_address'])) {
				$this->session->data['shipping_address'] = $this->db->query("SELECT * FROM " . DB_PREFIX . "address WHERE address_id = " . (int)$this->customer->getAddressId())->row;
			}
			$this->session->data['guest']['customer_group_id'] = (int)$this->customer->getGroupId();
		} else {
			$this->session->data['guest']['customer_group_id'] = $this->config->get('config_customer_group_id');
		}
		
		if (!empty($this->request->post)) {
			$already_in_cart = false;
			
			foreach ($this->cart->getProducts() as $product) {
				if ($product['product_id'] == $this->request->post['product_id']) {
					$already_in_cart = true;
				}
			}
			
			if (!$already_in_cart) {
				$quantity = (!empty($this->request->post['quantity'])) ? $this->request->post['quantity'] : 1;
				$options = (!empty($this->request->post['option'])) ? array_filter($this->request->post['option']) : array();
				$this->cart->add($this->request->post['product_id'], $this->request->post['quantity'], $options);
			}
		}
		
		$prefix = (version_compare(VERSION, '3.0', '<')) ? '' : 'payment_';
		$text = $this->config->get($prefix . 'stripe_quick_buy_address_text_' . $this->session->data['language']);
		
		echo html_entity_decode($text, ENT_QUOTES, 'UTF-8');
	}
	
	//==============================================================================
	// setShippingAddress()
	//==============================================================================
	public function setShippingAddress() {
		// Check for empty fields
		$json = array();
		$data = $this->load->language('checkout/checkout');
		
		foreach (array('firstname', 'lastname', 'address_1', 'city', 'postcode', 'country_id', 'zone_id') as $field) {
			if (empty($this->request->post[$field])) {
				if ($field == 'country_id') {
					$json['error'] = $data['error_country'];
				} elseif ($field == 'zone_id') {
					$json['error'] = $data['error_zone'];
				} else {
					$json['error'] = $data['error_' . $field];
				}
				echo json_encode($json);
				return;
			}
		}
		
		// Set address into session data
		$this->session->data['shipping_address'] = $this->request->post;
		
		$this->load->model('localisation/country');
		$country_info = $this->model_localisation_country->getCountry($this->request->post['country_id']);

		if ($country_info) {
			$this->session->data['shipping_address']['country'] = $country_info['name'];
			$this->session->data['shipping_address']['iso_code_2'] = $country_info['iso_code_2'];
			$this->session->data['shipping_address']['iso_code_3'] = $country_info['iso_code_3'];
			$this->session->data['shipping_address']['address_format'] = $country_info['address_format'];
		} else {
			$this->session->data['shipping_address']['country'] = '';
			$this->session->data['shipping_address']['iso_code_2'] = '';
			$this->session->data['shipping_address']['iso_code_3'] = '';
			$this->session->data['shipping_address']['address_format'] = '';
		}

		$this->load->model('localisation/zone');
		$zone_info = $this->model_localisation_zone->getZone($this->request->post['zone_id']);
		
		if ($zone_info) {
			$this->session->data['shipping_address']['zone'] = $zone_info['name'];
			$this->session->data['shipping_address']['zone_code'] = $zone_info['code'];
		} else {
			$this->session->data['shipping_address']['zone'] = '';
			$this->session->data['shipping_address']['zone_code'] = '';
		}
		
		if (version_compare(VERSION, '2.0', '<')) {
			$this->session->data['guest']['shipping'] = $this->session->data['shipping_address'];
		}
		
		$prefix = (version_compare(VERSION, '3.0', '<')) ? '' : 'payment_';
		$text = $this->config->get($prefix . 'stripe_quick_buy_shipping_text_' . $this->session->data['language']);
		$json['text'] = html_entity_decode($text, ENT_QUOTES, 'UTF-8');
		
		echo json_encode($json);
	}
	
	//==============================================================================
	// setShippingMethod()
	//==============================================================================
	public function setShippingMethod() {
		$this->session->data['comment'] = (!empty($this->request->post['comment'])) ? $this->request->post['comment'] : '';
		
		$shipping = explode('.', $this->request->post['shipping_method']);
		$this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping[0]]['quote'][$shipping[1]];
		
		$this->load->model('extension/payment/stripe');
		$order_info = $this->model_extension_payment_stripe->getOrderInfo();
		$this->session->data['order_id'] = $this->model_extension_payment_stripe->createOrder($order_info);
	}
}
?>