<?php
//==============================================================================
// Stripe Payment Gateway Pro v303.16
// 
// Author: Clear Thinking, LLC
// E-mail: johnathan@getclearthinking.com
// Website: http://www.getclearthinking.com
// 
// All code within this file is copyright Clear Thinking, LLC.
// You may not copy or reuse code within this file without written permission.
//==============================================================================

$version = 'v303.16';

//------------------------------------------------------------------------------
// Heading
//------------------------------------------------------------------------------
$_['heading_title']						= 'Stripe Payment Gateway Pro';
$_['text_stripe']						= '<a target="blank" href="https://dashboard.stripe.com"><img src="https://stripe.com/img/logo.png" alt="Stripe" title="Stripe" /></a>';

//------------------------------------------------------------------------------
// Extension Settings
//------------------------------------------------------------------------------
$_['tab_extension_settings']			= 'Extension Settings';
$_['heading_extension_settings']		= 'Extension Settings';

$_['entry_status']						= 'Status: <div class="help-text">Set the status for the extension as a whole.</div>';
$_['entry_sort_order']					= 'Sort Order: <div class="help-text">Enter the sort order for the extension, relative to other payment methods.</div>';
$_['entry_title']						= 'Title: <div class="help-text">Enter the title for the payment method displayed to the customer in the Payment Method area of checkout. HTML is supported.</div>';
$_['entry_terms']						= 'Terms: <div class="help-text">Optionally enter some payment terms that will display next to the title in ( and ) brackets. HTML is supported. This setting does not work on OpenCart 1.5.x.</div>';
$_['entry_card_input_format']			= 'Card Input Format: <div class="help-text">Choose whether to use a single combined field for the card inputs, or separate fields.</div>';
$_['text_combined']						= 'Combined';
$_['text_individual']					= 'Individual';
$_['entry_button_text']					= 'Button Text: <div class="help-text">Enter the text for the order confirmation button.</div>';
$_['entry_button_class']				= 'Button Class: <div class="help-text">Enter the CSS class for buttons in your theme.</div>';
$_['entry_button_styling']				= 'Button Styling: <div class="help-text">Optionally enter extra CSS styling for the button.</div>';
$_['entry_additional_css']				= 'Additional CSS: <div class="help-text">Add any additional CSS styling here. If your CSS does not seem to be applying, try adding <code>!important</code> at the end of the declarations, to override any other CSS styling.</div>';

// Payment Page Text
$_['heading_payment_page_text']			= 'Payment Page Text';
$_['entry_text_use_a_new_card']			= 'Use a New Card: <div class="help-text">HTML is supported.</div>';
$_['entry_new_card_image']				= 'New Card Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the "Use a New Card" text. A default image (encoded as base64 code) is included.</div>';
$_['entry_text_card_number']			= 'Card Number: <div class="help-text">This is only used if using individual card inputs. HTML is supported.</div>';
$_['entry_text_card_expiry']			= 'Card Expiry: <div class="help-text">This is only used if using individual card inputs. HTML is supported.</div>';
$_['entry_text_card_cvc']				= 'Card CVC: <div class="help-text">This is only used if using individual card inputs. HTML is supported.</div>';
$_['entry_text_store_card']				= 'Store Card for Future Use: <div class="help-text">HTML is supported.</div>';
$_['entry_text_use_a_stored_card']		= 'Use Your Stored Card: <div class="help-text">HTML is supported.</div>';
$_['entry_stored_card_image']			= 'Stored Card Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the "Use a Stored Card" text. A default image (encoded as base64 code) is included.</div>';
$_['entry_text_ending_in']				= 'ending in: <div class="help-text">HTML is supported. Used for stored cards, such as "Visa ending in 4242"</div>';
$_['entry_text_set_card_as_default']	= 'Set Card as Default: <div class="help-text">HTML is supported.</div>';
$_['entry_text_delete_this_card']		= 'Delete This Card: <div class="help-text">HTML is supported.</div>';
$_['entry_text_customer_required']		= 'Customer Required: <div class="help-text">Enter the text displayed when a non-logged-in customer (i.e. a guest) tries to check out with a subscription product in their cart. This will only be shown if the "Prevent Guests From Purchasing" setting is enabled.</div>';
$_['entry_text_to_be_charged']			= 'To Be Charged Later: <div class="help-text">This text is displayed for the line item on the order invoice when a subscription product has a trial. The line item subtracts the subscription price out of the total, so the customer is not double-charged.</div>';

// Please Wait Messages
$_['heading_please_wait_messages']		= 'Please Wait Messages';
$_['entry_text_please_wait']			= 'Default Please Wait: <div class="help-text">HTML is supported.</div>';
$_['entry_text_validating_payment_info']= 'Validating Payment Info: <div class="help-text">HTML is supported.</div>';
$_['entry_text_redirecting_to_payment']	= 'Redirecting to Payment Page: <div class="help-text">HTML is supported.</div>';
$_['entry_text_processing_payment']		= 'Processing Payment: <div class="help-text">HTML is supported.</div>';
$_['entry_text_finalizing_order']		= 'Finalizing Order: <div class="help-text">HTML is supported.</div>';

// Stripe Error Codes
$_['heading_stripe_error_codes']		= 'Stripe Error Codes';
$_['help_stripe_error_codes']			= 'HTML is supported. Leave any of these fields blank to display Stripe\'s default error message for that error code.';

$_['entry_error_card_declined']			= 'card_declined:';
$_['entry_error_expired_card']			= 'expired_card:';
$_['entry_error_incorrect_cvc']			= 'incorrect_cvc: <div class="help-text">This only occurs if your Stripe account is set to deny payments that fail CVC validation.</div>';
$_['entry_error_incorrect_number']		= 'incorrect_number:';
$_['entry_error_incorrect_zip']			= 'incorrect_zip: <div class="help-text">This only occurs if your Stripe account is set to deny payments that fail Zip Code validation.</div>';
$_['entry_error_invalid_cvc']			= 'invalid_cvc:';
$_['entry_error_invalid_expiry_month']	= 'invalid_expiry_month:';
$_['entry_error_invalid_expiry_year']	= 'invalid_expiry_year:';
$_['entry_error_invalid_number']		= 'invalid_number:';
$_['entry_error_missing']				= 'missing: <div class="help-text">This occurs when there is no card stored for a customer that is being charged.</div>';
$_['entry_error_processing_error']		= 'processing_error:';

// Cards Page Text
$_['heading_cards_page_text']			= 'Cards Page Text';

$_['entry_cards_page_heading']			= 'Cards Page Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_none']				= 'No Cards Message: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_default_card']		= 'Default Card Text: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_make_default']		= 'Make Default Button:';
$_['entry_cards_page_delete']			= 'Delete Button:';
$_['entry_cards_page_confirm']			= 'Confirmation Message:';
$_['entry_cards_page_add_card']			= 'Add New Card Button:';
$_['entry_cards_page_card_name']		= 'Name on Card: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_card_details']		= 'Card Details: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_card_address']		= 'Card Address: <div class="help-text">HTML is supported.</div>';
$_['entry_cards_page_success']			= 'Success Message:';

// Subscriptions Page Text
$_['heading_subscriptions_page_text']	= 'Subscriptions Page Text';

$_['entry_subscriptions_page_heading']	= 'Subscriptions Page Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_message']	= 'Default Card Message: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_none']		= 'No Subscriptions Message: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_trial']	= 'Trial End Text: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_last']		= 'Last Charge Text: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_next']		= 'Next Charge Text: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_charge']	= 'Additional Charge Text: <div class="help-text">HTML is supported.</div>';
$_['entry_subscriptions_page_pause']	= 'Pause Button:';
$_['entry_subscriptions_page_unpause']	= 'Unpause Button:';
$_['entry_subscriptions_page_cancel']	= 'Cancel Button:';
$_['entry_subscriptions_page_confirm']	= 'Cancel Confirmation: <div class="help-text">Enter the text displayed to the customer to confirm their cancellation of a subscription. The customer will be required to type <b>CANCEL</b> in order to confirm their cancellation.</div>';

//------------------------------------------------------------------------------
// Order Statuses
//------------------------------------------------------------------------------
$_['tab_order_statuses']				= 'Order Statuses';
$_['heading_order_statuses']			= 'Order Statuses';
$_['help_order_statuses']				= 'Choose the order statuses set when a payment meets each condition. You can refund a payment by using the link provided in the History tab for the order. Note: to actually <b>deny</b> payments that fail CVC or Zip Checks, you need to enable the appropriate setting in your Stripe admin panel.';

$_['entry_initial_status_id']			= 'Initial Status: <div class="help-text">This status will apply when the order is completed but payment is not yet verified. It is used by all non-card payment methods, and for the initial status set for all orders if you are using Stripe Checkout.</div>';
$_['entry_success_status_id']			= 'Successful Payment (Captured):';
$_['entry_authorize_status_id']			= 'Successful Payment (Authorized):';
$_['entry_mismatch_status_id']			= 'Successful Payment (Address Mismatch): <div class="help-text">This status will apply when the customer\'s shipping address does not match their billing address. It will override both of the two Successful Payment statuses set above. If you set the Charge Mode setting to "Authorize if possible fraudulent", then an address mismatch will also cause the payment to be authorized instead of captured.</div>';
$_['entry_error_status_id']				= 'Order Completion Error: <div class="help-text">This status will apply either when a non-card payment method fails, or when a card payment is completed successfully, but the order cannot be completed using the normal OpenCart order confirmation functions. This usually happens when you have entered incorrect SMTP settings in System > Settings > Mail, or you have installed modifications that affect customer orders.</div>';
$_['entry_review_status_id']			= 'Stripe Radar "Manual Review":';
$_['entry_elevated_status_id']			= 'Stripe Radar "Elevated" Risk:';
$_['entry_highest_status_id']			= 'Stripe Radar "Highest" Risk:';
$_['entry_street_status_id']			= 'Street Check Failure:';
$_['entry_zip_status_id']				= 'Zip Check Failure:';
$_['entry_cvc_status_id']				= 'CVC Check Failure:';
$_['entry_refund_status_id']			= 'Fully Refunded Payment:';
$_['entry_partial_status_id']			= 'Partially Refunded Payment:';

$_['text_ignore']						= '--- Ignore ---';

//------------------------------------------------------------------------------
// Restrictions
//------------------------------------------------------------------------------
$_['tab_restrictions']					= 'Restrictions';
$_['heading_restrictions']				= 'Restrictions';
$_['help_restrictions']					= 'Set the required cart total and select the eligible stores, geo zones, and customer groups for this payment method.';

$_['entry_min_total']					= 'Minimum Total: <div class="help-text">Enter the minimum order total that must be reached before this payment method becomes active. Leave blank to have no restriction.</div>';
$_['entry_max_total']					= 'Maximum Total: <div class="help-text">Enter the maximum order total that can be reached before this payment method becomes inactive. Leave blank to have no restriction.</div>';

$_['entry_stores']						= 'Store(s): <div class="help-text">Select the stores that can use this payment method.</div>';

$_['entry_geo_zones']					= 'Geo Zone(s): <div class="help-text">Select the geo zones that can use this payment method. The "Everywhere Else" checkbox applies to any locations not within a geo zone.</div>';
$_['text_everywhere_else']				= '<em>Everywhere Else</em>';

$_['entry_customer_groups']				= 'Customer Group(s): <div class="help-text">Select the customer groups that can use this payment method. The "Guests" checkbox applies to all customers not logged in to an account.</div>';
$_['text_guests']						= '<em>Guests</em>';

// Currency Settings
$_['heading_currency_settings']			= 'Currency Settings';
$_['help_currency_settings']			= 'Select the currencies that Stripe will charge in, based on the order currency. <a target="_blank" href="https://support.stripe.com/questions/which-currencies-does-stripe-support">See which currencies your country supports</a>';
$_['entry_currencies']					= 'When Orders Are In [currency], Charge In:';
$_['text_currency_disabled']			= '--- Disabled ---';

//------------------------------------------------------------------------------
// Stripe Settings
//------------------------------------------------------------------------------
$_['tab_stripe_settings']				= 'Stripe Settings';
$_['help_stripe_settings']				= 'Click "Connect with Stripe" to visit stripe.com and enable the extension to process payments via your Stripe account.';

// Connect with Stripe
$_['heading_connect_with_stripe']		= 'Connect with Stripe';

$_['button_connect_with_stripe']		= 'Connect with Stripe';
$_['entry_connection_status']			= 'Connection Status:';
$_['text_not_connected']				= 'Not Connected';
$_['text_connected']					= 'Connected';

$_['entry_live_publishable_key']		= 'Live Publishable Key:';
$_['entry_live_access_token']			= 'Live Secret Key:';
$_['entry_test_publishable_key']		= 'Test Publishable Key:';
$_['entry_test_access_token']			= 'Test Secret Key:';

// Stripe Settings
$_['heading_stripe_settings']			= 'Stripe Settings';

$_['entry_three_d_secure']				= '<div style="margin: -9px 0 9px">3D Secure:</div>';
$_['text_three_d_secure']				= '3D Secure is always enabled for card payments that are eligible. If you want to disable 3D Secure for some reason, you can disable it in your Stripe account, and in your Radar rules.';

$_['entry_webhook_url']					= 'Webhook URL: <div class="help-text">Copy and paste this URL into your Stripe account, in <a target="_blank" href="https://dashboard.stripe.com/webhooks">Developers > Webhooks</a>. Click "Add Endpoint" and then choose to receive "all events". Any events that my extension does not use will be ignored. You can choose any API version for the webhook URL, it will not affect my extension. The "key" for the URL is based on your store\'s Encryption Key in System > Settings > Server, so if you change that don\'t forget to also update the webhook URL in Stripe.</div>';

$_['entry_transaction_mode']			= 'Transaction Mode: <div class="help-text">Use "Test" to test payments through Stripe. For more info, visit <a href="https://stripe.com/docs/testing" target="_blank">https://stripe.com/docs/testing</a>. Use "Live" when you&apos;re ready to accept payments.</div>';
$_['text_test']							= 'Test';
$_['text_live']							= 'Live';

$_['entry_charge_mode']					= 'Charge Mode: <div class="help-text">Choose whether to authorize payments and manually capture them later, or to capture (i.e. fully charge) payments when orders are placed. For payments that are only Authorized, you can Capture them by using the link provided in the History tab for the order.<br><br>If you choose "Authorize if possibly fraudulent, Capture otherwise" then the extension will authorize the payment if (1) the Stripe Radar result is "review", or (2) Stripe Radar returns a risk level of "highest", or (3) your OpenCart anti-fraud extensions determine that the order might be fraudulent.</div>';
$_['text_authorize']					= 'Authorize';
$_['text_capture']						= 'Capture';
$_['text_fraud_authorize']				= 'Authorize if possibly fraudulent, Capture otherwise';

$_['entry_attempts']					= 'Maximum Number of Allowed Attempts: <div class="help-text">Enter the maximum number of payment attempts customers are allowed to try in one session. This helps prevent fraudsters from running lots of cards through your Stripe account to check if they are valid. Leave this field blank to have no maximum limit.</div>';
$_['entry_attempts_exceeded']			= 'Error When Exceeding Allowed Attempts: <div class="help-text">Enter the error message shown when a customer continues to make payment attempts after exceeding the allowed number of attempts set above.</div>';

$_['entry_transaction_description']		= 'Transaction Description: <div class="help-text">Enter the text sent as the Stripe transaction description. You can use the following shortcodes to enter information about the order: [store], [order_id], [amount], [email], [comment], [products]</div>';

$_['entry_send_customer_data']			= 'Send Customer Data: <div class="help-text">Sending customer data will create a customer in Stripe when an order is processed, based on the email address for the order. The credit card used will be attached to this customer, allowing you to charge them again in the future in Stripe.</div>';
$_['text_never']						= 'Never';
$_['text_customers_choice']				= 'Customer&apos;s choice';
$_['text_always']						= 'Always';

$_['entry_allow_stored_cards']			= 'Allow Customers to Use Stored Cards: <div class="help-text">If set to "Yes", customers that have cards stored in Stripe will be able to use those cards for future purchases in your store, without having to re-enter the information.</div>';
$_['entry_advanced_error_handling']		= 'Advanced Error Handling: <div class="help-text">Enabling this will catch errors that occur outside the extension, and record those into the order history. Quick checkout extensions sometimes have issues with this, so if you encounter problems with payments completing but orders not being confirmed, try disabling this setting.</div>';
$_['entry_always_send_receipts']		= 'Always Send Receipts From Stripe: <div class="help-text">Receipts are normally only sent from Stripe if the customer\'s info is stored in Stripe, and you have enabled receipt sending in your Stripe admin panel. If you set this to "Yes", then a receipt will always be sent to customers from Stripe, no matter what your settings are in the Stripe admin panel.</div>';
$_['entry_uncaptured_emails']			= 'Notify About Uncaptured Payments: <div class="help-text">If you want to notify administrators about any uncaptured payments, enter their e-mail addresses here, separated by commas. The extension will send out an e-mail once a day if any uncaptured transactions are found.</div>';
$_['entry_decline_code_emails']			= 'Notify About "fraudulent" Decline Codes: <div class="help-text">If you want to notify administrators about any declined payments that have the code "fraudulent", enter their e-mail addresses here, separated by commas.</div>';

//------------------------------------------------------------------------------
// Stripe Checkout
//------------------------------------------------------------------------------
$_['tab_stripe_checkout']				= 'Stripe Checkout';
$_['heading_stripe_checkout']			= 'Stripe Checkout';
$_['help_stripe_checkout_info']			= 'Stripe Checkout redirects the customer to Stripe.com for them to enter payment info. You can read more about it and view a demo at <a target="_blank" href="https://stripe.com/docs/payments/checkout">https://stripe.com/docs/payments/checkout</a>';

$_['entry_checkout']					= 'Use Stripe Checkout: <div class="help-text">Choose whether to use Stripe Checkout instead of accepting the payment on your website. Once the customer is finished with their transaction, they will be redirected back to your store. At this time, Stripe Checkout only supports these payment methods:<br><br><code>Apple Pay, Google Pay, Afterpay, Alipay, Bancontact, EPS, FPX, Giropay, iDEAL, Klarna, P24, SEPA, Sofort, WeChat Pay</code><br><br>Stripe Checkout does not support negative line items at this time, so if the order contains a discount then only the order total will be shown on the payment page.</div>';
$_['entry_checkout_instructions']		= 'Instructions: <div class="help-text">Optionally add any instructional text you want to display to the customer on the checkout page, before they are taken to stripe.com to complete the payment. HTML is supported.</div>';
$_['entry_checkout_billing_address']	= 'Require Billing Address: <div class="help-text">Stripe Checkout will always require the postcode for address verification, but if you want to require the full billing address on the stripe.com payment page (for example, to utilize the Street Address verification check), set this to "Yes".</div>';
$_['entry_checkout_phone_number']		= 'Require Phone Number: <div class="help-text">Enable this setting if you want Stripe Checkout to require that the customer fill in their phone number.</div>';
$_['entry_checkout_total']				= '"Total" Text: <div class="help-text">Enter the text used for "Total" on the payment page, if there is a discount on the order.</div>';
$_['entry_checkout_no_order_id']		= '"No Order ID" Error: <div class="help-text">Some quick checkouts do not properly create the order_id before loading the payment method, which can cause issues with the payment process. This error message will be shown if the order_id is not present when payment is attempted.</div>';
$_['entry_additional_webhook_urls']		= 'Additional Webhook URLs: <div class="help-text">If using a multi-store installation, you will need to enter these additional webhooks in your Stripe admin panel if you are using Stripe Checkout. You can add the URLs in <a target="_blank" href="https://dashboard.stripe.com/webhooks">Developers > Webhooks</a>. Click "Add Endpoint" and then choose to receive only this event: <code>checkout.session.completed</code></div>';

// Quick Buy Button
$_['heading_quick_buy_button']			= 'Quick Buy Button';
$_['entry_quick_buy_html']				= 'Button HTML: <div class="help-text">Enter the HTML for the quick buy button. Use [button_text] in place of the button text. Make sure you use an &lt;a&gt; tag for the button itself.</div>';
$_['entry_quick_buy_text']				= 'Button Text: <div class="help-text">HTML is supported.</div>';
$_['entry_quick_buy_address_text']		= '"Enter Your Shipping Address" Text: <div class="help-text">HTML is supported.</div>';
$_['entry_quick_buy_shipping_text']		= '"Choose Your Shipping Method" Text: <div class="help-text">HTML is supported.</div>';
$_['help_quick_buy_button']				= 'The "quick buy" button uses Stripe Checkout to complete a customer\'s order, without requiring them to go through the normal checkout process. This does not require Stripe Checkout to be enabled, so you can use the normal card form in the checkout if you prefer. Because the quick buy button uses Stripe Checkout, however, <b>make sure you have set up the webhook from the extension</b> in your Stripe account.<br><br>Since this also skips the normal checkout, any checkout-related customizations like payment fees, additional fields, or other modifications <b>will also be skipped</b>, so be aware of that.
<br><br>
The way the button works is as follows:
<br><br>
<ol>
	<li>If the customer clicks the button from the product page, it will add that item if it is not already in the cart, and then display a pop-up. If the customer clicks the button from the cart page, it will immediately display the pop-up.</li>
	<li>Within the pop-up, the first step will ask the customer to enter their shipping address. If the customer is logged in, it will preload their default address.</li>
	<li>Once the shipping address is entered, the customer can then choose a shipping rate from the enabled shipping methods, as usual.</li>
	<li>After the customer chooses their shipping rate, they will be redirected to Stripe Checkout to complete the payment.</li>
	<li>Upon completing the payment, the order will be created in OpenCart, and the customer will be returned to the checkout success page.</li>
</ol>';
$_['help_quick_buy_code']				= '<b>To add the quick buy button to the product page and/or cart page, embed the following code in the relevant template files where you want the button to appear:</b><br><br>
<code style="margin-left: 30px">
&lt;script id="quick-buy-script" src="catalog/view/javascript/quick_buy.js"&gt;&lt;/script&gt;
</code>';

//------------------------------------------------------------------------------
// Other Payment Methods
//------------------------------------------------------------------------------
$_['tab_other_payment_methods']			= 'Other Payment Methods';
$_['help_other_payment_methods']		= 'Other Payment Methods (with the exception of Apple Pay, Google Pay, and Microsoft Pay) cannot be stored or used with subscriptions at this time. These payment methods will be hidden if there is a subscription product in the cart.';

// General Settings
$_['heading_general_settings']			= 'General Settings';
$_['entry_delayed_payment_emails']		= 'Delayed Payment Notifications: <div class="help-text">If you want to notify administrators when a delayed payment is completed or fails, enter their e-mail addresses here, separated by commas.</div>';
$_['entry_error_page']					= 'Error Page HTML: <div class="help-text">Enter the HTML for the error page if any off-site payment authorization fails. Use [header] in place of your site header, [footer] in place of your site footer, and [error] for the error message returned by Stripe.</div>';

// Apple Pay
$_['heading_applepay']					= 'Apple Pay';
$_['entry_applepay']					= 'Apple Pay: <div class="help-text">You MUST be using an https page to use Apple Pay, even if you\'re in Test mode. You only need to <a target="_blank" href="https://dashboard.stripe.com/account/apple_pay">enable Apple Pay</a> for your Stripe account, you do not need to add your domain in there or upload the "domain association file" that Stripe asks you to. The domain will be auto-registered, and the domain association file will be uploaded to your server, when connecting your Stripe account to the extension.</div>';
$_['entry_reconnect_apple_pay']			= 'Reconnect Apple Pay: <div class="help-text">If Apple Pay does not seem to be working, you can use this button to try and reconnect Apple Pay to your site.</div>';
$_['button_reconnect_apple_pay']		= 'Reconnect Apple Pay';
$_['entry_applepay_heading']			= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_applepay_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';

// Google Pay
$_['heading_googlepay']					= 'Google Pay';
$_['entry_googlepay']					= 'Google Pay: <div class="help-text">You MUST be using an https page to use Google Pay, even if you\'re in Test mode.</div>';
$_['entry_googlepay_heading']			= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_googlepay_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';

// Microsoft Pay
$_['heading_microsoftpay']				= 'Microsoft Pay';
$_['entry_microsoftpay']				= 'Microsoft Pay: <div class="help-text">You MUST be using an https page to use Microsoft Pay, even if you\'re in Test mode.</div>';
$_['entry_microsoftpay_heading']		= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_microsoftpay_image']			= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';

// Afterpay
$_['heading_afterpay']					= 'Afterpay / Clearpay';
$_['entry_afterpay']					= 'Afterpay / Clearpay: <div class="help-text">Afterpay (also known as Clearpay in the UK) is only available for customers in the Australia, New Zealand, the United Kingdom, and the United States. Subscription payments are not supported. There are some other restrictions on Afterpay payments as well, which you can read here: <a target="_blank" href="https://stripe.com/docs/payments/afterpay-clearpay">https://stripe.com/docs/payments/afterpay-clearpay</a></div>';
$_['entry_afterpay_heading']			= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_afterpay_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_afterpay_instructions']		= 'Instructions: <div class="help-text">HTML is supported.</div>';

// Alipay
$_['heading_alipay']					= 'Alipay';
$_['entry_alipay']						= 'Alipay: <div class="help-text">Stripe\'s implementation of Alipay only works with mainland China bank accounts. Alipay payments will always be fully captured. Alipay requires that the customer has chosen one of these for their currency: AUD, CAD, EUR, GBP, HKD, JPY, NZD, SGD, or USD. Users in Denmark, Norway, Sweden, or Switzerland must use EUR.</div>';
$_['entry_alipay_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_alipay_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_alipay_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';

// Bancontact
$_['heading_bancontact']				= 'Bancontact';
$_['entry_bancontact']					= 'Bancontact: <div class="help-text">Bancontact payments will always be fully captured. Bancontact requires that the order is processed in EUR (based on your currency mappings in the Restrictions tab).</div>';
$_['entry_bancontact_heading']			= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_bancontact_image']			= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_bancontact_instructions']		= 'Instructions: <div class="help-text">HTML is supported.</div>';

// EPS
$_['heading_eps']						= 'EPS';
$_['entry_eps']							= 'EPS: <div class="help-text">EPS payments will always be fully captured. EPS requires that the order is processed in EUR (based on your currency mappings in the Restrictions tab).</div>';
$_['entry_eps_heading']					= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_eps_image']					= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_eps_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';

// FPX
$_['heading_fpx']						= 'FPX';
$_['entry_fpx']							= 'FPX: <div class="help-text">FPX payments will always be fully captured, and requires that the customer\'s billing address is within Malaysia and the order is in MYR.</div>';
$_['entry_fpx_heading']					= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_fpx_image']					= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';

// Giropay
$_['heading_giropay']					= 'Giropay';
$_['entry_giropay']						= 'Giropay: <div class="help-text">Giropay payments will always be fully captured. Giropay requires that the order is processed in EUR (based on your currency mappings in the Restrictions tab).</div>';
$_['entry_giropay_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_giropay_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_giropay_instructions']		= 'Instructions: <div class="help-text">HTML is supported.</div>';

// iDEAL
$_['heading_ideal']						= 'iDEAL';
$_['entry_ideal']						= 'iDEAL: <div class="help-text">iDEAL payments will always be fully captured. iDEAL requires that the order is processed in EUR (based on your currency mappings in the Restrictions tab).</div>';
$_['entry_ideal_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_ideal_image']					= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_ideal_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';

// Klarna
$_['heading_klarna']					= 'Klarna';
$_['entry_klarna']						= 'Klarna: <div class="help-text">Klarna requires that you have a Stripe account in Austria, Denmark, Germany, Finland, the Netherlands, Norway, Sweden, the United Kingdom, or the United States. U.S. accounts can only accept Klarna payments from U.S. customers. For more info see <a target="_blank" href="https://stripe.com/docs/sources/klarna">this page</a>.</div>';
$_['entry_klarna_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_klarna_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_klarna_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';
$_['entry_klarna_payment_choice']		= '"Payment Choice" Text: <div class="help-text">Enter the text for the setting that allows the customer to choose whether to pay later, pay over time, or pay now. HTML is supported.</div>';
$_['entry_klarna_pay_later']			= '"Pay Later" Text: <div class="help-text">Leave blank to disable this option.</div>';
$_['entry_klarna_pay_over_time']		= '"Pay Over Time" Text: <div class="help-text">Leave blank to disable this option.</div>';
$_['entry_klarna_pay_now']				= '"Pay Now" Text: <div class="help-text">Leave blank to disable this option.</div>';

// Multibanco
$_['heading_multibanco']				= 'Multibanco';
$_['entry_multibanco']					= 'Multibanco: <div class="help-text">Multibanco payments require action on the customer\'s end, so the order will always be initially approved with the order status set below. Multibanco requires that the customer has chosen EUR for their currency.</div>';
$_['entry_multibanco_heading']			= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_multibanco_image']			= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_multibanco_instructions']		= 'Instructions: <div class="help-text">HTML is supported.</div>';
$_['entry_multibanco_status']			= 'Order Status: <div class="help-text">Choose the order status initially assigned to the order.</div>';

// P24
$_['heading_p24']						= 'P24';
$_['entry_p24']							= 'P24: <div class="help-text">P24 payments will always be fully captured. P24 requires that the customer has chosen EUR or PLN for their currency.</div>';
$_['entry_p24_heading']					= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_p24_image']					= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_p24_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';

// Secure Remote Commerce
$_['heading_secure_remote_commerce']			= 'Secure Remote Commerce';
$_['entry_secure_remote_commerce']				= 'Secure Remote Commerce: <div class="help-text">This shows up as "Click to Pay" when chosen by the customer. You can find test cards <a target="_blank" href="https://developer.mastercard.com/masterpass/documentation/migration/masterpass_to_src_migration/#mastercard-test-cards">on this page</a> (choose the "tokenized" ones). When enabling Secure Remote Commerce in your Stripe admin panel, use the following URL for both the Sandbox and Production Callback URLs:<br><br><code>' . HTTPS_CATALOG . 'index.php?route=extension/payment/stripe/src</code></div>';
$_['entry_secure_remote_commerce_heading']		= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_secure_remote_commerce_image']		= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_secure_remote_commerce_checkout_id']	= 'Checkout ID: <div class="help-text">You can find your Secure Remote Commerce Checkout ID in <a target="_blank" href="https://dashboard.stripe.com/payments/settings">your Stripe account</a></div>';

// SEPA Direct Debit
$_['heading_sepa']						= 'SEPA Direct Debit';
$_['entry_sepa']						= 'SEPA: <div class="help-text">SEPA payments will always be fully captured, and requires that the customer\'s billing address is within the EU and the order is in EUR. SEPA payments are delayed, so the order will initially complete and then be updated later when the payment is confirmed. You can assign the initial order status for the order in the Order Statuses tab at the very top.</div>';
$_['entry_sepa_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_sepa_image']					= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';

// Sofort
$_['heading_sofort']					= 'Sofort';
$_['entry_sofort']						= 'Sofort: <div class="help-text">Sorfort payments will always be fully captured, and requires that the customer\'s billing address is within the EU and the order is in EUR. Sofort payments are delayed, so the order will initially complete and then be updated later when the payment is confirmed. You can assign the initial order status for the order in the Order Statuses tab at the very top.</div>';
$_['entry_sofort_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_sofort_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_sofort_instructions']			= 'Instructions: <div class="help-text">HTML is supported.</div>';

// WeChat Pay
$_['heading_wechat']					= 'WeChat Pay';
$_['entry_wechat']						= 'WeChat Pay: <div class="help-text">Stripe\'s implementation of WeChat Pay only works with mainland China bank accounts. WeChat Pay payments will always be fully captured. WeChat Pay requires that the customer has chosen one of these for their currency: AUD, CAD, EUR, GBP, HKD, JPY, SGD, or USD.</div>';
$_['entry_wechat_heading']				= 'Heading: <div class="help-text">HTML is supported.</div>';
$_['entry_wechat_image']				= 'Image: <div class="help-text">Optionally enter an &lt;img&gt; tag for an icon that shows up to the left of the Heading name. A default image (encoded as base64 code) is included.</div>';
$_['entry_wechat_instructions']			= 'Instructions: <div class="help-text">HTML is supported. The instructions will be replaced by the QR code for payment once the customer clicks the "Confirm Order" button.</div>';

//------------------------------------------------------------------------------
// Subscription Products
//------------------------------------------------------------------------------
$_['tab_subscription_products']			= 'Subscription Products';
$_['help_subscription_products']		= '
<ul>
	<li>Subscription products will subscribe the customer to the associated Stripe pricing plan when they are purchased. You can associate a product with a pricing plan by entering the Stripe <b>Pricing Plan ID</b> (not the Product ID) in the "Location" field for the product.</li><br>
	<li>If the subscription is not set to be charged immediately (i.e. it has a trial period), the amount of the subscription will be taken off their original order, and a new order will be created when the subscription is actually charged to their card.</li><br>
	<li>Any time Stripe charges the subscription in the future, a corresponding order will be created in OpenCart. You can choose whether the order uses the customer\'s default address in OpenCart or the customer\'s address in Stripe below.</li><br>
	<li>If you have a coupon set up in your Stripe account, you can map an OpenCart coupon to it by using the same coupon code and discount amount. Use the OpenCart coupon code for the <b>coupon ID</b> when creating the coupon in Stripe. When a customer purchases a subscription product and uses that coupon code, it will pass the code to Stripe to properly adjust the subscription charge.</li><br>
	<li class="text-danger">Subscriptions made with cards using 3D Secure will require the customer to return to Stripe in order to validate their payment info when the card is charged in the future. Make sure you have set up e-mails with a "Stripe-hosted link" to go out to customers, as described <a target="_blank" href="https://stripe.com/docs/billing/migration/strong-customer-authentication#3ds-payment-settings">on this page</a>.</li>
</ul>	
';

// Subscription Product Settings
$_['heading_subscription_products']		= 'Subscription Product Settings';
$_['entry_subscriptions']				= 'Enable Subscription Products:';

$_['entry_subscription_order_report']	= 'Subscription Order Report: <div class="help-text">This will display a list of all orders that were placed for subscription products.</div>';
$_['button_view_report']				= 'View Report';
$_['heading_subscription_order_report']	= 'Subscription Order Report';
$_['column_order_id']					= 'Order ID';
$_['column_customer']					= 'Customer';
$_['column_status']						= 'Status';
$_['column_total']						= 'Total';
$_['column_date_added']					= 'Date Added';
$_['column_date_modified']				= 'Date Modified';
$_['column_action']						= 'Action';

$_['entry_prevent_guests']				= 'Prevent Guests From Purchasing: <div class="help-text">If set to "Yes", only customers with accounts in OpenCart will be allowed to checkout if a subscription product is in the cart.</div>';

$_['entry_order_address']				= 'Subscription Order Shipping Address: <div class="help-text">Choose the address to use for the shipping address on orders created when a subscription is charged. The billing address on subscription orders will always be the address on the card used for payment.<br><br>A customer\'s "Stripe address" will be changed whenever they use a stored card, store a new card, or purchase a subscription product. A customer\'s "OpenCart address" will be changed when they modify their default address in OpenCart. The "original order address" will always be the address that was used for the initial subscription order.</div>';
$_['text_stripe_address']				= 'Use Stripe address';
$_['text_opencart_address']				= 'Use OpenCart address';
$_['text_original_address']				= 'Use original order address';

// Advanced Subscription Settings
$_['heading_advanced_subscription_settings'] = 'Advanced Subscription Settings';
$_['entry_include_shipping']			= 'Include Shipping: <div class="help-text">This setting does not work with Stripe Checkout. If set to "Yes" and there is a shipping cost on the order, a Stripe invoice item for the product\'s shipping cost will be created. Every time the subscription is charged in the future, a new invoice item will be created for the following charge date, with the same shipping cost.</div>';
$_['entry_merge_subscriptions']			= 'Merge Subscriptions: <div class="help-text">This setting does not work with Stripe Checkout. If set to "Yes", when customers purchase multiple subscriptions at the same time, they will be combined into a single invoice for the customer. Do not use this setting when subscriptions have different charge periods, trial lengths, start dates, or cycles.</div>';
$_['entry_allow_customers_to_pause']	= 'Allow Customers to Pause Subscriptions: <div class="help-text">Choose "Yes" for this setting to allow customers to pause or unpause their subscription at any time, on the <a target="_blank" href="../index.php?route=extension/cards">Cards & Subscriptions page</a>.</div>';
$_['entry_allow_customers_to_cancel']	= 'Allow Customers to Cancel Subscriptions: <div class="help-text">Choose "Yes" for this setting to allow customers to cancel their subscription at any time, on the <a target="_blank" href="../index.php?route=extension/cards">Cards & Subscriptions page</a>.</div>';

$_['entry_transfer_subscriptions']		= 'Transfer Subscriptions: <div class="help-text">You can use this function to transfer all customers from one Pricing Plan to another Pricing Plan. No one will be left on the old Pricing Plan ID that you enter, so only use this function if you plan on discontinuing the old plan. This function will take approximately 1 second per subscription, so if you have a lot of subscriptions it may take some time to transfer them all.</div>';
$_['button_transfer_subscriptions']		= 'Transfer Subscriptions';
$_['text_old_pricing_plan_id']			= 'Old Pricing Plan ID:';
$_['text_new_pricing_plan_id']			= 'New Pricing Plan ID:';
$_['button_transfer']					= 'Transfer';

// Current Subscription Products
$_['heading_current_subscriptions']		= 'Current Subscription Products';
$_['entry_current_subscriptions']		= 'Current Subscription Products: <div class="help-text">Products with mismatching prices are highlighted. The customer will always be charged the Stripe plan price, not the OpenCart product price, so you should make sure the price in OpenCart corresponds to the price in Stripe.<br><br>Note: only plans for your Transaction Mode will be listed. You are currently set to "[transaction_mode]" mode.</div>';

$_['text_thead_opencart']				= 'OpenCart';
$_['text_thead_stripe']					= 'Stripe';
$_['text_product_name']					= 'Product Name';
$_['text_product_price']				= 'Product Price';
$_['text_location_plan_id']				= 'Location / Plan ID';
$_['text_plan_name']					= 'Plan Name';
$_['text_plan_interval']				= 'Plan Interval';
$_['text_plan_charge']					= 'Plan Charge';
$_['text_no_subscription_products']		= 'No Subscription Products';
$_['text_create_one_by_entering']		= 'Create one by entering the Stripe pricing plan ID in the "Location" field for the product';

// Map Options to Subscriptions
$_['heading_map_options']				= 'Map Options to Subscriptions';
$_['help_map_options']					= 'If the customer has a product with the appropriate option name and option value in their cart, they will be subscribed to the corresponding plan ID. This will override the plan ID in the Location field for that product.<br><br>The "Start Date" field lets you force a particular start date for the subscription, rather than start it immediately, or after its trial period. Leave the "Start Date" field blank to have the subscription start based on its own settings.<br><br>The "Cycles" field lets you limit a subscription to a certain number of cycles. For example, if you enter 5 and the subscription is monthly, it will only charge the customer for the subscription 5 times, and then cancel the subscription. Leave the "Cycles" field blank to have no limitation.';

$_['column_action']						= 'Action';
$_['column_option_name']				= 'Option Name';
$_['column_option_value']				= 'Option Value';
$_['column_currency']					= 'Currency';
$_['column_plan_id']					= 'Plan ID';
$_['column_start_date']					= 'Start Date';
$_['column_cycles']						= 'Cycles';

$_['text_all']							= '--- All ---';
$_['button_add_mapping']				= 'Add Mapping';

// Map Recurring Profiles to Subscriptions
$_['heading_map_recurring_profiles']	= 'Map Recurring Profiles to Subscriptions';
$_['help_map_recurring_profiles']		= 'If the customer has a product with the appropriate recurring profile name in their cart, they will be subscribed to the corresponding plan ID. This will override the plan ID in the Location field for that product. The subscription frequency and charge amount is determined by the Stripe pricing plan, not the recurring profile settings, so make sure they match exactly.<br><br>The "Start Date" field lets you force a particular start date for the subscription, rather than start it immediately, or after its trial period. Leave the "Start Date" field blank to have the subscription start based on its own settings.<br><br>The "Cycles" field lets you limit a subscription to a certain number of cycles. For example, if you enter 5 and the subscription is monthly, it will only charge the customer for the subscription 5 times, and then cancel the subscription. Leave the "Cycles" field blank to have no limitation.';

$_['column_profile_name']				= 'Recurring Profile Name';

//------------------------------------------------------------------------------
// Create a Charge
//------------------------------------------------------------------------------
$_['tab_create_a_charge']				= 'Create a Charge';

$_['help_charge_info']					= 'After entering the charge info below, you will be redirected to Stripe to complete the payment. If you would like the customer to complete the payment, you can copy that URL and e-mail it to them.';
$_['heading_charge_info']				= 'Charge Info';

$_['entry_order_id']					= 'Order ID: <div class="help-text">This setting is optional. If filled in, an order history note will be added to the order regarding the payment. This will not work if setting your own custom Cancel URL and Success URL.</div>';
$_['entry_order_status']				= 'Order Status Change: <div class="help-text">This setting is optional. If set, and an Order ID value is set, then the order\'s status will be changed after the payment is successfully processed. This will not work if setting your own custom Cancel URL and Success URL.</div>';
$_['entry_description']					= 'Description: <div class="help-text">This setting is optional. This will be shown in your Stripe admin panel, and on the customer receipt if you have Stripe set to send them an e-mail receipt.</div>';
$_['entry_statement_descriptor']		= 'Statement Descriptor: <div class="help-text">This setting is optional. This will be shown on the customer\'s bank statement for the charge. It is a maximum of 22 characters. Note that not all banks respect the value that Stripe passes, so there is no guarantee this will be shown exactly as you\'ve written. The following characters are prohibited: < > " \'</div>';
$_['entry_cancel_url']					= 'Cancel URL: <div class="help-text">If you want to send the link to a customer, fill in this field with the URL to which they will be redirected if they cancel the payment. Make sure it is a valid URL including http or https. Leave blank to return to this page.</div>';
$_['entry_success_url']					= 'Success URL: <div class="help-text">If you want to send the link to a customer, fill in this field with the URL to which they will be redirected if the payment is successful. Make sure it is a valid URL including http or https. Leave blank to return to this page.</div>';
$_['entry_amount']						= 'Amount:';

$_['button_create_charge']				= 'Create Charge';

//------------------------------------------------------------------------------
// Standard Text
//------------------------------------------------------------------------------
$_['copyright']							= '<hr /><div class="text-center" style="margin: 15px">' . $_['heading_title'] . ' (' . $version . ') &copy; <a target="_blank" href="http://www.getclearthinking.com/contact">Clear Thinking, LLC</a></div>';

$_['standard_autosaving_enabled']		= 'Auto-Saving Enabled';
$_['standard_confirm']					= 'This operation cannot be undone. Continue?';
$_['standard_error']					= '<strong>Error:</strong> You do not have permission to modify ' . $_['heading_title'] . '!';
$_['standard_max_input_vars']			= '<strong>Warning:</strong> The number of settings is close to your <code>max_input_vars</code> server value. You should enable auto-saving to avoid losing any data.';
$_['standard_please_wait']				= 'Please wait...';
$_['standard_saved']					= 'Saved!';
$_['standard_saving']					= 'Saving...';
$_['standard_select']					= '--- Select ---';
$_['standard_success']					= 'Success!';
$_['standard_testing_mode']				= "Your log is too large to open! If you need to archive it, you can download it using the button above.\n\nTo start a new log, (1) click the Clear Log button, (2) reload the admin panel page, then (3) run your test again.";

$_['standard_module']					= 'Modules';
$_['standard_shipping']					= 'Shipping';
$_['standard_payment']					= 'Payments';
$_['standard_total']					= 'Order Totals';
$_['standard_feed']						= 'Feeds';

//------------------------------------------------------------------------------
// Payment Methods Icons
//------------------------------------------------------------------------------
$_['new_card_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['stored_card_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['applepay_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['googlepay_image'] = '<img height="16" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAKumlDQ1BJQ0MgUHJvZmlsZQAASImVlwdUU9kWhs+9N73QEhCQEnoTpFcpoYcuHWyEJJBQYkwIKqKiIo7giCIighUdEFFwLICMBbFgYVCwYJ8gg4A6DhZsqLwLPMLMe+u9t95e69z7rX332Xufs85Z678AUD6xRaIMWAmATGGWODLAmxGfkMjA9wEIIIAI6IDA5khEzIiIEIDa1Pvv9uEeGo3abcvxXP/+/b+aMpcn4QAARaCczJVwMlE+iQ4ZRyTOAgApRf0GS7NE49yMMl2MNohyxzinTrJsnJMn+f1ETHSkDwAYAgAECpstTgWAQkf9jGxOKpqHYo+ytZArEKLMRdmDw2ejb8pBlGdlZi4e51somyb/JU/q33Imy3Oy2alynlzLhBF8BRJRBnv5/7kd/9syM6RTNYzRQeGLAyPH66F7dj99cbCchclh4VMs4E72NM58aWDMFHMkPolTzGX7BsvnZoSFTHGKwJ8lz5PFip5insQvaorFiyPltVLEPswpZoun60rTY+R+Po8lz5/Dj46b4mxBbNgUS9KjgqdjfOR+sTRS3j9PGOA9XddfvvZMyV/WK2DJ52bxowPla2dP988TMqdzSuLlvXF5vn7TMTHyeFGWt7yWKCNCHs/LCJD7JdlR8rlZ6IGcnhsh38M0dlDEFAMBCAVswMniLcsab95nsWi5WJDKz2Iw0VvFY7CEHKtZDFtrGxcAxu/o5BF4d3/i7kFqhGmf5A4ArujZgITTvoUFALQ4AUD7Y9pnmAsA+QAAZ7s5UnH2pA8z/sACElBE774G0AEGwBRYAlvgCNyAF/ADQSAcRIMEsBBwAB9kAjFYCnLBGlAAisAWsB1UgL3gADgEjoLjoAmcARfAFXAD3AJ3wSMgA/3gJRgGH8AoBEF4iArRIA1IFzKCLCBbyBnygPygECgSSoCSoFRICEmhXGgdVASVQBXQfqgW+hk6DV2ArkFd0AOoFxqC3kJfYASmwHRYGzaGZ8POMBMOhqPhBXAqvATOgfPhzXA5XAUfgRvhC/AN+C4sg1/CIwhAyIgaoodYIs6IDxKOJCIpiBhZhRQiZUgVUo+0IO3IbUSGvEI+Y3AYGoaBscS4YQIxMRgOZglmFWYTpgJzCNOIuYS5jenFDGO+Y6lYLawF1hXLwsZjU7FLsQXYMmw19hT2MvYuth/7AYfDqeFMcE64QFwCLg23ArcJtxvXgGvFdeH6cCN4PF4Db4F3x4fj2fgsfAF+J/4I/jy+G9+P/0QgE3QJtgR/QiJBSFhLKCMcJpwjdBMGCKNEJaIR0ZUYTuQSlxOLiQeJLcSbxH7iKEmZZEJyJ0WT0khrSOWketJl0mPSOzKZrE92Ic8lC8h55HLyMfJVci/5M0WFYk7xocynSCmbKTWUVsoDyjsqlWpM9aImUrOom6m11IvUp9RPCjQFKwWWAldhtUKlQqNCt8JrRaKikSJTcaFijmKZ4gnFm4qvlIhKxko+SmylVUqVSqeVepRGlGnKNsrhypnKm5QPK19THlTBqxir+KlwVfJVDqhcVOmjITQDmg+NQ1tHO0i7TOun4+gmdBY9jV5EP0rvpA+rqqjaq8aqLlOtVD2rKlND1IzVWGoZasVqx9XuqX2ZoT2DOYM3Y+OM+hndMz6qz1T3UuepF6o3qN9V/6LB0PDTSNfYqtGk8UQTo2muOVdzqeYezcuar2bSZ7rN5MwsnHl85kMtWMtcK1JrhdYBrQ6tEW0d7QBtkfZO7Yvar3TUdLx00nRKdc7pDOnSdD10Bbqluud1XzBUGUxGBqOccYkxrKelF6gn1duv16k3qm+iH6O/Vr9B/4kBycDZIMWg1KDNYNhQ1zDUMNewzvChEdHI2YhvtMOo3eijsYlxnPEG4ybjQRN1E5ZJjkmdyWNTqqmn6RLTKtM7ZjgzZ7N0s91mt8xhcwdzvnml+U0L2MLRQmCx26JrFnaWyyzhrKpZPZYUS6ZltmWdZa+VmlWI1VqrJqvXsw1nJ87eOrt99ndrB+sM64PWj2xUbIJs1tq02Ly1Nbfl2Fba3rGj2vnbrbZrtntjb2HPs99jf9+B5hDqsMGhzeGbo5Oj2LHeccjJ0CnJaZdTjzPdOcJ5k/NVF6yLt8tqlzMun10dXbNcj7v+6Wbplu522G1wjskc3pyDc/rc9d3Z7vvdZR4MjySPfR4yTz1PtmeV5zMvAy+uV7XXANOMmcY8wnztbe0t9j7l/dHH1WelT6sv4hvgW+jb6afiF+NX4ffUX98/1b/OfzjAIWBFQGsgNjA4cGtgD0ubxWHVsoaDnIJWBl0KpgRHBVcEPwsxDxGHtITCoUGh20IfhxmFCcOawkE4K3xb+JMIk4glEb/Mxc2NmFs593mkTWRuZHsULWpR1OGoD9He0cXRj2JMY6QxbbGKsfNja2M/xvnGlcTJ4mfHr4y/kaCZIEhoTsQnxiZWJ47M85u3fV7/fIf5BfPvLTBZsGzBtYWaCzMWnl2kuIi96EQSNiku6XDSV3Y4u4o9ksxK3pU8zPHh7OC85HpxS7lDPHdeCW8gxT2lJGUw1T11W+oQ35Nfxn8l8BFUCN6kBabtTfuYHp5ekz6WEZfRkEnITMo8LVQRpgsvLdZZvGxxl8hCVCCSLXFdsn3JsDhYXC2BJAskzVl0VAx1SE2l66W92R7ZldmflsYuPbFMeZlwWcdy8+Ublw/k+Of8tAKzgrOiLVcvd01u70rmyv2roFXJq9pWG6zOX92fF5B3aA1pTfqaX9dary1Z+35d3LqWfO38vPy+9QHr6woUCsQFPRvcNuz9AfOD4IfOjXYbd278XsgtvF5kXVRW9HUTZ9P1H21+LP9xbHPK5s5ix+I9W3BbhFvubfXceqhEuSSnpG9b6LbGUkZpYen77Yu2XyuzL9u7g7RDukNWHlLevNNw55adXyv4FXcrvSsbdmnt2rjr427u7u49Xnvq92rvLdr7ZZ9g3/39Afsbq4yryg7gDmQfeH4w9mD7T84/1VZrVhdVf6sR1sgORR66VOtUW3tY63BxHVwnrRs6Mv/IraO+R5vrLev3N6g1FB0Dx6THXvyc9PO948HH2044n6g/aXRy1ynaqcJGqHF543ATv0nWnNDcdTrodFuLW8upX6x+qTmjd6byrOrZ4nOkc/nnxs7nnB9pFbW+upB6oa9tUduji/EX71yae6nzcvDlq1f8r1xsZ7afv+p+9cw112unrztfb7rheKOxw6Hj1K8Ov57qdOxsvOl0s/mWy62Wrjld57o9uy/c9r195Q7rzo27YXe77sXcu98zv0d2n3t/8EHGgzcPsx+OPsp7jH1c+ETpSdlTradVv5n91iBzlJ3t9e3teBb17FEfp+/l75Lfv/bnP6c+LxvQHagdtB08M+Q/dOvFvBf9L0UvR18V/KH8x67Xpq9P/un1Z8dw/HD/G/Gbsbeb3mm8q3lv/75tJGLk6YfMD6MfCz9pfDr02flz+5e4LwOjS7/iv5Z/M/vW8j34++OxzLExEVvMnpACCDrglBQA3tYAQE1AtQOqiUnzJjX0hEGTun+CwH/iSZ09YY4A1LQCMC61gvMA2DclYdER4QVAtBeA7ezk458mSbGzncxFbkKlSdnY2DtUL+LNAPjWMzY22jQ29q0abfYhAK0fJrX7uOHQP5p65P3rPcU3wzbngX+xfwAt/w+B1H5IEgAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAx1pVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgICAgICAgICAgeG1sbnM6ZXhpZj0iaHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iPgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAxOS0wNS0xM1QxMzoyMToyMzwveG1wOk1vZGlmeURhdGU+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+Rmx5aW5nIE1lYXQgQWNvcm4gNS42LjY8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+MTQ0PC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpDb21wcmVzc2lvbj41PC90aWZmOkNvbXByZXNzaW9uPgogICAgICAgICA8dGlmZjpYUmVzb2x1dGlvbj4xNDQ8L3RpZmY6WFJlc29sdXRpb24+CiAgICAgICAgIDxleGlmOlBpeGVsWERpbWVuc2lvbj42NjwvZXhpZjpQaXhlbFhEaW1lbnNpb24+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj42MjwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgpQ7aDbAAAG6klEQVRIDX1WW2wcVxk+t7nsLbtZx47bZOOkhTYqxmlU2gSCEiuUIqomlZrSi6o8lAfyUgRC4vaEEA8BIYGEoBWoIAgIitSWhz5QoZL0QnAuTVRXFTElifGlSRx7fdm1vbM7Z87h+2d212vH4td4dub/z/99/+2cMbfWslvFGCZEoo7mZvXkeP29i3ps1CzM2yDg2azc3Ov173L7d8liF3ddWhlF5ML5GjC+DgGWSgmHYPgicGtvvqGvXmFKJf4AIBf8hQ3Ztcn/1B5v7z7//r2ysBFKQl/NcQtBHHs4Nlr944ng7OmoXBYI0HGazp3hAcgYG9SY63n9A5nDR9IHP0920HRw3ELA2PLJv1V//5vGhyMik6VUQLluGZNgOcrCTKUicrnsY0/knnhGIJUO6SCImRdf/tPCiy/Yep37KWailayToAyKEAeIV6xvEXPHsY2GbdSL3z+eHozzaHGo5kNcmcVX/7zwq1+g+tzzWKSbJrROa/gza5hyKH0dErRymu3lHJ1nnpc/9tXUvsEWcvM3JojR68MXKyd+bcOQ0KGBxFHbpSWxcaPq2666e+XtW7jnRlM39NQNU57RU9c5KNF/Zjc882zu8afIK64EPcSiKC4h4DD/sx+bchkjSAOXCHqodeoLD6cHP+d98l6RLzT1VCYbjlwKzg0tvvKSrVbzX/9m9vARsq5GhwIEiJQFb70eXr3K0dU2OpZKmXv6aP7ZY82p6DBxKd2d9+By+naEk+OEjvWQpFX01BSabrt8RaZ+5+7Qjf9ajnRpr3DEXjj2XPbxp2khoNEJTFRbABeXMXXgYKqtvAUdFtquZvotoS7nn7LpB5aAzKy09SD76JEmOoAA3XImZFyMGy7oilBH2g+kSUyte5KSstGiKZ9hLM2kyRyMnJKt/lXKrr7MI49SZJhU0RF4XINVp4GMT5QWPbmsFmXrZbs8wYRiEXXD68e9bDOHnDvvivu/Ch1BXV8wDW1XcaxGpLd4k/gO79kgFG/M2voM4wkQJlq7OzeoTwzEXhjW5pGXgESG/fyNYHwmkuL/USCfMLLbN4nvPJJGiZZZtMSYQ7MHiwm5c7vI9seBrEKHBtldnzdjZatEUuGEd+2dYAwLQspVWaMZLunGc4bcIqbSzOuJndYJ05HMVUytpV7LYek4tmi7oqhxxUPcBLWw1NfBboGQCX8rLmTAWzupxEg9BQEXLsPVNFqLZuiqCCat142DsD2dLXDW0MjdKkPGTkFTVMdAwOoqjqMW2eaYyrNwAf2EVkk3DK7NzA1vyu+2NqIlHYJUt3UJ3JPhTCzwAvpi3ZYXW1+vuAc5H5Xkirtd3O+xmCUuHWYalv+2mpsZn/hWSXvSwa5DBdsUwH3uQT9snVWJXhtbzIgTp4OXzjTSLm03OGDeunPClSiRW+S5u+zc+77rTmjxy6Xe040N6saVA9cu7C/tQUgcAbcETxjt1tvKL6ZldNogleZSZGBtqSg8BxUQruj6bMT0iHZ/UN16ql6UQtUalVc/fH16eVZwEc/CChZQ2kdChNM2PpFePt8YuqyzPqfGxhMApjt6JDIW0Mjuz/yjcOgb5Z4RXfA5nSu+8s5fH/7R2eena2XJ0RsANeuCfFBxjJ2xtN2UEMPj+i8XGp6i4kBgDULWt0nsKlHT4YzBL0Zbjoaq4DB8xShLJOhLb+ijCz8cen745iW0VQkJYm00mCKD5pMmjIK//+fy8dfqNytWyVaHaV7t4d1uqQsu6AECZPaL2+57c/Sek2NDBS8XoQo0wTal/LPX3hudn7h3c//+bQ8cKO1RdJqTzNTm3pk8PzT57vtTYzVxv6eetAYnrkYotdDe3Sv3342jgYQ++ogXhqnl6e+989MPpv/tKbcdDHoQmnA5DIqpwo781qybVVzWomCutjBeuVbTQcbFKDJT3Scqh4TeGtkQu+FrD/kPD7gIn4qZYCF9YI3MXvn2qePl2pxPHJQEhUB7QaA4ga7jHxhUEFrUx5Mu2gOUeFlD6C3RzFFe33ls0H1yr4c1yUQ1CQAEJmCB4yfnXvxgegR5oCAgbtIQUeJCvlC2s0SUCC4wi57teaz03a/suwNJrENAHPG2mq7NvnDxD29PnKmFtZTjY2oMvmDEA6+mxFREmdSwrhubM91fHvjSoY8dxFS20bF6JYPENakVRuXk2OlT40P//OhCoANMFICSDKiqdHJRAqgb2nBbtuehHfsHS58e6NkJkE70dQigSjjwsBQuXypffnvi3PDNf80HC4HGhtUAVkI5QnnS6ytsva+3f89tuz++cTvWE2erjnhNZG0GiTYOEKNFpwL45oLKTG12PqjUo7oxxnd8THDey3Wnixknnbi0w0pe2/f/AQf9mTS5lXu2AAAAAElFTkSuQmCC" />';

$_['microsoftpay_image'] = '<img height="16" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAAAnJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOnhtcD0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wLyI+CiAgICAgICAgIDx0aWZmOllSZXNvbHV0aW9uPjcyPC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpDb21wcmVzc2lvbj41PC90aWZmOkNvbXByZXNzaW9uPgogICAgICAgICA8dGlmZjpYUmVzb2x1dGlvbj43MjwvdGlmZjpYUmVzb2x1dGlvbj4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5GbHlpbmcgTWVhdCBBY29ybiA1LjYuNjwveG1wOkNyZWF0b3JUb29sPgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAxOS0wNi0yOFQxNDoyMDozMzwveG1wOk1vZGlmeURhdGU+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgrovpXOAAACYUlEQVRIDe1WS24TQRCt6u7xJLaxHCAgGSEhVmy5A2fIGrEgEqdAYsVHnIEz5AYIJMQRssiCDQrCiYJtPOPpT/HGdryIptsxGyTk3nhmurpev+euV82z94fh94iUYooOYWZb0Z37+eFbYTo6fndefs9US0iiazAhpJUx7stRO8yCUALAixjD096Anr8B2PHw8yw/t2VgVWeJDmZvg6Hd7vRXSdqQRGOFlThLO+1FrkzvjgtPTgcK0exEQYJRmSHvNZMLPgFALFqxA835EAlQ1CGDpACYawyQvO5YEcTK+jnOeJUR/90GAKtlGz1sAdbKtZXo30tkYBIOZQOrSNgKK+crGOJiv0w6eFFsJGkVSKhYGxmddXIUtUuS9ZQrO7lYxBR21OlnVeE5ZcGEMvbWGv30VVFOWas1le+s3rsLEmDx5OGz8Wyoe1narrmGUCxrEieJXWPSvP76Y1IFGCrwEvHWy6CbvXh8m1nCyUsqvwlD2ZUBNi5FkzH86MMJd2+Jt+DTGIWPEoLaaffLn58OHigO8vEe906pIEqUKaAxW5HZy/XZ+MwktcKsrYr+Db3cQXaTLk7Jt9BUYnuq9UC3UDnOqOAs+YDfaLCg1WSI8csIcQQsh4MXB0A2KBLsnCRyx7M3wMbFvBq8bThXFWl4Txy0hui/+PS/AERruFGTDaJx51QwFwq178ZLAS4CT1ydflgM1hDuVIniXFayMnAx1i14EcXN3cOLTOZCuSQUYDHzSr70jgaiwMamXWX229qU1tR332jd4yZa2Ol+L5uTYM4HNBlS1iG5NI8GBLQDIdP6A5Z3/pKtxmspAAAAAElFTkSuQmCC" />';

$_['afterpay_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['alipay_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['bancontact_image'] = '<img height="16" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAKumlDQ1BJQ0MgUHJvZmlsZQAASImVlwdUU9kWhs+9N73QEhCQEnoTpFcpoYcuHWyEJJBQYkwIKqKiIo7giCIighUdEFFwLICMBbFgYVCwYJ8gg4A6DhZsqLwLPMLMe+u9t95e69z7rX332Xufs85Z678AUD6xRaIMWAmATGGWODLAmxGfkMjA9wEIIIAI6IDA5khEzIiIEIDa1Pvv9uEeGo3abcvxXP/+/b+aMpcn4QAARaCczJVwMlE+iQ4ZRyTOAgApRf0GS7NE49yMMl2MNohyxzinTrJsnJMn+f1ETHSkDwAYAgAECpstTgWAQkf9jGxOKpqHYo+ytZArEKLMRdmDw2ejb8pBlGdlZi4e51somyb/JU/q33Imy3Oy2alynlzLhBF8BRJRBnv5/7kd/9syM6RTNYzRQeGLAyPH66F7dj99cbCchclh4VMs4E72NM58aWDMFHMkPolTzGX7BsvnZoSFTHGKwJ8lz5PFip5insQvaorFiyPltVLEPswpZoun60rTY+R+Po8lz5/Dj46b4mxBbNgUS9KjgqdjfOR+sTRS3j9PGOA9XddfvvZMyV/WK2DJ52bxowPla2dP988TMqdzSuLlvXF5vn7TMTHyeFGWt7yWKCNCHs/LCJD7JdlR8rlZ6IGcnhsh38M0dlDEFAMBCAVswMniLcsab95nsWi5WJDKz2Iw0VvFY7CEHKtZDFtrGxcAxu/o5BF4d3/i7kFqhGmf5A4ArujZgITTvoUFALQ4AUD7Y9pnmAsA+QAAZ7s5UnH2pA8z/sACElBE774G0AEGwBRYAlvgCNyAF/ADQSAcRIMEsBBwAB9kAjFYCnLBGlAAisAWsB1UgL3gADgEjoLjoAmcARfAFXAD3AJ3wSMgA/3gJRgGH8AoBEF4iArRIA1IFzKCLCBbyBnygPygECgSSoCSoFRICEmhXGgdVASVQBXQfqgW+hk6DV2ArkFd0AOoFxqC3kJfYASmwHRYGzaGZ8POMBMOhqPhBXAqvATOgfPhzXA5XAUfgRvhC/AN+C4sg1/CIwhAyIgaoodYIs6IDxKOJCIpiBhZhRQiZUgVUo+0IO3IbUSGvEI+Y3AYGoaBscS4YQIxMRgOZglmFWYTpgJzCNOIuYS5jenFDGO+Y6lYLawF1hXLwsZjU7FLsQXYMmw19hT2MvYuth/7AYfDqeFMcE64QFwCLg23ArcJtxvXgGvFdeH6cCN4PF4Db4F3x4fj2fgsfAF+J/4I/jy+G9+P/0QgE3QJtgR/QiJBSFhLKCMcJpwjdBMGCKNEJaIR0ZUYTuQSlxOLiQeJLcSbxH7iKEmZZEJyJ0WT0khrSOWketJl0mPSOzKZrE92Ic8lC8h55HLyMfJVci/5M0WFYk7xocynSCmbKTWUVsoDyjsqlWpM9aImUrOom6m11IvUp9RPCjQFKwWWAldhtUKlQqNCt8JrRaKikSJTcaFijmKZ4gnFm4qvlIhKxko+SmylVUqVSqeVepRGlGnKNsrhypnKm5QPK19THlTBqxir+KlwVfJVDqhcVOmjITQDmg+NQ1tHO0i7TOun4+gmdBY9jV5EP0rvpA+rqqjaq8aqLlOtVD2rKlND1IzVWGoZasVqx9XuqX2ZoT2DOYM3Y+OM+hndMz6qz1T3UuepF6o3qN9V/6LB0PDTSNfYqtGk8UQTo2muOVdzqeYezcuar2bSZ7rN5MwsnHl85kMtWMtcK1JrhdYBrQ6tEW0d7QBtkfZO7Yvar3TUdLx00nRKdc7pDOnSdD10Bbqluud1XzBUGUxGBqOccYkxrKelF6gn1duv16k3qm+iH6O/Vr9B/4kBycDZIMWg1KDNYNhQ1zDUMNewzvChEdHI2YhvtMOo3eijsYlxnPEG4ybjQRN1E5ZJjkmdyWNTqqmn6RLTKtM7ZjgzZ7N0s91mt8xhcwdzvnml+U0L2MLRQmCx26JrFnaWyyzhrKpZPZYUS6ZltmWdZa+VmlWI1VqrJqvXsw1nJ87eOrt99ndrB+sM64PWj2xUbIJs1tq02Ly1Nbfl2Fba3rGj2vnbrbZrtntjb2HPs99jf9+B5hDqsMGhzeGbo5Oj2LHeccjJ0CnJaZdTjzPdOcJ5k/NVF6yLt8tqlzMun10dXbNcj7v+6Wbplu522G1wjskc3pyDc/rc9d3Z7vvdZR4MjySPfR4yTz1PtmeV5zMvAy+uV7XXANOMmcY8wnztbe0t9j7l/dHH1WelT6sv4hvgW+jb6afiF+NX4ffUX98/1b/OfzjAIWBFQGsgNjA4cGtgD0ubxWHVsoaDnIJWBl0KpgRHBVcEPwsxDxGHtITCoUGh20IfhxmFCcOawkE4K3xb+JMIk4glEb/Mxc2NmFs593mkTWRuZHsULWpR1OGoD9He0cXRj2JMY6QxbbGKsfNja2M/xvnGlcTJ4mfHr4y/kaCZIEhoTsQnxiZWJ47M85u3fV7/fIf5BfPvLTBZsGzBtYWaCzMWnl2kuIi96EQSNiku6XDSV3Y4u4o9ksxK3pU8zPHh7OC85HpxS7lDPHdeCW8gxT2lJGUw1T11W+oQ35Nfxn8l8BFUCN6kBabtTfuYHp5ekz6WEZfRkEnITMo8LVQRpgsvLdZZvGxxl8hCVCCSLXFdsn3JsDhYXC2BJAskzVl0VAx1SE2l66W92R7ZldmflsYuPbFMeZlwWcdy8+Ublw/k+Of8tAKzgrOiLVcvd01u70rmyv2roFXJq9pWG6zOX92fF5B3aA1pTfqaX9dary1Z+35d3LqWfO38vPy+9QHr6woUCsQFPRvcNuz9AfOD4IfOjXYbd278XsgtvF5kXVRW9HUTZ9P1H21+LP9xbHPK5s5ix+I9W3BbhFvubfXceqhEuSSnpG9b6LbGUkZpYen77Yu2XyuzL9u7g7RDukNWHlLevNNw55adXyv4FXcrvSsbdmnt2rjr427u7u49Xnvq92rvLdr7ZZ9g3/39Afsbq4yryg7gDmQfeH4w9mD7T84/1VZrVhdVf6sR1sgORR66VOtUW3tY63BxHVwnrRs6Mv/IraO+R5vrLev3N6g1FB0Dx6THXvyc9PO948HH2044n6g/aXRy1ynaqcJGqHF543ATv0nWnNDcdTrodFuLW8upX6x+qTmjd6byrOrZ4nOkc/nnxs7nnB9pFbW+upB6oa9tUduji/EX71yae6nzcvDlq1f8r1xsZ7afv+p+9cw112unrztfb7rheKOxw6Hj1K8Ov57qdOxsvOl0s/mWy62Wrjld57o9uy/c9r195Q7rzo27YXe77sXcu98zv0d2n3t/8EHGgzcPsx+OPsp7jH1c+ETpSdlTradVv5n91iBzlJ3t9e3teBb17FEfp+/l75Lfv/bnP6c+LxvQHagdtB08M+Q/dOvFvBf9L0UvR18V/KH8x67Xpq9P/un1Z8dw/HD/G/Gbsbeb3mm8q3lv/75tJGLk6YfMD6MfCz9pfDr02flz+5e4LwOjS7/iv5Z/M/vW8j34++OxzLExEVvMnpACCDrglBQA3tYAQE1AtQOqiUnzJjX0hEGTun+CwH/iSZ09YY4A1LQCMC61gvMA2DclYdER4QVAtBeA7ezk458mSbGzncxFbkKlSdnY2DtUL+LNAPjWMzY22jQ29q0abfYhAK0fJrX7uOHQP5p65P3rPcU3wzbngX+xfwAt/w+B1H5IEgAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAx1pVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyIKICAgICAgICAgICAgeG1sbnM6ZXhpZj0iaHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iPgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAxOS0wNS0xM1QxMToyNToxOTwveG1wOk1vZGlmeURhdGU+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+Rmx5aW5nIE1lYXQgQWNvcm4gNS42LjY8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHRpZmY6WVJlc29sdXRpb24+MTQ0PC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpDb21wcmVzc2lvbj41PC90aWZmOkNvbXByZXNzaW9uPgogICAgICAgICA8dGlmZjpYUmVzb2x1dGlvbj4xNDQ8L3RpZmY6WFJlc29sdXRpb24+CiAgICAgICAgIDxleGlmOlBpeGVsWERpbWVuc2lvbj44MDwvZXhpZjpQaXhlbFhEaW1lbnNpb24+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj43MDwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgp4mlMGAAADKElEQVRIDe1WTWgTQRR+M7ObX9vEUqQWxSJFqUhLSaH0IkUqKKIV/LmUHgTxVkRFofSs4s2LZ6sUjx68iBe11OIPHhSrheZilbZSsBGaZJP9meeb3azJlpKEkt46ZDfz8+Z73/tm5s0yw7Q1wQWjAg0siOAg2o4kcKbxhmK7NImuxhgiY1LKBpOv0AHJAz0VPY2v8sZDBhF3HAT12KS17RJpmzjdpAsBJUCd+40BE/8x6timBM22HmitCNBRdJw8Zj6CkwOoPPOVdZ8xOiy6DxLdACVOVR146IUV+e02rL0Dx/BgJDKpjmdZMWqp3OCmHNSTPPUYkn3gTq/igJQRYGdx7hasvQW9BfQEo0lIucuGiLZRN3JSYBIEGItY+O1GpxgEHCheJVrIOaeFxfkJzLxX6GjTkI1c1wq/ch1Pv/Y6FIgLQy9bYjgcHz001ybSjspy5TULOOA0oySs+sOFe7jyHPSkQgeQwHVW+Gu1j74env4eBk77yi2kTBFG+tI3Or9I21JdIuoOKJCAgx+r61nDJOqGjHU7U+LnJGoJioMMEThHE8It19+cnk5riYRBClKvJlhm3RoZbJo6mwdzQErBm7tYMqUcuHEoBxQs3Qoz88sX7r+gHJ639fH+dOroMxQhDsTdXUK0WGzXxIdTk5+a4xGr6CgR6DLJZM3ezj13rpyB1ssUUVka14OyoYekF8AWV9dXl/5A8+5LR1bGU7OmEacVUyQVA4hF4MHnY3dftcdjRRKfOklPo2jvbYk/Ghs60Bp3HItYUr/ayhUHTTnwusO6gJCeiMJSruniy/NFm3n2xF+QaBabWRTRmEULSPb0WLaMhrQn1070dLQqDYTuom98ldeA7k/Im9mIObsgaUGB+TuK8CgMeutqqX0+pDB7eHVwqGe/p/BGYL+tHHCX6sDhtpPHu5bXchFd+Ni+Ff0jKek2STWEWEi7Odx7rv8g1b3pFaaBaikXeRQDI3U0CF0JXtWyJJEngyyRrDrDH6Qzo85NrVJHNq0FUX08uHGr225pdMdBTdn4tn7ZETinVF6TxZYNCFxT9wZQkm3w9ztxJ2T6/QMezkRkNy0jKgAAAABJRU5ErkJggg==" />';

$_['eps_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['fpx_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['giropay_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['ideal_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['klarna_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['multibanco_image'] = '<img height="16" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAK12lDQ1BJQ0MgUHJvZmlsZQAASImVlwdUU8kax+fem15oAaQTekc6AaSEHrp0EJWQBBJKjAlBRewsruCKoiKCFV0QUXB1BWQtiAXbomDB/oKIgrourmJD5d3AI+zuO++9875zJvM7X2a+Mpk55x8AqKFskSgXVgEgT5gvjg3xpyenpNLxTwEGKAEY6AFdNkciYsbERADUpua/2vs7AJLPN+3ksf79+/9qalyehAMAlIZyBlfCyUO5Ax0vOCJxPgDIIdRvsihfJOcbKKuL0QJRfirnrEn+KOeMCcZQJtbExwagTAeAQGGzxVkAUGxRP72Ak4XGoch7cBByBUKUi1D24fDZXJRPomybl7dAzkMoW6LrRQBQ0dMBjIw/xcz6S/wMRXw2O0vBk31NGCFQIBHlspf8n0fzvy0vVzqVwxwdFL44NFaeDz2/uzkLwhUszIiKnmIBd7ImOfOloQlTzJEEpE4xlx0YrtibGxUxxZmCYJYiTj4rfop5kqC4KRYviFXkyhQHMKeYLZ7IS0JZJs1JUPj5PJYifiE/PmmKCwSJUVMsyYkLn14ToPCLpbGK+nnCEP/pvMGK3vMkf+pXwFLszefHhyp6Z0/XzxMyp2NKkhW1cXmBQdNrEhTrRfn+ilyi3BjFel5uiMIvKYhT7M1HL+f03hjFGWazw2KmGAhAJGADDl15igDI5y3OlzcSsEC0RCzI4ufTmehr49FZQo69Ld3JwckBAPnbnbwOb+9OvElIkzDtk9wCwBO9J5Bw2jevBIB2dwBov037TNE3Qd4HwKlejlRcMOnDyD+w6K+nDNSBNjAAJsAS2AEn4Aa8gB8IAmEgGsSDFDAPrZUP8oAYLAJFYBUoAWVgI9gKqsFusA8cAIfBUdAKToKz4CK4Cm6A2+ABkIFB8BKMgPdgDIIgPESFaJA2ZAiZQTaQE8SAfKAgKAKKhVKgdCgLEkJSqAhaA5VBFVA1tBdqgH6CTkBnoctQD3QP6oeGoT+gzzACU2B1WB82h2fCDJgJh8Px8Fw4C14IF8LF8Aa4Cq6FD8Et8Fn4KnwblsEv4VEEIGREEzFC7BAGEoBEI6lIJiJGliOlSCVSizQh7UgXchORIa+QTxgchoahY+wwXphQTAKGg1mIWY5Zj6nGHMC0YM5jbmL6MSOYb1gqVg9rg/XEsrDJ2CzsImwJthJbhz2OvYC9jR3EvsfhcJo4C5w7LhSXgsvGLcWtx+3ENeM6cD24AdwoHo/XxtvgvfHReDY+H1+C344/hD+D78UP4j8SyARDghMhmJBKEBJWEyoJBwmnCb2E54QxogrRjOhJjCZyiUuI5cT9xHbideIgcYykSrIgeZPiSdmkVaQqUhPpAukh6S2ZTDYme5BnkwXkleQq8hHyJXI/+RNFjWJNCaCkUaSUDZR6SgflHuUtlUo1p/pRU6n51A3UBuo56mPqRyWakr0SS4mrtEKpRqlFqVfptTJR2UyZqTxPuVC5UvmY8nXlVypEFXOVABW2ynKVGpUTKn0qo6o0VUfVaNU81fWqB1Uvqw6p4dXM1YLUuGrFavvUzqkN0BCaCS2AxqGtoe2nXaANquPULdRZ6tnqZeqH1bvVRzTUNFw0EjUWa9RonNKQaSKa5poszVzNcs2jmnc0P8/Qn8GcwZuxbkbTjN4ZH7R0tfy0eFqlWs1at7U+a9O1g7RztDdpt2o/0sHoWOvM1lmks0vngs4rXXVdL12ObqnuUd37erCetV6s3lK9fXrX9Eb1DfRD9EX62/XP6b8y0DTwM8g22GJw2mDYkGboYygw3GJ4xvAFXYPOpOfSq+jn6SNGekahRlKjvUbdRmPGFsYJxquNm40fmZBMGCaZJltMOk1GTA1NI02LTBtN75sRzRhmfLNtZl1mH8wtzJPM15q3mg9ZaFmwLAotGi0eWlItfS0XWtZa3rLCWTGscqx2Wt2whq1drfnWNdbXbWAbNxuBzU6bHlusrYet0LbWts+OYse0K7BrtOu317SPsF9t32r/eqbpzNSZm2Z2zfzm4OqQ67Df4YGjmmOY42rHdsc/nKydOE41Trecqc7Bziuc25zfuNi48Fx2udx1pblGuq517XT96ubuJnZrcht2N3VPd9/h3sdQZ8Qw1jMueWA9/D1WeJz0+OTp5pnvedTzdy87rxyvg15Dsyxm8WbtnzXgbezN9t7rLfOh+6T77PGR+Rr5sn1rfZ/4mfhx/er8njOtmNnMQ8zX/g7+Yv/j/h8CPAOWBXQEIoEhgaWB3UFqQQlB1UGPg42Ds4Ibg0dCXEOWhnSEYkPDQzeF9rH0WRxWA2skzD1sWdj5cEp4XHh1+JMI6whxRHskHBkWuTnyYZRZlDCqNRpEs6I3Rz+KsYhZGPPLbNzsmNk1s5/FOsYWxXbF0eLmxx2Mex/vH18e/yDBMkGa0JmonJiW2JD4ISkwqSJJljwzeVny1RSdFEFKWyo+NTG1LnV0TtCcrXMG01zTStLuzLWYu3ju5Xk683LnnZqvPJ89/1g6Nj0p/WD6F3Y0u5Y9msHK2JExwgngbOO85Ppxt3CHed68Ct7zTO/MisyhLO+szVnDfF9+Jf+VIEBQLXiTHZq9O/tDTnROfc54blJucx4hLz3vhFBNmCM8v8BgweIFPSIbUYlIttBz4daFI+JwcZ0EksyVtOWroyLpmtRS+p20v8CnoKbg46LERccWqy4WLr62xHrJuiXPC4MLf1yKWcpZ2llkVLSqqH8Zc9ne5dDyjOWdK0xWFK8YXBmy8sAq0qqcVb+udlhdsfrdmqQ17cX6xSuLB74L+a6xRKlEXNK31mvt7u8x3wu+717nvG77um+l3NIrZQ5llWVf1nPWX/nB8YeqH8Y3ZG7oLncr37URt1G48c4m300HKlQrCisGNkdubtlC31K65d3W+VsvV7pU7t5G2ibdJquKqGrbbrp94/Yv1fzq2zX+Nc079Has2/FhJ3dn7y6/XU279XeX7f68R7Dn7t6QvS215rWV+3D7CvY925+4v+tHxo8NdTp1ZXVf64X1sgOxB843uDc0HNQ7WN4IN0obhw+lHbpxOPBwW5Nd095mzeayI+CI9MiLn9J/unM0/GjnMcaxpp/Nft5xnHa8tAVqWdIy0spvlbWltPWcCDvR2e7VfvwX+1/qTxqdrDmlcar8NOl08enxM4VnRjtEHa/OZp0d6Jzf+eBc8rlb52ef774QfuHSxeCL57qYXWcueV86ednz8okrjCutV92utlxzvXb8V9dfj3e7dbdcd7/edsPjRnvPrJ7Tvb69Z28G3rx4i3Xr6u2o2z13Eu7c7Uvrk93l3h26l3vvzf2C+2MPVj7EPix9pPKo8rHe49p/WP2jWeYmO9Uf2H/tSdyTBwOcgZdPJU+/DBY/oz6rfG74vGHIaejkcPDwjRdzXgy+FL0ce1Xym+pvO15bvv75d7/fr40kjwy+Eb8Z/2P9W+239e9c3nWOxow+fp/3fuxD6Uftjwc+MT51fU76/Hxs0Rf8l6qvVl/bv4V/ezieNz4uYovZE1IAQQecmQnAH/WoNk5BtQOqy0lzJrX1hEGT/wcmCPwnntTfE+YGQH0HAHLZFb4SgD1TchYdMX4AxPsB2NlZMf5lkkxnp8lY5FZUmlSOj79FtSPeCoCvfePjY63j41/r0GLvA9DxflLTyw2Havkm5N3rXeXXozasBH+zSb3/px7/PgN5BS7g7/M/AX6mGSgMaqjZAAAAzmVYSWZNTQAqAAAACAAGARoABQAAAAEAAABWARsABQAAAAEAAABeASgAAwAAAAEAAgAAATEAAgAAABgAAABmATIAAgAAABQAAAB+h2kABAAAAAEAAACSAAAAAAAAAJAAAAABAAAAkAAAAAFGbHlpbmcgTWVhdCBBY29ybiA2LjUuMwAyMDIwOjA1OjE0IDE0OjM2OjUwAAADkoYABwAAABIAAAC8oAIABAAAAAEAAAAgoAMABAAAAAEAAAAgAAAAAEFTQ0lJAAAAU2NyZWVuc2hvdMWAYEgAAAAJcEhZcwAAFiUAABYlAUlSJPAAAAOMaVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA1LjQuMCI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOnRpZmY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vdGlmZi8xLjAvIgogICAgICAgICAgICB4bWxuczpleGlmPSJodHRwOi8vbnMuYWRvYmUuY29tL2V4aWYvMS4wLyIKICAgICAgICAgICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIj4KICAgICAgICAgPHRpZmY6UmVzb2x1dGlvblVuaXQ+MjwvdGlmZjpSZXNvbHV0aW9uVW5pdD4KICAgICAgICAgPHRpZmY6WFJlc29sdXRpb24+MTQ0PC90aWZmOlhSZXNvbHV0aW9uPgogICAgICAgICA8dGlmZjpZUmVzb2x1dGlvbj4xNDQ8L3RpZmY6WVJlc29sdXRpb24+CiAgICAgICAgIDx0aWZmOkNvbXByZXNzaW9uPjU8L3RpZmY6Q29tcHJlc3Npb24+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj42ODwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgICAgIDxleGlmOlVzZXJDb21tZW50PlNjcmVlbnNob3Q8L2V4aWY6VXNlckNvbW1lbnQ+CiAgICAgICAgIDxleGlmOlBpeGVsWERpbWVuc2lvbj42ODwvZXhpZjpQaXhlbFhEaW1lbnNpb24+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+Rmx5aW5nIE1lYXQgQWNvcm4gNi41LjM8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgICAgPHhtcDpNb2RpZnlEYXRlPjIwMjAtMDUtMTRUMTQ6MzY6NTA8L3htcDpNb2RpZnlEYXRlPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4K4tPUcAAABq9JREFUWAm9V2lsVFUU/t6bN2s7LXRvRZGEYqW2IbKYuAJSBUSLZTHqL36gJiZGjUZMMEpC4hJ/GBOJMZq4a+JSEQqCxq1VUVCrJUKppVJxarELpdOZaectfufOtGUW1BrxJm/ezH3nnvOd73z3vDvavHmXVNqG/hgcrQJAnJfG62wOh87d0JyQbtqbDAnu0t0Ntm2dzaAZvnXdgGXEYUjmEtxxbJvJZ8k+y1SGu7+akITTh4qmS2yDj4R2DhU8NZpMWSYcENuUK+PQowvQeTnpICbCxAXAxC+BkRiccsgKg7tySqG5PJyeCggJqMGOR2BHB6Dp7mR+SfeTN00AZA7HhmZ44a9sgLu4OpEFeciKNXN1csaBY44h3tuKWOeHKqFs6/XM9RoZs2AUzIZ31hIGp0zMUcWGY43x/ndXnDaJS/cG4Zu9HHqgCI5tZk3gDAwwW92jqIu0vYax0AH+zFXAMgFnmdGoL9Lvn70SOfNvg8tfAGv4tyyG4C7IGCIeamDsJOK/tgCxfujePMUEuSGVUk4tYcO1JJrZOdSaDp3zqlACgOJzwt308TmscA8VkYVsrs8CgLOkfaS3A+Hen6k9Cx6vj31DRJgIblGco6Oj8gMetxuGYSA8HMbY2JiyGf/Qhg4icKILHg9FKLtBwRt/mrhnBWBZNqoumIMVy5fhx7af8NnnLYylq6xN06RDD25a16Du773fhIGBQSxaNB8V5eVkgwImMJtbz6LtocPt+PV4SIFwMrZjFgZksckMH35oE+bV1sCmw/o1N6PzaBd8Xi8EgATf/OD9KoXcnBxsfmQrNt1/D2qq55KFOFwsh8slGQOhUA9uv/NuHO36BW6ylQ4iozASMJibi/POnaEc6LqOG1dfr4CYloVcPmvg7/GxcMHFMOMmK2Wj5/deXLa4DtfVr8PiuuuwZevjqKgox/q1N8Li2mwjBYBkL4ZlpSXw+/wYPHkSQ0OncMOqFchhppL9nMrZqJ57IXp6fle2ecEg6bYTGZNiobvrl2Nob+9A0+49OP5bCBdWzckWW82lAaDmhAE69ft9aPniK+z96GMUFRZi6ZIr0d8/gLUN9Wrh243bVaCCgukoLOQ2I3BJYFpeHhYumI+6uqW4Y+MGzDinAs30I8+yjTQRSv0tlJYWK9s/+vrxyafNWLdmNZZfswzNLV/i6qVXoY/zje/txLV1y+Dz+ZAf5DalwiPRKGpqqrHt6SdhsN4Bv1/5af3hYAKgslJTEx8pACZKUFKiDEbCI/hy39fo6+/H3KoL8MB99yCfGb6/czcOfPc9BSVs5RJwCUYpvmKK9Nixbjzz7POKSQG3nuCfeHQLNmy8Uz1LF2JKCSSqiKmQlMsYOnUKkUgE7zbuQHl5GVbXr1Lzjdt3KKEeZ71l5OfnKX24ud9FiC+98jpefvVNPPX0Ntx17wMomD4d9atWYoS+RNSnj5RfwoAIraKiTNmIMx+b0I6m3YjFYuq12fpjG1p/aIPX50XviT+UXVFRIeJsQpZpKUFKn/B6PRBAM887V20/pZEsL96UEowjKy4qUl/7+vqUI1HyV1/vx5KrrsDOpg9UxzNcBrq7u5VdSXExRaajrKwUu7a/xTVeadBk0+GOqVLilR0RCPhVacbjyD0FgHQxqduRjk64DBc6O9l8+DsWG8VzL7yIELde0649StEGnx9qP6IaTO+JE9j3zTfIywsqpsReuq40ow/2fsSSvKHsFLC0bqjVzr+0mdRfzg6l3kI2u2CA9HoZeGBwSDmR0kgJhsNhFBYUqDqKuVxS//DwCOImz3cG85G3EYcwIPUeGYnI0URta84kHvIxfWpc35LCABs5M/fALKxFdPAYHfKNBrkc+AM5yOV2E41IYNLAABqb1TBB6tx2nuT8eAx5H4ANLABj2kw47iDGer5NnK5kfXJMAlDv8CiMkkoEa29F9HAjIu071cmIniGNNL2ZihuXrGOt5XtGrxFRx6PwX3QL9GAFzP4j6pxAFMnwaRpQIuVpyDZjMIovgp9eNTkRTZhP7Yv0PmHLNW1WMnBmN5xkgPRrLr7tBo8SaQfcZfO48PxkWpkL/xkUxYvaIbHQfh5QB6G5A0Q1ecCdBKA8MhAZiB56Rx3DGF1y+GexzmTFMjgsgznYmSxn4mAzbp4GQDh3wY4NwYp8N27zH9x5hHPxVHSGRpSZopx+eCz/b0aSxdOUf5pfRxgQaBxicVqtsy9ImE7pMzO/ZCwJ5jbUv1QqnU1woktMyf+/Mmbj5iHVsuMhQ/4iy7/U//vvuQSX2H8COpPssRtqK/0AAAAASUVORK5CYII=" />';

$_['p24_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['secure_remote_commerce_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['sepa_image'] = '<img height="16" src="data:image/png;base64,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" />';

$_['sofort_image'] = '<img height="16" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAK1mlDQ1BJQ0MgUHJvZmlsZQAASImVlwdUU8kax+fem15oAQSkhN6RTgApoYcuHUQlJIGEEmNCUBE7iyu4oqiIYEUXRBRcXQFZC2LBtihYsG8QUVDXxYINlb2BR9jdd957533nTOZ3vsx8ZTJzzj8AUEPYIlEOrAJArjBPHBPsR09KTqHjnwAKUAEwOrBsjkTEjI4OB6hNzn+397cBJJ9v2Mpj/fv3/9XUuDwJBwAoFeV0roSTi3I7Op5zROI8AJCDqN94YZ5IztdRVhejBaL8RM6ZE/xRzunjjKGMr4mL8UeZDgCBwmaLMwGg2KB+ej4nE41DkfdgL+QKhCgXouzN4bO5KJ9A2SY3d76cB1G2QNeLAKCipwMY6X+Jmfm3+OmK+Gx2poIn+ho3QoBAIsphL/4/j+Z/W26OdDKHGToofHFIjDwfen53sueHKViYHhk1yQLuRE1y5ktD4ieZI/FPmWQuOyBMsTcnMnySMwRBLEWcPFbcJPMkgbGTLJ4fo8iVIfZnTjJbPJ6XhLJMmh2v8PN5LEX8An5c4iTnCxIiJ1mSHRs2tcZf4RdLYxT184TBflN5gxS950r+0q+Apdibx48LUfTOnqqfJ2ROxZQkKWrj8gICp9bEK9aL8vwUuUQ50Yr1vJxghV+SH6vYm4dezqm90YozzGKHRk8yEIAIwAYcuvIkAZDHW5Qnb8R/vmixWJDJz6Mz0dfGo7OEHDsbuqO9oz0A8rc7cR3e3hl/k5AmYconuQmAB3pPIOGUb24xAG1uANB+n/KZoG+CvBeAkz0cqTh/woeRf2DRX08ZqANtoA+MgQWwBY7AFXgCXxAIQkEUiAPJYC5aKx/kAjFYCArBSlAMSsEGsAVUgV1gL9gPDoEjoAWcAGfABXAFXAe3wH0gAwPgBRgG78EoBEF4iArRIG3IADKFrCFHiAF5Q4FQOBQDJUNpUCYkhKRQIbQaKoXKoSpoD1QP/QQdh85Al6Bu6C7UBw1Bb6DPMAJTYHVYDzaDZ8AMmAmHwXHwHDgTXgAXwEXwergSroEPws3wGfgKfAuWwS/gEQQgZEQTMURsEQbij0QhKUgGIkaWISVIBVKDNCJtSCdyA5EhL5FPGByGhqFjbDGemBBMPIaDWYBZhlmHqcLsxzRjzmFuYPoww5hvWCpWF2uN9cCysEnYTOxCbDG2AluLPYY9j72FHcC+x+FwmjhznBsuBJeMy8Itwa3D7cA14dpx3bh+3Agej9fGW+O98FF4Nj4PX4zfhj+IP43vwQ/gPxLIBAOCIyGIkEIQElYRKggHCKcIPYRnhFGiCtGU6EGMInKJi4llxH3ENuI14gBxlKRKMid5keJIWaSVpEpSI+k86QHpLZlMNiK7k2eRBeQV5EryYfJFch/5E0WNYkXxp6RSpJT1lDpKO+Uu5S2VSjWj+lJTqHnU9dR66lnqI+pHJZqSnRJLiau0XKlaqVmpR+mVMlHZVJmpPFe5QLlC+ajyNeWXKkQVMxV/FbbKMpVqleMqvSojqjRVB9Uo1VzVdaoHVC+pDqrh1czUAtW4akVqe9XOqvXTEJoxzZ/Goa2m7aOdpw2o49TN1VnqWeql6ofUu9SHNdQ0nDUSNBZpVGuc1JBpIppmmizNHM0yzSOatzU/T9ObxpzGm7Z2WuO0nmkftKZr+WrxtEq0mrRuaX3WpmsHamdrb9Ru0X6og9Gx0pmls1Bnp855nZfT1ad7TudML5l+ZPo9XVjXSjdGd4nuXt2ruiN6+nrBeiK9bXpn9V7qa+r76mfpb9Y/pT9kQDPwNhAYbDY4bfCcrkFn0nPolfRz9GFDXcMQQ6nhHsMuw1Ejc6N4o1VGTUYPjUnGDOMM483GHcbDJgYmESaFJg0m90yJpgxTvulW007TD2bmZolma8xazAbNtcxZ5gXmDeYPLKgWPhYLLGosblriLBmW2ZY7LK9bwVYuVnyraqtr1rC1q7XAeod1tw3Wxt1GaFNj02tLsWXa5ts22PbZadqF262ya7F7NcNkRsqMjTM6Z3yzd7HPsd9nf99BzSHUYZVDm8MbRytHjmO1400nqlOQ03KnVqfXztbOPOedzndcaC4RLmtcOly+urq5il0bXYfcTNzS3La79TLUGdGMdYyL7lh3P/fl7ifcP3m4euR5HPH4w9PWM9vzgOfgTPOZvJn7ZvZ7GXmxvfZ4ybzp3mneu71lPoY+bJ8an8e+xr5c31rfZ0xLZhbzIPOVn72f2O+Y3wd/D/+l/u0BSEBwQElAV6BaYHxgVeCjIKOgzKCGoOFgl+Alwe0h2JCwkI0hvSw9FodVzxoOdQtdGnoujBIWG1YV9jjcKlwc3hYBR4RGbIp4EGkaKYxsiQJRrKhNUQ+jzaMXRP8yCzcrelb1rKcxDjGFMZ2xtNh5sQdi38f5xZXF3Y+3iJfGdyQoJ6Qm1Cd8SAxILE+UJc1IWpp0JVknWZDcmoJPSUipTRmZHTh7y+yBVJfU4tTbc8znLJpzaa7O3Jy5J+cpz2PPO5qGTUtMO5D2hR3FrmGPpLPSt6cPc/w5WzkvuL7czdwhnhevnPcswyujPGMw0ytzU+YQ34dfwX8p8BdUCV5nhWTtyvqQHZVdlz2Wk5jTlEvITcs9LlQTZgvPzdefv2h+t8haVCySLfBYsGXBsDhMXCuBJHMkrXnqqEi6KrWQfifty/fOr87/uDBh4dFFqouEi64utlq8dvGzgqCCH5dglnCWdBQaFq4s7FvKXLpnGbQsfVnHcuPlRcsHVgSv2L+StDJ75a+r7FeVr3q3OnF1W5Fe0Yqi/u+Cv2soVioWF/eu8Vyz63vM94Lvu9Y6rd229lsJt+RyqX1pRemXdZx1l39w+KHyh7H1Geu7ylzLdm7AbRBuuL3RZ+P+ctXygvL+TRGbmjfTN5dsfrdl3pZLFc4Vu7aStkq3yirDK1u3mWzbsO1LFb/qVrVfddN23e1rt3/Ywd3Rs9N3Z+MuvV2luz7vFuy+syd4T3ONWU3FXtze/L1P9yXs6/yR8WN9rU5tae3XOmGdbH/M/nP1bvX1B3QPlDXADdKGoYOpB68fCjjU2mjbuKdJs6n0MDgsPfz8p7Sfbh8JO9JxlHG08WfTn7cfox0raYaaFzcPt/BbZK3Jrd3HQ493tHm2HfvF7pe6E4Ynqk9qnCw7RTpVdGrsdMHpkXZR+8szmWf6O+Z13D+bdPbmuVnnus6Hnb94IejC2U5m5+mLXhdPXPK4dPwy43LLFdcrzVddrh771eXXY12uXc3X3K61Xne/3tY9s/tUj0/PmRsBNy7cZN28civyVvft+Nt3elN7ZXe4dwbv5tx9fS//3uj9FQ+wD0oeqjyseKT7qOY3y9+aZK6yk30BfVcfxz6+38/pf/FE8uTLQNFT6tOKZwbP6gcdB08MBQ1dfz77+cAL0YvRl8W/q/6+/ZXFq5//8P3j6nDS8MBr8euxN+vear+te+f8rmMkeuTR+9z3ox9KPmp/3P+J8anzc+LnZ6MLv+C/VH61/Nr2Lezbg7HcsTERW8welwIIOuCMDADe1KHaOBnVDqguJ82e0NbjBk38Hxgn8J94Qn+PmysAde0AyGVX2AoAdk/KWXRE+wIQ5wtgJyfF+JdJMpwcJ2KRW1BpUjE29hbVjnhLAL72jo2NtoyNfa1Fi70HQPv7CU0vNxyq5RuRd692ll2LXL8C/MMm9P5fevznDOQVOIN/zn8CQ1MZEAwcomUAAADOZVhJZk1NACoAAAAIAAYBGgAFAAAAAQAAAFYBGwAFAAAAAQAAAF4BKAADAAAAAQACAAABMQACAAAAGAAAAGYBMgACAAAAFAAAAH6HaQAEAAAAAQAAAJIAAAAAAAAAkAAAAAEAAACQAAAAAUZseWluZyBNZWF0IEFjb3JuIDYuNi4zADIwMjA6MTI6MjIgMTE6Mjk6NDcAAAOShgAHAAAAEgAAALygAgAEAAAAAQAAACCgAwAEAAAAAQAAACAAAAAAQVNDSUkAAABTY3JlZW5zaG90+Y1y9AAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAA4xpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIgogICAgICAgICAgICB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iPgogICAgICAgICA8dGlmZjpSZXNvbHV0aW9uVW5pdD4yPC90aWZmOlJlc29sdXRpb25Vbml0PgogICAgICAgICA8dGlmZjpYUmVzb2x1dGlvbj4xNDQ8L3RpZmY6WFJlc29sdXRpb24+CiAgICAgICAgIDx0aWZmOllSZXNvbHV0aW9uPjE0NDwvdGlmZjpZUmVzb2x1dGlvbj4KICAgICAgICAgPHRpZmY6Q29tcHJlc3Npb24+NTwvdGlmZjpDb21wcmVzc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjY0PC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6VXNlckNvbW1lbnQ+U2NyZWVuc2hvdDwvZXhpZjpVc2VyQ29tbWVudD4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjYwPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPHhtcDpDcmVhdG9yVG9vbD5GbHlpbmcgTWVhdCBBY29ybiA2LjYuMzwveG1wOkNyZWF0b3JUb29sPgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAyMC0xMi0yMlQxMToyOTo0NzwveG1wOk1vZGlmeURhdGU+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgpmd2aFAAADvUlEQVRIDbVW2WoUQRStqt7GjIaoWUxigtFgMIgPUSNuqHFBEfFB9Nlv8Uf8At8MEXxwgSRMEJEoUVwgYMRIJJroONNbledWp2d6ptsehVgPM1W3bp1z627VXCkVlBb8uQX1/SfbvME7tlrjo+axUe5Pz7uTs9yxGOebh88YDK96zvXTwn/2htCF2Ex0YAnBCzYcI9RamWxXapMJAMg53G5m4CZdlebN303BZRHIBGo6MPm7rQk447bNIjMVU77PEnR03LF4xIrdIGBJvhQ6BIkbADSQvL3o3DjD2gqk/Kvq3nui1svMFEQDtwrhXD3BeztZGGLp3Z8JF5cpR/4cwgQBzIaeIUTPDlawiaDqYakPg1xfhDMxuIu3t9EuBnYhjzcjWdNvMjsjVaX8IFKiCSVDfATTtgIvOpG9VJjlKkd+N/kwVo/+kwTxTi2wtQkwBEc8jJFBZhgxwQ/57QczN5bx4eb/LIJmHazhPcZN0zywhza1yeGnFVWutKzQvyAAnBCq4pqHR8RQL5kP14cyfLfE7bzwkik4Gv3l/RqELvo6rXNjpKYTJny/JBeXW/oH6q0IUO6/XNHd4dya4Fu3UNYjqlL5T18QUz1If7QwmaYpJeRPKI29vc6t82i/Gp1Synv8PFxa4ZYZ3SZ1rEGQSxCEvGc72R5h6XwNXrwLZl7xqAIaoLIXuS5CbFfX5duPdDR2iFz8jJDoZM1GbJLmE3Dm+t6DEnULcr3EYeviuNHXyTy/IQAIBu4kajVZZ8klgNW2Jb9+9yZn6YTm4MWCdflY3EJiIM/Hu6LK1XRUcglQX1LiYQoWFv3plxoMEmXs66eUrV0CiXBwyLl9xb50lJqYzuOYuWWaQhHZaJv+o+fwvnYC1bF16hC1jSBAvzL2Dzg3J1Dk1tkx+8IRSrbEyLpBzYSNic59z3enSnjHyVFBiABYV47zbUUESQzvptfR9QFrjA41xKax0KjhYJuSUg+aIHoQKol3Rn5a8aZ0MNDgcHJnu33tJC6nVtewpFcBiqvrTS5K1oGuzFDKL6u1BweFtmGRVIAI5z/4/V3m8AC9ZeDo6jBG9wSl16J7uzHUp35WvIdzkCdfCF6+c5dEtYEn08I3kl5nPplkbBxJqME5FVeFoSi2Kc9jfkgNKjGSN4hBXa+ukNVtVNWtK8CBAl61SAhlC89DfROzFAFkyXpp1N44mlZAOkAI5ZR+FkFKqcEkLDIVMoVkLdok+LNc0Yz7T2tKPwVwgW9gym7dZ/4JoYWylIAFOP/fn++/AY6km5Zz1lQCAAAAAElFTkSuQmCC" />';

$_['wechat_image'] = '<img height="16" src="data:image/png;base64,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" />';

?>