<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Use App\Mail\ContactMail;
Use Illuminate\Http\Request;
Use Illuminate\Support\Facades\Mail;

if (in_array(request()->segment(1),['en','bg','ru'])) {
    App::setLocale(request()->segment(1));
    config(['app.locale_prefix' => request()->segment(1)]);
}

Route::group(['prefix' => Config::get('app.locale_prefix')], function () {

    Route::get('/', ['uses' => 'HomeController@getHome', 'as' => 'get-home-page']);

    Route::get('about', ['uses' => 'HomeController@getAbout', 'as' => 'get-about-page']);

    Route::get('faq', ['uses' => 'HomeController@getFAQ', 'as' => 'get-faq-page']);

    Route::get('products', ['uses' => 'HomeController@getProducts', 'as' => 'get-products-page']);

    Route::get('smart-home', ['uses' => 'HomeController@getSmartHome', 'as' => 'get-smart-home-page']);

    Route::get('hvac', ['uses' => 'HomeController@getHVAC', 'as' => 'get-hvac-page']);

    Route::get('white-label-options', ['uses' => 'HomeController@getWhiteLabelPage', 'as' => 'get-white-label-page']);

    Route::get('access-control', ['uses' => 'HomeController@getAccessControl', 'as' => 'get-access-control-page']);

    Route::get('accelerate-your-business', ['uses' => 'HomeController@getAccelerateYourBusiness', 'as' => 'get-accelerate-your-business-page']);

    Route::get('bboil', ['uses' => 'HomeController@getBboilPage', 'as' => 'get-bboil-page']);

    Route::get('bgate', ['uses' => 'HomeController@getBgatePage', 'as' => 'get-bgate-page']);

    Route::get('bboil-rf', ['uses' => 'HomeController@getBboilRfPage', 'as' => 'get-bboil-rf-page']);

    Route::get('bsafe-f', ['uses' => 'HomeController@getBSafeFPage', 'as' => 'get-bsafe-f-page']);

    Route::get('bsafe-w', ['uses' => 'HomeController@getBSafeWPage', 'as' => 'get-bsafe-w-page']);

    Route::get('bsafe-a', ['uses' => 'HomeController@getBSafeAPage', 'as' => 'get-bsafe-a-page']);

    Route::get('ps-plug', ['uses' => 'HomeController@getPSPlugPage', 'as' => 'get-ps-plug-page']);

    Route::get('set-cookie-agreement', ['uses' => 'HomeController@setCookieAgreement', 'as' => 'set-cookie-agreement']);

    Route::get('privacy-policy', ['uses' => 'HomeController@getCookieInfo', 'as' => 'get-cookie-info']);

    Route::post('sendTicket', ['uses' => 'HomeController@sendTicket']);

    Route::post('sendRequest', ['uses' => 'HomeController@sendRequest']);

    Route::post('sendMessage', ['uses' => 'HomeController@sendMessage']);

    // Route::post('sendMessage', function(Request $request) {
    //     Mail::send(new ContactMail($request));
    //     return redirect('/');
    // });
});
