@extends('layouts.master')

@section('title', Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')

    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a class="scroll-footer cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a class="scroll-footer cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.contacts') !!}</a>
                <a href="{{route('getNews')}}" class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.news') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="product-wrapper">
            <div class="product-list">
                <a class="active" data-target="bboil-rf">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px"
                         height="28px" viewBox="0 0 32 28" version="1.1">
                        <defs>
                            <polygon id="path-1"
                                     points="0 4.50476071 0 9 8.99048214 9 8.99048214 0.00952142857 0 0.00952142857"/>
                        </defs>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g id="index" transform="translate(-266.000000, -116.000000)">
                                <g id="products-2" transform="translate(-1.000000, 27.000000)">
                                    <g id="BBOIL-RF" transform="translate(259.000000, 88.000000)">
                                        <g id="icon" transform="translate(9.000000, 1.000000)">
                                            <g id="t-copy">
                                                <path d="M30.5,4.57806404 L24.5000665,0.599917044 L18.5,4.57806721 L18.5,14.5 L30.5,14.5 L30.5,4.57806404 Z"
                                                      id="Fill-9" stroke="#E2948E"/>
                                                <path d="M25.5,11.5 L27.5,11.5 L27.5,9.5 L25.5,9.5 L25.5,11.5 Z"
                                                      id="Fill-13" stroke="#E2948E"/>
                                                <path d="M25.5,7.5 L27.5,7.5 L27.5,5.5 L25.5,5.5 L25.5,7.5 Z"
                                                      id="Fill-13-Copy" stroke="#E2948E"/>
                                                <path d="M21.5,7.5 L23.5,7.5 L23.5,5.5 L21.5,5.5 L21.5,7.5 Z"
                                                      id="Fill-13-Copy-2" stroke="#E2948E"/>
                                                <path d="M21.5,11.5 L23.5,11.5 L23.5,9.5 L21.5,9.5 L21.5,11.5 Z"
                                                      id="Fill-13-Copy-3" stroke="#E2948E"/>
                                                <g id="tt" transform="translate(0.000000, 1.000000)" stroke="#E2948E"
                                                   stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M4.48803191,22.5 C6.96579953,22.5 8.97606383,20.484375 8.97606383,18 C8.97606383,16.6875 8.41505984,15.46875 7.48005319,14.625 L7.48005319,3 C7.48005319,1.359375 6.12429355,0 4.48803191,0 C2.85177028,0 1.49601064,1.359375 1.49601064,3 L1.49601064,14.625 C0.561003989,15.46875 0,16.6875 0,18 C0,20.484375 2.0102643,22.5 4.48803191,22.5 Z"
                                                          id="Stroke-1"/>
                                                    <path d="M4.48803191,16.5 C5.3295379,16.5 5.98404255,17.15625 5.98404255,18 C5.98404255,18.84375 5.3295379,19.5 4.48803191,19.5 C3.64652593,19.5 2.99202128,18.84375 2.99202128,18 C2.99202128,17.15625 3.64652593,16.5 4.48803191,16.5 Z"
                                                          id="Stroke-3" stroke-width="2"/>
                                                </g>
                                                <path d="M4.42819149,17.5159574 L4.42819149,9.64095745" id="Stroke-6"
                                                      stroke="#E2948E" stroke-width="2" stroke-linecap="round"
                                                      stroke-linejoin="round"/>
                                                <path d="M4.5,25.5 L4.5,27.5" id="Line-5" stroke="#E2948E"
                                                      stroke-linecap="square"/>
                                                <path d="M4.5,27.5 L24.5,27.5" id="Line-6" stroke="#E2948E"
                                                      stroke-linecap="square"/>
                                                <g id="wave"
                                                   transform="translate(24.500000, 20.500000) rotate(-45.000000) translate(-24.500000, -20.500000) translate(20.000000, 16.000000)">
                                                    <path d="M0,3.51428214 C3.07733929,3.51428214 5.48571429,5.92281786 5.48571429,8.99999643"
                                                          id="Stroke-1" stroke="#E2948E"/>
                                                    <g id="Group-5">
                                                        <mask id="mask-2" fill="white">
                                                            <use xlink:href="#path-1"/>
                                                        </mask>
                                                        <g id="Clip-4"/>
                                                        <path d="M0,0.00952142857 C4.98726786,0.00952142857 8.99048214,4.01287857 8.99048214,9.00000357"
                                                              id="Stroke-3" stroke="#E2948E" mask="url(#mask-2)"/>
                                                    </g>
                                                    <path d="M1.98094821,7.93333214 C1.98094821,8.43827857 1.57160893,8.84761786 1.0666625,8.84761786 C0.561716071,8.84761786 0.152376786,8.43827857 0.152376786,7.93333214 C0.152376786,7.42838571 0.561716071,7.01904643 1.0666625,7.01904643 C1.57160893,7.01904643 1.98094821,7.42838571 1.98094821,7.93333214 Z"
                                                          id="Stroke-6" stroke="#E2948E"/>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>
                    BBoil RF
                </a>
                <a data-target="bboil">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px"
                         height="28px" viewBox="0 0 32 28" version="1.1">
                        <defs/>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g id="index" transform="translate(-396.000000, -116.000000)" stroke="#D8D8D8">
                                <g id="products-2" transform="translate(258.000000, 115.000000)">
                                    <g id="BBOIL" transform="translate(139.000000, 0.000000)">
                                        <g id="icon" transform="translate(0.000000, 1.000000)">
                                            <g id="t">
                                                <path d="M30.5,4.57806404 L24.5000665,0.599917044 L18.5,4.57806721 L18.5,14.5 L30.5,14.5 L30.5,4.57806404 Z"
                                                      id="Fill-9"/>
                                                <path d="M25.5,11.5 L27.5,11.5 L27.5,9.5 L25.5,9.5 L25.5,11.5 Z"
                                                      id="Fill-13"/>
                                                <path d="M25.5,7.5 L27.5,7.5 L27.5,5.5 L25.5,5.5 L25.5,7.5 Z"
                                                      id="Fill-13-Copy"/>
                                                <path d="M21.5,7.5 L23.5,7.5 L23.5,5.5 L21.5,5.5 L21.5,7.5 Z"
                                                      id="Fill-13-Copy-2"/>
                                                <path d="M21.5,11.5 L23.5,11.5 L23.5,9.5 L21.5,9.5 L21.5,11.5 Z"
                                                      id="Fill-13-Copy-3"/>
                                                <g id="tt" transform="translate(0.000000, 1.000000)"
                                                   stroke-linecap="round" stroke-linejoin="round">
                                                    <path d="M4.48803191,22.5 C6.96579953,22.5 8.97606383,20.484375 8.97606383,18 C8.97606383,16.6875 8.41505984,15.46875 7.48005319,14.625 L7.48005319,3 C7.48005319,1.359375 6.12429355,0 4.48803191,0 C2.85177028,0 1.49601064,1.359375 1.49601064,3 L1.49601064,14.625 C0.561003989,15.46875 0,16.6875 0,18 C0,20.484375 2.0102643,22.5 4.48803191,22.5 Z"
                                                          id="Stroke-1"/>
                                                    <path d="M4.48803191,16.5 C5.3295379,16.5 5.98404255,17.15625 5.98404255,18 C5.98404255,18.84375 5.3295379,19.5 4.48803191,19.5 C3.64652593,19.5 2.99202128,18.84375 2.99202128,18 C2.99202128,17.15625 3.64652593,16.5 4.48803191,16.5 Z"
                                                          id="Stroke-3" stroke-width="2"/>
                                                </g>
                                                <path d="M4.42819149,17.5159574 L4.42819149,9.64095745" id="Stroke-6"
                                                      stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                <path d="M4.5,25.5 L4.5,27.5" id="Line-5" stroke-linecap="square"/>
                                                <path d="M4.5,27.5 L24.5,27.5" id="Line-6" stroke-linecap="square"/>
                                                <path d="M24.5,16.5 L24.5,26.5" id="Line-7" stroke-linecap="square"/>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>BBoil</a>
                <a data-target="bgate">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="26px"
                         height="30px" viewBox="0 0 26 30" version="1.1">
                        <defs/>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"
                           stroke-linecap="round" stroke-linejoin="round">
                            <g id="index" transform="translate(-539.000000, -115.000000)" stroke="#D8D8D8">
                                <g id="products-2" transform="translate(258.000000, 115.000000)">
                                    <g id="PS-Gate" transform="translate(260.000000, 1.000000)">
                                        <g id="icon" transform="translate(22.000000, 0.000000)">
                                            <path d="M9.75068699,12.1788618 L9.75068699,23.1056911 C9.75068699,25.7877724 7.5764187,27.9620407 4.8943374,27.9620407 C2.21219919,27.9620407 0.0379308943,25.7877724 0.0379308943,23.1056911 L0.0379308943,4.89430894 C0.0379308943,2.21222764 2.21219919,0.0379593496 4.8943374,0.0379593496 C6.62880081,0.0372195122 8.23191463,0.96195935 9.09963008,2.46382927"
                                                  id="Stroke-1" stroke-width="2"/>
                                            <path d="M3.68020732,7.32248374 L3.68020732,7.32248374 C3.68020732,8.66352439 4.76736992,9.75068699 6.10841057,9.75068699 L21.8915894,9.75068699 C23.2326301,9.75068699 24.3197927,8.66352439 24.3197927,7.32248374 C24.3197927,5.98144309 23.2326301,4.89428049 21.8915894,4.89428049 L6.10841057,4.89428049 C4.76736992,4.89428049 3.68020732,5.98144309 3.68020732,7.32248374 Z"
                                                  id="Stroke-3"/>
                                            <path d="M6.10841057,19.4634146 C6.10841057,20.133935 5.56485772,20.6774878 4.8943374,20.6774878 C4.22376016,20.6774878 3.68020732,20.133935 3.68020732,19.4634146 C3.68020732,18.7928943 4.22376016,18.2493415 4.8943374,18.2493415 C5.56485772,18.2493415 6.10841057,18.7928943 6.10841057,19.4634146 Z"
                                                  id="Stroke-5"/>
                                            <path d="M4.89430894,20.6774878 L4.89430894,23.1056911" id="Stroke-8"/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>PS Gate</a>
                <a data-target="ps-plug">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1"
                         width="30px" height="30px" id="Capa_1" x="0px" y="0px" viewBox="0 0 19.1 26.9"
                         style="enable-background:new 0 0 19.1 26.9;" xml:space="preserve">
                            <g>
                                <g id="_x32_5_1_">
                                    <g>
                                        <path class="st0-plug"
                                              d="M18.6,6.7h-2.4V1.9c0-1-0.8-1.9-1.9-1.9c-1,0-1.9,0.9-1.9,1.9v4.8H7.2V1.9c0-1-0.8-1.9-1.9-1.9     c-1,0-1.9,0.9-1.9,1.9v4.8H0.5C0.2,6.7,0,6.9,0,7.2v7.9c0,1.7,1.4,3,3,3h3.7c0,0.1,0,0.1,0,0.2v8.1c0,0.3,0.2,0.5,0.5,0.5     c0.3,0,0.5-0.2,0.5-0.5v-8.1c0-0.1,0-0.1,0-0.2h3.9c0,0.1,0,0.1,0,0.2v5.2c0,0.3,0.2,0.5,0.5,0.5c0.3,0,0.5-0.2,0.5-0.5v-5.2     c0-0.1,0-0.1,0-0.2H16c1.7,0,3-1.4,3-3V7.2C19.1,6.9,18.9,6.7,18.6,6.7z M13.4,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9     v4.8h-1.9V1.9z M4.3,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9v4.8H4.3C4.3,6.7,4.3,1.9,4.3,1.9z M18.1,15.1     c0,1.2-0.9,2.1-2.1,2.1H3c-1.2,0-2.1-0.9-2.1-2.1V7.6h17.2L18.1,15.1L18.1,15.1z"/>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    <br/>PS Plug</a>
                <a data-target="bsafe-f">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                         height="29px" viewBox="0 0 25 29" version="1.1">
                        <defs/>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g id="index" transform="translate(-668.000000, -117.000000)" stroke="#D8D8D8">
                                <g id="products-2" transform="translate(258.000000, 115.000000)">
                                    <g id="PF-Safe" transform="translate(396.000000, 3.000000)">
                                        <g id="icon-copy-2" transform="translate(15.000000, 0.000000)">
                                            <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                                  id="Fill-1" fill="#D8D8D8"/>
                                            <path d="M10.5231897,4 C10.2812396,6.51462069 9.24930366,8.88821065 7.5751895,10.7807088 C5.06346879,13.5867319 5.50228195,17.5995447 9.2755256,18.7273631 C7.7133813,16.9844736 9.11779708,13.3601059 9.11779708,13.3601059 C9.88033987,13.3940815 10.5289591,13.9270067 10.709857,14.6682423 C11.4930354,13.3814437 11.9342907,11.9159146 11.9917103,10.4107626 C15.4403696,14.6284057 14.8088145,17.4874527 13.5109044,18.8074637 C17.9232431,17.6873073 19.3523546,12.5585812 10.5231897,4 Z"
                                                  id="Page-1" stroke-linecap="round" stroke-linejoin="round"/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>PS Fire</a>
                <a data-target="bsafe-w">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                         height="29px" viewBox="0 0 25 29" version="1.1">
                        <defs/>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g id="index" transform="translate(-806.000000, -116.000000)" fill="#D8D8D8">
                                <g id="products-2" transform="translate(258.000000, 115.000000)">
                                    <g id="PW-Safe" transform="translate(532.000000, 2.000000)">
                                        <g id="icon" transform="translate(17.000000, 0.000000)">
                                            <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                                  id="Fill-1" stroke="#D8D8D8"/>
                                            <path d="M11.25,19.75 C8.28841947,19.75 6,17.5187295 6,14.63125 C6,13.9749795 6.13459435,13.3187705 6.40384615,12.7937295 L6.40384615,12.6625 C6.5384405,12.5312705 6.5384405,12.26875 6.67309796,12.1375205 L10.7115595,4.26252051 C10.7115595,4.13122949 10.9807482,4 11.25,4 C11.3845944,4 11.6538462,4.13122949 11.7885036,4.26252051 L15.8269651,12.1375205 C15.9615595,12.26875 16.0961538,12.5312705 16.0961538,12.6625 C16.3654056,13.3187705 16.5,13.9749795 16.5,14.63125 C16.5,17.3875 14.0769231,19.75 11.25,19.75 M7.48079026,13.05625 L7.48079026,13.05625 C7.34613281,13.5812295 7.21153846,14.1062705 7.21153846,14.63125 C7.21153846,16.862459 9.09617488,18.56875 11.25,18.56875 C13.5384826,18.56875 15.2884615,16.862459 15.2884615,14.63125 C15.2884615,14.1062705 15.1538672,13.5812295 15.0192097,13.05625 C14.8846154,12.924959 14.8846154,12.7937295 14.7499579,12.6625 L11.25,5.83745898 L7.74997897,12.6625 C7.74997897,12.7937295 7.61538462,12.924959 7.48079026,13.05625"
                                                  id="Fill-3"/>
                                            <path d="M10.625,17.625 C9.18124077,17.625 8,16.4437592 8,15 L9.18124077,15 C9.18124077,15.7875554 9.83750615,16.4437592 10.625,16.4437592 L10.625,17.625 Z"
                                                  id="Fill-5"/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>PS Water</a>
                <a data-target="bsafe-a">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                         height="29px" viewBox="0 0 25 29" version="1.1">
                        <defs/>
                        <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                            <g id="index" transform="translate(-944.000000, -116.000000)" fill="#D8D8D8">
                                <g id="products-2" transform="translate(258.000000, 115.000000)">
                                    <g id="PA-Safe" transform="translate(672.000000, 2.000000)">
                                        <g id="icon-copy-4" transform="translate(15.000000, 0.000000)">
                                            <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                                  id="Fill-1" stroke="#D8D8D8"/>
                                            <path d="M9,18 C9.27427432,18.867318 10.1225529,19.5 11.1270083,19.5 C12.126143,19.5 12.9711353,18.8743368 13.25,18.0136422 C12.5216447,18.1151679 11.7963148,18.1647445 11.1708254,18.1647445 C10.5188892,18.165041 9.75876649,18.1103239 9,18 M17.4880588,14.5612033 C17.3385726,13.7564575 17.1046587,13.2964369 16.8781126,12.8516002 C16.593366,12.2919789 16.2982397,11.7132733 16.1345741,10.1408824 C15.8339799,7.25873063 14.5979156,5.5890607 12.4628953,5.15114265 C12.4251299,4.50998345 11.8991944,4 11.2498146,4 C10.5857457,4 10.0476696,4.53324683 10.0331658,5.19562632 C8.62912646,5.57341247 6.69720537,6.78324756 6.30504744,10.5414676 C6.14490355,12.0753648 5.89435435,12.4978668 5.62934771,12.9448395 C5.41248618,13.3102278 5.16717317,13.7241395 5.01180208,14.5612033 C4.97361962,14.768995 5.02908613,14.9826837 5.16365148,15.1448309 C6.34869778,16.576295 9.66306475,16.9545455 11.2500463,16.9545455 C12.8367961,16.9545455 16.1513948,16.5760628 17.3369508,15.1450631 C17.4710064,14.9824516 17.5265193,14.7687628 17.4880588,14.5612033 M11.2492858,16.0181406 C9.43101444,16.0181406 7.12330319,15.5675201 6.19047619,14.8746368 C6.2939102,14.5103064 6.42049373,14.2970698 6.57131036,14.043029 C6.90771716,13.4770922 7.28874835,12.8354114 7.49330142,10.8779422 C7.90230904,6.96532008 10.0224107,6.38095238 11.2492858,6.38095238 C12.770209,6.38095238 14.564198,6.8439423 14.9414859,10.4527997 C15.1450046,12.4007084 15.5398763,13.1757915 15.8888922,13.8591144 C16.0578836,14.1903776 16.199342,14.4676788 16.3095238,14.8734048 C15.3772386,15.5672737 13.068296,16.0181406 11.2492858,16.0181406"
                                                  id="Page-1"/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </svg>
                    <br/>PS Alarm</a>
                </ul>
            </div>
            <div class="product-content margin-auto">
                <a href="/bboil-rf"
                   class="product no-decoration color-dark-blue">
                    <div id="bboil-rf" class="product-description active col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">BBoil RF</p>
                        <p>
                            {!! Lang::get('lang.layer2RfMsg1') !!}
                        </p>
                        <p>
                            {!! Lang::get('lang.layer2RfMsg2') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="bboil" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">BBoil</p>
                        <p>
                            {!! Lang::get('lang.layer2BoilMsg1') !!}
                        </p>
                        <p>
                            {!! Lang::get('lang.layer2BoilMsg2') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="bgate" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">PS Gate</p>
                        <p>
                            {!! Lang::get('lang.layer2GateMsg1') !!}
                        </p>
                        <p>
                            {!! Lang::get('lang.layer2GateMsg2') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="ps-plug" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">PS Plug</p>
                        <p>
                            {!! Lang::get('lang.layer2PSPlugMsg1') !!}
                        </p>
                        <p>
                            {!! Lang::get('lang.layer2PSPlugMsg2') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="bsafe-f" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">PS Fire</p>
                        <p>
                            {!! Lang::get('lang.layer2BSafeFMsg1') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="bsafe-w" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">PS Water</p>
                        <p>
                            {!! Lang::get('lang.layer2BSafeWMsg1') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div id="bsafe-a" class="product-description col-lg-4 col-md-4 col-sm-12">
                        <p class="color-dark-blue font-30 bold">PS Alarm</p>
                        <p>
                            {!! Lang::get('lang.layer2BSafeAMsg1') !!}
                        </p>
                        <p class="text-center visible-md visible-lg"><br/><br/>
                            <span class="buy-btn">
                                {!! Lang::get('lang.seeMore') !!}
                        </span>
                        </p>
                        @include('blocks.banner-device-compatibility')
                    </div>
                    <div class="product-image col-lg-8 col-md-8 col-sm-12">
                        @include('banners.house')
                    </div>
                    <div class="clearfix"></div>
                </a>

            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <section id="contacts" name="contacts" class="col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
        <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12 clear-left-right-padding">
            <div class="col-lg-10 col-lg-offset-1 padding-top-30">
                <p class="under-header-label-border text-uppercase color-dark-blue font-20 unisans-bold standart-padding-bottom standart-margin-bottom">
                    {{ Lang::get('lang.aboutCompany') }}
                </p>
                <br/>
                <p class="color-dark-gray font-16">
                    {{ Lang::get('lang.aboutCompanyMsg1') }}
                </p>

                <p class="color-dark-gray font-16">
                    {{ Lang::get('lang.aboutCompanyMsg2') }}
                </p>
                <br/><br/>
                <p>
                    <a href="https://www.facebook.com/Pro-Smart-System-1509051346088855" class="no-decoration"
                       target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="42px"
                             height="42px" viewBox="0 0 42 42" version="1.1">
                            <defs/>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="index" transform="translate(-71.000000, -1704.000000)">
                                    <g id="bottom" transform="translate(69.000000, 1393.000000)">
                                        <g id="contacts" transform="translate(2.000000, 0.000000)">
                                            <g id="share" transform="translate(1.000000, 312.000000)">
                                                <g id="fb-icon">
                                                    <circle id="Oval-4" stroke="#294A9B" fill="#3D599D" cx="20" cy="20"
                                                            r="20"/>
                                                    <g id="f" transform="translate(15.000000, 9.500000)" fill="#FFFFFF">
                                                        <path d="M7.16644207,3.68744346 L9.42431159,3.68744346 L9.42431159,0.181818182 L6.35445351,0.181818182 C2.00562323,0.181818182 2.10843,3.55211203 2.10843,4.05554494 L2.10843,6.80926881 L0.0909090909,6.80926881 L0.0909090909,10.1764951 L2.10843,10.1764951 L2.10843,20.1818182 L6.25245873,20.1818182 L6.25245873,10.1764951 L9.03329399,10.1764951 C9.03329399,10.1764951 9.29362655,8.56172056 9.41993588,6.79663788 L6.26820228,6.79663788 L6.26820228,4.4941992 C6.26802184,4.15027694 6.71966792,3.68744346 7.16644207,3.68744346"
                                                              id="Fill-1"/>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </a>
                    <a href="https://twitter.com/ProSmartSystem" class="no-decoration" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="42px"
                             height="42px" viewBox="0 0 42 42" version="1.1">
                            <defs/>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="index" transform="translate(-121.000000, -1704.000000)">
                                    <g id="bottom" transform="translate(69.000000, 1393.000000)">
                                        <g id="contacts" transform="translate(2.000000, 0.000000)">
                                            <g id="share" transform="translate(1.000000, 312.000000)">
                                                <g id="twitter-icon" transform="translate(50.000000, 0.000000)">
                                                    <circle id="Oval-4" stroke="#32ACC8" fill="#47B9E4" cx="20" cy="20"
                                                            r="20"/>
                                                    <path d="M15.6452144,24.3005303 C14.1203668,23.6058731 13.1232588,22.592773 12.9095643,20.8368395 C13.2947742,20.8776193 13.6118177,20.9110029 14.0641945,20.9587793 C12.6786782,19.820341 11.9972145,18.4836007 12.3154574,16.6229188 C12.7182587,16.7844391 13.0333032,16.9109767 13.4784835,17.0894886 C12.5759289,15.2867781 12.6376984,13.6581818 13.9212651,12 C15.6242247,14.7042656 17.7329842,16.7842392 20.884629,17.595239 C21.0349548,17.0327166 21.111517,16.5095747 21.3108187,16.0386071 C22.3702959,13.5352424 25.8117977,12.7722189 27.6918699,14.7286535 C28.431505,15.4982738 29.1047727,15.5192634 29.9639488,15.3373032 C30.2598028,15.2747841 30.5550571,15.2092164 30.8505113,15.1448482 C30.9066836,15.2086167 30.9628059,15.2725851 31.0188282,15.3363537 C30.5840428,15.8211145 30.1494572,16.3058753 29.6742917,16.8356139 C29.8919843,16.8296168 30.1124755,16.8258187 30.3327668,16.8168231 C30.5700497,16.8072279 30.8073326,16.792785 31.1757508,16.973146 C30.6979866,17.3417641 30.2610022,17.7915422 29.7318633,18.0580107 C29.1109697,18.3706564 28.8846813,18.8176358 28.7391532,19.4635171 C26.9248484,27.5117457 16.6605134,30.771937 10.4927568,25.271851 C10.3672188,25.1599062 10.2686674,25.0177764 10,24.7083291 C12.0419924,25.1149284 13.8421041,25.170501 15.6452144,24.3005303"
                                                          id="Fill-1" fill="#FFFFFF"/>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </a>
                    <a href="https://plus.google.com/103711668135798710066" class="no-decoration" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="42px"
                             height="42px" viewBox="0 0 42 42" version="1.1">
                            <defs/>
                            <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <g id="index" transform="translate(-172.000000, -1704.000000)">
                                    <g id="bottom" transform="translate(69.000000, 1393.000000)">
                                        <g id="contacts" transform="translate(2.000000, 0.000000)">
                                            <g id="share" transform="translate(1.000000, 312.000000)">
                                                <g id="G+-icon" transform="translate(101.000000, 0.000000)">
                                                    <circle id="Oval-4" stroke="#D0483E" fill="#F0594C" cx="20" cy="20"
                                                            r="20"/>
                                                    <g id="G+" transform="translate(8.000000, 12.000000)"
                                                       fill="#FFFFFF">
                                                        <path d="M8.3071547,7.15767278 C8.30319376,8.10113346 8.3071547,9.04459414 8.31117389,9.98799657 C9.89281172,10.039547 11.4784105,10.0157231 13.0601066,10.039547 C12.3623988,13.5477156 7.58975878,14.6853788 5.06460202,12.3942087 C2.46814836,10.38444 2.59105397,5.97643927 5.29055028,4.10938085 C7.17747165,2.60305911 9.86112421,2.9756786 11.7479291,4.27981771 C12.4892654,3.59405105 13.1828957,2.86069488 13.8528186,2.09961213 C12.2830636,0.846965222 10.3565911,-0.044945006 8.3071547,0.0502340243 C4.0299815,-0.0924762721 0.0977012164,3.65352339 0.0263460682,7.93069659 C-0.247191708,11.4269241 2.05195854,14.8558739 5.29853041,16.0926188 C8.53316121,17.3372856 12.6795069,16.4890039 14.7448453,13.5833641 C16.1084567,11.7480514 16.401741,9.38552613 16.2431869,7.1656529 C13.5951246,7.14578996 10.9511979,7.1497509 8.3071547,7.15767278"
                                                              id="Fill-1"/>
                                                        <path d="M23.7747315,7.14578414 C23.7668097,6.35691657 23.7628487,5.56414631 23.758946,4.77533699 L21.4002652,4.77533699 C21.3924016,5.56420456 21.3844797,6.35301388 21.3804605,7.14578414 C20.587632,7.14974507 19.7988227,7.15376426 19.0100134,7.16168614 L19.0100134,9.52025047 C19.7988227,9.5282306 20.5916512,9.53621072 21.3804605,9.5440161 C21.3883824,10.3328837 21.3883824,11.121693 21.3963625,11.9105606 L23.758946,11.9105606 C23.7628487,11.121693 23.7668097,10.3328837 23.7747315,9.54011341 C24.56756,9.53213329 25.3563694,9.5282306 26.1451787,9.52025047 L26.1451787,7.16168614 C25.3563694,7.15376426 24.5635991,7.15376426 23.7747315,7.14578414"
                                                              id="Fill-3"/>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </svg>
                    </a>
                </p>
                <p class="color-light-gray unisans-regular-italic">
                    {{ Lang::get('lang.allRightsReserved') }}
                </p>
            </div>
        </div>
        <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12 bg-transperent clear-left-right-padding">
            <div class="col-lg-11 col-md-12 col-sm-12 col-xs-12 padding-top-30">
                <p class="under-header-label-border text-uppercase color-dark-blue font-20 unisans-bold standart-padding-bottom standart-margin-bottom">
                    {{ Lang::get('lang.contacts') }}
                </p>
                <br/>
                <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12 text-center-sm clear-left-right-padding">
                    <p>
                    <div>
                        <span class="dz-icon standart-margin-right font-18">&#58952;</span>
                        {{ Lang::get('lang.addressStr') }}
                    </div>
                    <div>
                        <span class="dz-icon standart-margin-right font-18">&#58992;</span>
                        (+359) 894 704 379
                    </div>
                    <div>
                        <span class="dz-icon standart-margin-right font-18">&#58937;</span>
                        <a href="mailto:office@prosmartsystem.com"
                           class="color-light-blue">office@prosmartsystem.com</a>
                    </div>
                    </p>
                    @if(App::getLocale() == 'bg')
                        <p style="font-size: 0.9em;">
                            <br/>Национален представител - Трифар ООД<br/>
                            гр. София, ул. Бесарабия 15<br/><br/>
                            <strong>Офис:</strong><br/>02/41 71 452; 0893 629 340<br/><br/>
                            <strong>Търговски отдел:</strong><br/>0893 629 342
                        </p>
                    @endif
                    <br/>
                    <div data-target="#modal-ticket" data-toggle="modal"
                         class="col-lg-12 col-md-12 col-sm-12 col-xs-12 text-left cursor-pointer clear-left-padding standart-margin-bottom">
                        <div class="pull-left standart-margin-right">
                            <div class="image" data-img="/images/tech-support.png" data-width="40" data-height="40"
                                 data-title="proSmart"></div>
                        </div>
                        <div class="standart-padding-top">
                            <span type="button"
                                  style="color:#6e8cd6;line-height: 17px !important;display: block;">{!!  Lang::get('lang.technicalSupport') !!}</span>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12 text-center-sm clear-right-padding">
                    {!! Form::open(array('class' => 'footer-form', 'name' => 'mail-request-form', 'id' => 'mail-request-form')) !!}
                    <p>
                        <input name="name" id="name" type="text" placeholder="{{ Lang::get('lang.name') }}"/>
                    <div data-source='name' class="error-msg-name color-red"></div>
                    </p>
                    <p>
                        <input name="email" id="email" type="text" placeholder="{{ Lang::get('lang.email') }}"/>
                    <div data-source='email' class="error-msg-email color-red"></div>
                    </p>
                    <p>
                        <textarea name="message" id="message" placeholder="{{ Lang::get('lang.message') }}"></textarea>
                    <div data-source='message' class="error-msg-message color-red"></div>
                    </p>
                    {!! Form::close() !!}
                    <div class="col-lg-6 col-lg-offset-3 col-md-6 col-md-offset-3 col-sm-4 col-sm-offset-4 col-xs-6 col-xs-offset-3 unisans-bold standart-margin-top standart-margin-bottom">
                        <button name="mail-request-btn" id="mail-request-btn"
                                class="custom-btn-blue-bold-fill-to-blue-fill">{{ Lang::get('lang.send') }}</button>
                    </div>
                </div>

            </div>
        </div>

    </section>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <div class="image" data-img="images/icon-success.png" data-width="34"
                     data-height="33"></div>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <div class="image" data-img="images/icon-error.gif" data-width="37"
                     data-height="33"></div>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    @include('blocks.analytics')
@endsection
