@extends('layouts.master')

@section('title', 'PS Water - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')
    <script type="text/javascript">
        $(document).ready(function () {
            @if(Session::get('ShowCartBox'))
            $('#order-modal').modal('show');
            @if(config('app.locale') == 'bg')
            getDeliveryPrice($('select[data-action="get-delivery-price"]').val());
            @endif
            @endif

            @if(Session::has('transaction'))
            $('#modal-success').modal('show');
            @endif

            @if($errors->has('exception'))
            $('#modal-error').modal('show');
            @endif
        });
    </script>
    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url().'/'.App::getLocale()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-righ line-height-50t">
                    {!! Lang::get('lang.contacts') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg/bsafe-w'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en/bsafe-w'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru/bsafe-w'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de/bsafe-w'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr/bsafe-w'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl/bsafe-w'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu/bsafe-w'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr/bsafe-w'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk/bsafe-w'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>

    <div class="clearfix"></div>
    @include('blocks.top-product-navigation')
    <div class="clearfix"></div>

    <section
            class="layer-two col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding standart-padding-bottom standart-margin-bottom">
        <div class="layer-two-header" id="layer-two-header">
            <div class="col-lg-4 col-lg-offset-4 col-md-4 col-md-offset-4 col-sm-12 col-xs-12 clear-left-right-padding">
                <ul class="col-lg-12 col-md-12 clear-left-right-padding">
                    <li class="tab-left col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
                        <a id="layer-two-boil-btn" class="active no-decoration">
                            <div class="tab-content">
                                <svg class="pull-left" style="margin-right: 30px;" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="45px" height="49px" viewBox="0 0 25 29" version="1.1">
                                    <defs/>
                                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <g id="index" transform="translate(-806.000000, -116.000000)" fill="#E2948E">
                                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                                <g id="PW-Safe" transform="translate(532.000000, 2.000000)">
                                                    <g id="icon" transform="translate(17.000000, 0.000000)">
                                                        <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z" id="Fill-1" stroke="#E2948E"/>
                                                        <path d="M11.25,19.75 C8.28841947,19.75 6,17.5187295 6,14.63125 C6,13.9749795 6.13459435,13.3187705 6.40384615,12.7937295 L6.40384615,12.6625 C6.5384405,12.5312705 6.5384405,12.26875 6.67309796,12.1375205 L10.7115595,4.26252051 C10.7115595,4.13122949 10.9807482,4 11.25,4 C11.3845944,4 11.6538462,4.13122949 11.7885036,4.26252051 L15.8269651,12.1375205 C15.9615595,12.26875 16.0961538,12.5312705 16.0961538,12.6625 C16.3654056,13.3187705 16.5,13.9749795 16.5,14.63125 C16.5,17.3875 14.0769231,19.75 11.25,19.75 M7.48079026,13.05625 L7.48079026,13.05625 C7.34613281,13.5812295 7.21153846,14.1062705 7.21153846,14.63125 C7.21153846,16.862459 9.09617488,18.56875 11.25,18.56875 C13.5384826,18.56875 15.2884615,16.862459 15.2884615,14.63125 C15.2884615,14.1062705 15.1538672,13.5812295 15.0192097,13.05625 C14.8846154,12.924959 14.8846154,12.7937295 14.7499579,12.6625 L11.25,5.83745898 L7.74997897,12.6625 C7.74997897,12.7937295 7.61538462,12.924959 7.48079026,13.05625" id="Fill-3"/>
                                                        <path d="M10.625,17.625 C9.18124077,17.625 8,16.4437592 8,15 L9.18124077,15 C9.18124077,15.7875554 9.83750615,16.4437592 10.625,16.4437592 L10.625,17.625 Z" id="Fill-5"/>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <div class="tab-title standart-margin-left">
                                    <div class="color-light-blue unisans-regular-italic font-16">{{ Lang::get('lang.solution') }}</div>
                                    <div class="color-dark-blue font-30 unisans-heavy standart-margin-top">PS Water
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-two-content product col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="col-lg-7 col-md-7 col-sm-12 clear-left-right-padding">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="ps-gallery-box">
                        <div class="ps-gallery-box-image">
                            <img src="{{ asset('images/BSafe-W-page.jpg') }}"/>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-5">
                    <h1 class="unisans-bold color-dark-blue">PS Water</h1>
                    <p>
                        <img class="standart-padding-top standart-padding-bottom"
                             src="{{ asset('images/layer-two-displays.png') }}"/></p>
                    <br/>
                    <div class="col-lg-12 clear-left-padding">

                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <br/><br/>
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.AboutProduct') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_w_description.about_ln_1') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_w_description.about_ln_2') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_w_description.about_ln_3') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_w_description.about_ln_4') !!}<br/><br/>
                    </div>
                    <br/>
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.WhyChoose') !!} PS Water</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_2') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_3') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_4') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_5') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_6') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_7') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_8') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_9') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_10') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_11') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_w.choose_ln_12') !!}
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-md-5">
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.UsageBSafeW') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_bsafe_w.manage_ln_1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_bsafe_w.manage_ln_2') !!}
                </div>
                <br/><br/>
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.real_time_info_bsafe_w') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_w.real_time_msg1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_w.real_time_msg2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_w.real_time_msg3') !!}
                </div>

                <br/><br/><br/>

                <a target="_blank" href="https://www.microsoft.com/bg-bg/store/apps/prosmart/9nblggh5qfnz">
                    <img class="standart-margin-right"
                         src="{{ asset('images/ms_app.png') }}" width="120"/>
                </a>
                <a target="_blank" href="https://play.google.com/store/apps/details?id=com.ProSmart.ProSmart">
                    <img class="standart-margin-right"
                         src="{{ asset('images/google_app.png') }}" width="145"/>
                </a>
                <a target="_blank" href="https://itunes.apple.com/us/app/prosmart/id1087882546">
                    <img class="standart-margin-right"
                         src="{{ asset('images/apple_app.jpg') }}" width="120"/>
                </a>
                <br/><br/><br/>

                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.you_get') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg3') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg4') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg5') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg6') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_w.you_get_msg7') !!}
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <br/>
    </section>
    <div class="clearfix"></div>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    @include('partials.success-payment-modal')
    @include('partials.failed-card-checkout-modal')
    @include('blocks.analytics')
@endsection
