@extends('layouts.master')

@section('title', 'PS Alarm - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')
    <script type="text/javascript">
        $(document).ready(function () {
            @if(Session::get('ShowCartBox'))
            //$('#order-modal').modal('show');
            @if(config('app.locale') == 'bg')
            getDeliveryPrice($('select[data-action="get-delivery-price"]').val());
            @endif
            @endif

            @if(Session::has('transaction'))
            $('#modal-success').modal('show');
            @endif

            @if($errors->has('exception'))
            $('#modal-error').modal('show');
            @endif
        });
    </script>
    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url().'/'.App::getLocale()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-righ line-height-50t">
                    {!! Lang::get('lang.contacts') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg/bsafe-a'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en/bsafe-a'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru/bsafe-a'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de/bsafe-a'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr/bsafe-a'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl/bsafe-a'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu/bsafe-a'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr/bsafe-a'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk/bsafe-a'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>

    <div class="clearfix"></div>
    @include('blocks.top-product-navigation')
    <div class="clearfix"></div>

    <section
            class="layer-two col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding standart-padding-bottom standart-margin-bottom">
        <div class="layer-two-header" id="layer-two-header">
            <div class="col-lg-4 col-lg-offset-4 col-md-4 col-md-offset-4 col-sm-12 col-xs-12 clear-left-right-padding">
                <ul class="col-lg-12 col-md-12 clear-left-right-padding">
                    <li class="tab-left col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
                        <a id="layer-two-boil-btn" class="active no-decoration">
                            <div class="tab-content">
                                <svg class="pull-left" style="margin-right: 30px;" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="45px" height="49px" viewBox="0 0 25 29" version="1.1">
                                    <defs/>
                                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <g id="index" transform="translate(-944.000000, -116.000000)" fill="#E2948E">
                                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                                <g id="PA-Safe" transform="translate(672.000000, 2.000000)">
                                                    <g id="icon-copy-4" transform="translate(15.000000, 0.000000)">
                                                        <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z" id="Fill-1" stroke="#E2948E"/>
                                                        <path d="M9,18 C9.27427432,18.867318 10.1225529,19.5 11.1270083,19.5 C12.126143,19.5 12.9711353,18.8743368 13.25,18.0136422 C12.5216447,18.1151679 11.7963148,18.1647445 11.1708254,18.1647445 C10.5188892,18.165041 9.75876649,18.1103239 9,18 M17.4880588,14.5612033 C17.3385726,13.7564575 17.1046587,13.2964369 16.8781126,12.8516002 C16.593366,12.2919789 16.2982397,11.7132733 16.1345741,10.1408824 C15.8339799,7.25873063 14.5979156,5.5890607 12.4628953,5.15114265 C12.4251299,4.50998345 11.8991944,4 11.2498146,4 C10.5857457,4 10.0476696,4.53324683 10.0331658,5.19562632 C8.62912646,5.57341247 6.69720537,6.78324756 6.30504744,10.5414676 C6.14490355,12.0753648 5.89435435,12.4978668 5.62934771,12.9448395 C5.41248618,13.3102278 5.16717317,13.7241395 5.01180208,14.5612033 C4.97361962,14.768995 5.02908613,14.9826837 5.16365148,15.1448309 C6.34869778,16.576295 9.66306475,16.9545455 11.2500463,16.9545455 C12.8367961,16.9545455 16.1513948,16.5760628 17.3369508,15.1450631 C17.4710064,14.9824516 17.5265193,14.7687628 17.4880588,14.5612033 M11.2492858,16.0181406 C9.43101444,16.0181406 7.12330319,15.5675201 6.19047619,14.8746368 C6.2939102,14.5103064 6.42049373,14.2970698 6.57131036,14.043029 C6.90771716,13.4770922 7.28874835,12.8354114 7.49330142,10.8779422 C7.90230904,6.96532008 10.0224107,6.38095238 11.2492858,6.38095238 C12.770209,6.38095238 14.564198,6.8439423 14.9414859,10.4527997 C15.1450046,12.4007084 15.5398763,13.1757915 15.8888922,13.8591144 C16.0578836,14.1903776 16.199342,14.4676788 16.3095238,14.8734048 C15.3772386,15.5672737 13.068296,16.0181406 11.2492858,16.0181406" id="Page-1"/>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <div class="tab-title standart-margin-left">
                                    <div class="color-light-blue unisans-regular-italic font-16">{{ Lang::get('lang.solution') }}</div>
                                    <div class="color-dark-blue font-30 unisans-heavy standart-margin-top">PS Alarm
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-two-content product col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="col-lg-7 col-md-7 col-sm-12 clear-left-right-padding">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="ps-gallery-box">
                        <div class="ps-gallery-box-image">
                            <img src="{{ asset('images/BSafe-A-page.jpg') }}"/>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-5">
                    <h1 class="unisans-bold color-dark-blue">PS Alarm</h1>
                    <p>
                        <img class="standart-padding-top standart-padding-bottom"
                             src="{{ asset('images/layer-two-displays.png') }}"/></p>
                    <br/>
                    <div class="col-lg-12 clear-left-padding">

                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <br/><br/>
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.AboutProduct') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_a_description.about_ln_1') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_a_description.about_ln_2') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_a_description.about_ln_3') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_a_description.about_ln_4') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.bsafe_a_description.about_ln_5') !!}<br/><br/>
                    </div>
                    <br/>
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.WhyChoose') !!} PS Alarm</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_2') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_3') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_4') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_5') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_6') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_7') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_8') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_9') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_10') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_11') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_12') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_bsafe_a.choose_ln_13') !!}
                    </div>
                </div>
            </div>

            <div class="col-lg-5 col-md-5">
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.UsageBSafeА') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_bsafe_a.manage_ln_1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_bsafe_a.manage_ln_2') !!}
                </div>
                <br/><br/>
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.real_time_info_bsafe_a') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_a.real_time_msg1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_a.real_time_msg2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.real_time_description_bsafe_a.real_time_msg3') !!}
                </div>
                <br/><br/><br/>
                <a target="_blank" href="https://www.microsoft.com/bg-bg/store/apps/prosmart/9nblggh5qfnz">
                    <img class="standart-margin-right"
                         src="{{ asset('images/ms_app.png') }}" width="120"/>
                </a>
                <a target="_blank" href="https://play.google.com/store/apps/details?id=com.ProSmart.ProSmart">
                    <img class="standart-margin-right"
                         src="{{ asset('images/google_app.png') }}" width="145"/>
                </a>
                <a target="_blank" href="https://itunes.apple.com/us/app/prosmart/id1087882546">
                    <img class="standart-margin-right"
                         src="{{ asset('images/apple_app.jpg') }}" width="120"/>
                </a>
                <br/><br/><br/>

                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.you_get') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg3') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg4') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg5') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg6') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.you_get_description_bsafe_a.you_get_msg7') !!}
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <br/>
    </section>
    <div class="clearfix"></div>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    @include('partials.success-payment-modal')
    @include('partials.failed-card-checkout-modal')
    @include('blocks.analytics')
@endsection
