@extends('layouts.master')

@section('title', 'PS Gate - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')
    <script type="text/javascript">
        $(document).ready(function () {
            @if(Session::get('ShowCartBox'))
            $('#order-modal').modal('show');
            @if(config('app.locale') == 'bg')
            getDeliveryPrice($('select[data-action="get-delivery-price"]').val());
            @endif
            @endif

            @if(Session::has('transaction'))
            $('#modal-success').modal('show');
            @endif

            @if($errors->has('exception'))
            $('#modal-error').modal('show');
            @endif
        });
    </script>
    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url().'/'.App::getLocale()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-righ line-height-50t">
                    {!! Lang::get('lang.contacts') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg/bgate'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en/bgate'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru/bgate'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de/bgate'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr/bgate'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl/bgate'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu/bgate'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr/bgate'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk/bgate'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>

    <div class="clearfix"></div>
    @include('blocks.top-product-navigation')
    <div class="clearfix"></div>

    <section
            class="layer-two col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding standart-padding-bottom standart-margin-bottom">
        <div class="layer-two-header" id="layer-two-header">
            <div class="col-lg-4 col-lg-offset-4 col-md-4 col-md-offset-4 col-sm-12 col-xs-12 clear-left-right-padding">
                <ul class="col-lg-12 col-md-12 clear-left-right-padding">
                    <li class="tab-left col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
                        <a id="layer-two-boil-btn" class="active">
                            <div class="tab-content">
                                <svg class="pull-left" style="margin-right: 30px;" xmlns="http://www.w3.org/2000/svg"
                                     width="46px" height="50px" viewBox="0 0 26 30" version="1.1">
                                    <defs/>
                                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"
                                       stroke-linecap="round" stroke-linejoin="round">
                                        <g id="index" transform="translate(-539.000000, -115.000000)" stroke="#E2948E">
                                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                                <g id="PS-Gate" transform="translate(260.000000, 1.000000)">
                                                    <g id="icon" transform="translate(22.000000, 0.000000)">
                                                        <path d="M9.75068699,12.1788618 L9.75068699,23.1056911 C9.75068699,25.7877724 7.5764187,27.9620407 4.8943374,27.9620407 C2.21219919,27.9620407 0.0379308943,25.7877724 0.0379308943,23.1056911 L0.0379308943,4.89430894 C0.0379308943,2.21222764 2.21219919,0.0379593496 4.8943374,0.0379593496 C6.62880081,0.0372195122 8.23191463,0.96195935 9.09963008,2.46382927"
                                                              id="Stroke-1" stroke-width="2"/>
                                                        <path d="M3.68020732,7.32248374 L3.68020732,7.32248374 C3.68020732,8.66352439 4.76736992,9.75068699 6.10841057,9.75068699 L21.8915894,9.75068699 C23.2326301,9.75068699 24.3197927,8.66352439 24.3197927,7.32248374 C24.3197927,5.98144309 23.2326301,4.89428049 21.8915894,4.89428049 L6.10841057,4.89428049 C4.76736992,4.89428049 3.68020732,5.98144309 3.68020732,7.32248374 Z"
                                                              id="Stroke-3"/>
                                                        <path d="M6.10841057,19.4634146 C6.10841057,20.133935 5.56485772,20.6774878 4.8943374,20.6774878 C4.22376016,20.6774878 3.68020732,20.133935 3.68020732,19.4634146 C3.68020732,18.7928943 4.22376016,18.2493415 4.8943374,18.2493415 C5.56485772,18.2493415 6.10841057,18.7928943 6.10841057,19.4634146 Z"
                                                              id="Stroke-5"/>
                                                        <path d="M4.89430894,20.6774878 L4.89430894,23.1056911"
                                                              id="Stroke-8"/>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <div class="tab-title standart-margin-left">
                                    <div class="color-light-blue unisans-regular-italic font-16">{{ Lang::get('lang.solution') }}</div>
                                    <div class="color-dark-blue font-30 unisans-heavy standart-margin-top">PS Gate</div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-two-content product col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="col-lg-7 col-md-7 col-sm-12 clear-left-right-padding">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="ps-gallery-box">
                        <div class="ps-gallery-box-image">
                            <img src="{{ asset('images/products/ps-gate/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/ps-gate-1.jpg') }}"/>
                        </div>
                        <div class="ps-gallery-box-thumbs">
                            <a class="ps-gallery-thumb-btn selected">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-gate/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/ps-gate-1.jpg') }}"
                                     width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-gate/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/ps-gate-2.jpg') }}"
                                     width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-gate/ps-gate-3.jpg') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-gate/ps-gate-4.jpg') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-gate/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/ps-gate-5.jpg') }}"
                                     width="60"/>
                            </a>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-5">
                    <h1 class="unisans-bold color-dark-blue">PS Gate</h1>
                    <p>
                        <img class="standart-padding-top standart-padding-bottom"
                             src="{{ asset('images/layer-two-displays.png') }}"/></p>
                    <br/>

                    @if(App::getLocale() == 'en')
                        <h2 class="unisans-bold color-dark-blue font-20">Universal control over</h2>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Entry and garage doors
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Roller shutters
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Interior and exterior blinds
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Barriers
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Roof windows
                        </div>
                        <br/><br/>
                    @endif

                    <div class="col-lg-12"><br/>
                        <div style="display: flex;align-items: center;margin-bottom: 20px">
                            <svg style="width:20px;color:#e1948e;margin-right: 10px"
                                 class="svg-inline--fa fa-file-pdf fa-w-12 fa-5x fa-pull-left" aria-hidden="true"
                                 data-prefix="fas" data-icon="file-pdf" role="img" xmlns="http://www.w3.org/2000/svg"
                                 viewBox="0 0 384 512" data-fa-i2svg="">
                                <path fill="currentColor"
                                      d="M181.9 256.1c-5-16-4.9-46.9-2-46.9 8.4 0 7.6 36.9 2 46.9zm-1.7 47.2c-7.7 20.2-17.3 43.3-28.4 62.7 18.3-7 39-17.2 62.9-21.9-12.7-9.6-24.9-23.4-34.5-40.8zM86.1 428.1c0 .8 13.2-5.4 34.9-40.2-6.7 6.3-29.1 24.5-34.9 40.2zM248 160h136v328c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V24C0 10.7 10.7 0 24 0h200v136c0 13.2 10.8 24 24 24zm-8 171.8c-20-12.2-33.3-29-42.7-53.8 4.5-18.5 11.6-46.6 6.2-64.2-4.7-29.4-42.4-26.5-47.8-6.8-5 18.3-.4 44.1 8.1 77-11.6 27.6-28.7 64.6-40.8 85.8-.1 0-.1.1-.2.1-27.1 13.9-73.6 44.5-54.5 68 5.6 6.9 16 10 21.5 10 17.9 0 35.7-18 61.1-61.8 25.8-8.5 54.1-19.1 79-23.2 21.7 11.8 47.1 19.5 64 19.5 29.2 0 31.2-32 19.7-43.4-13.9-13.6-54.3-9.7-73.6-7.2zM377 105L279 7c-4.5-4.5-10.6-7-17-7h-6v128h128v-6.1c0-6.3-2.5-12.4-7-16.9zm-74.1 255.3c4.1-2.7-2.5-11.9-42.8-9 37.1 15.8 42.8 9 42.8 9z"></path>
                            </svg>
                            @if(App::getLocale() == 'bg')
                                <a class="color-dark-blue font-20" style="margin-top: 5px;" href="https://www.bboilrf.com/documents/User_manual_PS_Gate_BG.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @elseif(App::getLocale() == 'ru')
                                <a class="color-dark-blue font-20" style="margin-top: 5px;" href="https://www.bboilrf.com/documents/User_manual_PS_Gate_RU.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @else
                                <a class="color-dark-blue font-20" style="margin-top: 5px;" href="https://www.bboilrf.com/documents/User_manual_PS_Gate_EN.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-12 clear-left-padding hidden">
                        @if(empty(Session::get('init_user.ip_api')) || (Session::get('init_user.ip_api') && (Session::get('init_user.ip_api.country_code') != 'GR' && Session::get('init_user.ip_api.country_code') != 'XK' && Session::get('init_user.ip_api.country_code') != 'MK' && Session::get('init_user.ip_api.country_code') != 'AL' && Session::get('init_user.ip_api.country_code') != 'NL' && Session::get('init_user.ip_api.country_code') != 'RU') ))
                            @if(App::getLocale() != 'hu')
                                <div class="col-lg-6 clear-left-padding">
                                    <div class="font-50 line-height-50 pull-left">
                                        @if(config('app.locale') == 'bg')
                                            69
                                        @else
                                            35
                                        @endif
                                    </div>
                                    <div class="font-18 pull-left">00</div>
                                    <div class="font-22 line-height-60 pull-left">{{Config::get('app.currency')}}</div>
                                </div>
                                <div class="clearfix"></div>
                                <br/>
                            @endif
                            <div class="col-lg-6 col-md-7 col-sm-5 col-xs-12 clear-left-right-padding">
                                @if(App::getLocale() == 'hu')
                                    <a style="display: block;text-align: center;"
                                       href="http://www.quantrax.hu/viszontelado-partnereink" target="_blank"
                                       class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </a>
                                @else
                                    {!! Form::open(array('route' => 'post-add-to-cart')) !!}
                                    {!! Form::hidden('Good', '3') !!}
                                    <button type="submit"
                                            class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </button>
                                    {!! Form::close() !!}
                                @endif
                            </div>
                        @endif
                    </div>
                    <div class="clearfix"></div>
                </div>

                @if(App::getLocale() == 'en')
                    <style>
                        .benefits .tab-btn {
                            background-color: #f6f6f6;
                            border: 3px solid #fff;
                            padding: 10px;
                            text-align: center;
                            font-size: 16px;
                            font-weight: bold;
                            cursor: pointer;
                        }

                        .benefits .tab-btn.active, .benefits .tab-btn:hover {
                            background-color: #374771;
                            color: #fff;
                        }

                        .benefits .tab-content {
                            display: none;
                        }

                        .benefits .tab-content.active {
                            display: block;
                            background-color: #fff;
                            border: 10px solid #f6f6f6;
                            padding: 10px;
                        }
                    </style>

                    <script>
                        $(document).ready(function () {
                            $('body').on('click', '.tab-btn', function () {
                                $('.tab-content').removeClass('active');
                                $('.tab-btn').removeClass('active');
                                var target = $(this).data('target');
                                $('.tab-content[data-id="' + target + '"]').addClass('active');
                                $(this).addClass('active');
                            });
                        });
                    </script>

                    <div class="clearfix"></div>
                    <h2 class="unisans-bold color-dark-blue font-20">Benefits</h2>
                    <div class="col-lg-12 benefits">
                        <div class="col-lg-3 tab-btn active" data-target="homeowners">Homeowners</div>
                        <div class="col-lg-3 tab-btn" data-target="installers">Installers</div>
                        <div class="col-lg-3 tab-btn" data-target="distributors">Distributors</div>
                        <div class="col-lg-3 tab-btn" data-target="manufacturers">Manufacturers</div>
                        <div class="col-lg-12 tab-content active" data-id="homeowners">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Remote control from any part of the world<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Monitor the status of your door<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                No more need of expensive remote controls, chips and cards<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Share access with unlimited number of people<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Access full operational history<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Use your favorite mobile devices. The proSmart app works with all devices and operating systems.<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Get free access to all app features<br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="installers">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Save money and time<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Enjoy extra comfort <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Fast and easy setup
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Suitable for new installations as well as upgrading old ones
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Trouble-free maintenance<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Suitable for all doors regardless of the manufacturer<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Technical support<br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="distributors">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Save time and money<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Make life easier<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Become part of the fastest growing IoT network
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Limit the number of device shares and create subscription plans
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Stop users with unpaid bills<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Your own admin panel, where you can manage each sold device<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Fast and easy deliveries from an EU manufacturer
                                <br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="manufacturers">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Upgrade the functionality of any door, barrier or roof window<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Bring comfort to your customers<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Become part of the fastest growing IoT network
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Add great value to the end product at a very small cost
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Made of high-quality materials with an average life expectancy of 10 years<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Possibility for full rebranding<br/><br/>
                            </div>
                        </div>
                    </div>
                @endif

                @if(App::getLocale() != 'en')
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.AboutProduct') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.gate_description.about_ln_1') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.gate_description.about_ln_2') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.gate_description.about_ln_3') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.gate_description.about_ln_4') !!}<br/><br/>
                    </div>
                    <br/>
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.WhyChoose') !!} PS Gate</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_gate.choose_ln_1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_gate.choose_ln_2') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_gate.choose_ln_3') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_gate.choose_ln_4') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.why_choose_gate.choose_ln_5') !!}
                    </div>
                </div>
                @endif
            </div>
            <div class="col-lg-5 col-md-5">
                @if(App::getLocale() == 'en')
                    <h2 class="unisans-bold color-dark-blue font-20">You gain</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Optimization</strong><br/>
                        PS Gate optimizes your doors, barriers and blinds by ensuring higher comfort
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Control</strong><br/>
                        Easy and reliable remote control from any part of the world
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Real time information</strong><br/>
                        Constant information regarding the status of your door or window
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">History</strong><br/>
                        PS Gate keeps track of all door activity
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">High level of security</strong><br/>
                        Storing the data and logins using a secure server
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Fast and easy installation</strong><br/>
                        PS Gate can be installed to door regardless of the manufacturer. It connects with any Wi-Fi without the need of any additional settings.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">For the whole family</strong><br/>
                        Share access with unlimited number of people and get rid of expensive remote controls.
                    </div>
                @else
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.UsageBGate') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_gate.manage_ln_1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_gate.manage_ln_2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_gate.manage_ln_3') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.manage_description_gate.manage_ln_4') !!}
                </div>
                <br/>
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.FirstStep') !!}</h2>
                @if(App::getLocale() == 'bg')
                    <iframe width="100%" height="315" src="https://www.youtube.com/embed/JcSkhQzX_d8" frameborder="0"
                            allowfullscreen></iframe>
                @else
                    <iframe width="100%" height="315" src="https://www.youtube.com/embed/8jAa3GCuP9k" frameborder="0"
                            allowfullscreen></iframe>
                @endif
                <div class="clearfix"></div>
                @endif
            </div>
        </div>
        <div class="clearfix"></div>
        <br/>
    </section>
    <div class="clearfix"></div>
    @if(App::getLocale() == 'en')
        <div class="col-lg-12">
            <div class="col-lg-6">
                <iframe width="100%" height="315" src="https://www.youtube.com/embed/8jAa3GCuP9k" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
            <div class="col-lg-6">
                <iframe width="100%" height="315" src="https://www.youtube.com/embed/CgISWdbRkcA" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
        <div class="clearfix"></div>
        <br/><br/>
    @endif
    <div class="clearfix"></div>
    <div class="col-lg-12 text-center">
        <a target="_blank" href="https://play.google.com/store/apps/details?id=com.ProSmart.ProSmart">
            <img class="standart-margin-right"
                 src="{{ asset('images/google_app.png') }}" width="145"/>
        </a>
        <a target="_blank" href="https://itunes.apple.com/us/app/prosmart/id1087882546">
            <img class="standart-margin-right"
                 src="{{ asset('images/apple_app.jpg') }}" width="120"/>
        </a>
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    @include('partials.cart-modal')
    @include('partials.success-payment-modal')
    @include('partials.failed-card-checkout-modal')
    @include('blocks.analytics')
@endsection