@extends('layouts.master')

@section('title', 'BBoil RF - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')
    <script type="text/javascript">
        $(document).ready(function () {
            @if(Session::get('ShowCartBox'))
            $('#order-modal').modal('show');
            @if(config('app.locale') == 'bg')
            getDeliveryPrice($('select[data-action="get-delivery-price"]').val());
            @endif
            @endif

            @if(Session::has('transaction'))
            $('#modal-success').modal('show');
            @endif

            @if($errors->has('exception'))
            $('#modal-error').modal('show');
            @endif
        });
    </script>
    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url().'/'.App::getLocale()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-righ line-height-50t">
                    {!! Lang::get('lang.contacts') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg/bboil-rf'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en/bboil-rf'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru/bboil-rf'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de/bboil-rf'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr/bboil-rf'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl/bboil-rf'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu/bboil-rf'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr/bboil-rf'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk/bboil-rf'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>

    <div class="clearfix"></div>
    @include('blocks.top-product-navigation')
    <div class="clearfix"></div>

    <section
            class="layer-two col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding standart-padding-bottom standart-margin-bottom">
        <div class="layer-two-header" id="layer-two-header">
            <div class="col-lg-4 col-lg-offset-4 col-md-4 col-md-offset-4 col-sm-12 col-xs-12 clear-left-right-padding">
                <ul class="col-lg-12 col-md-12 clear-left-right-padding">
                    <li class="tab-left col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
                        <a id="layer-two-boil-btn" class="active">
                            <div class="tab-content">
                                <svg class="pull-left" style="margin-right: 30px;" xmlns="http://www.w3.org/2000/svg"
                                     xmlns:xlink="http://www.w3.org/1999/xlink"
                                     width="52px" height="48px" viewBox="0 0 32 28" version="1.1">
                                    <defs>
                                        <polygon id="path-1"
                                                 points="0 4.50476071 0 9 8.99048214 9 8.99048214 0.00952142857 0 0.00952142857"/>
                                    </defs>
                                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                        <g id="index" transform="translate(-266.000000, -116.000000)">
                                            <g id="products-2" transform="translate(-1.000000, 27.000000)">
                                                <g id="BBOIL-RF" transform="translate(259.000000, 88.000000)">
                                                    <g id="icon" transform="translate(9.000000, 1.000000)">
                                                        <g id="t-copy">
                                                            <path d="M30.5,4.57806404 L24.5000665,0.599917044 L18.5,4.57806721 L18.5,14.5 L30.5,14.5 L30.5,4.57806404 Z"
                                                                  id="Fill-9" stroke="#E2948E"/>
                                                            <path d="M25.5,11.5 L27.5,11.5 L27.5,9.5 L25.5,9.5 L25.5,11.5 Z"
                                                                  id="Fill-13" stroke="#E2948E"/>
                                                            <path d="M25.5,7.5 L27.5,7.5 L27.5,5.5 L25.5,5.5 L25.5,7.5 Z"
                                                                  id="Fill-13-Copy" stroke="#E2948E"/>
                                                            <path d="M21.5,7.5 L23.5,7.5 L23.5,5.5 L21.5,5.5 L21.5,7.5 Z"
                                                                  id="Fill-13-Copy-2" stroke="#E2948E"/>
                                                            <path d="M21.5,11.5 L23.5,11.5 L23.5,9.5 L21.5,9.5 L21.5,11.5 Z"
                                                                  id="Fill-13-Copy-3" stroke="#E2948E"/>
                                                            <g id="tt" transform="translate(0.000000, 1.000000)"
                                                               stroke="#E2948E" stroke-linecap="round"
                                                               stroke-linejoin="round">
                                                                <path d="M4.48803191,22.5 C6.96579953,22.5 8.97606383,20.484375 8.97606383,18 C8.97606383,16.6875 8.41505984,15.46875 7.48005319,14.625 L7.48005319,3 C7.48005319,1.359375 6.12429355,0 4.48803191,0 C2.85177028,0 1.49601064,1.359375 1.49601064,3 L1.49601064,14.625 C0.561003989,15.46875 0,16.6875 0,18 C0,20.484375 2.0102643,22.5 4.48803191,22.5 Z"
                                                                      id="Stroke-1"/>
                                                                <path d="M4.48803191,16.5 C5.3295379,16.5 5.98404255,17.15625 5.98404255,18 C5.98404255,18.84375 5.3295379,19.5 4.48803191,19.5 C3.64652593,19.5 2.99202128,18.84375 2.99202128,18 C2.99202128,17.15625 3.64652593,16.5 4.48803191,16.5 Z"
                                                                      id="Stroke-3" stroke-width="2"/>
                                                            </g>
                                                            <path d="M4.42819149,17.5159574 L4.42819149,9.64095745"
                                                                  id="Stroke-6" stroke="#E2948E" stroke-width="2"
                                                                  stroke-linecap="round" stroke-linejoin="round"/>
                                                            <path d="M4.5,25.5 L4.5,27.5" id="Line-5" stroke="#E2948E"
                                                                  stroke-linecap="square"/>
                                                            <path d="M4.5,27.5 L24.5,27.5" id="Line-6" stroke="#E2948E"
                                                                  stroke-linecap="square"/>
                                                            <g id="wave"
                                                               transform="translate(24.500000, 20.500000) rotate(-45.000000) translate(-24.500000, -20.500000) translate(20.000000, 16.000000)">
                                                                <path d="M0,3.51428214 C3.07733929,3.51428214 5.48571429,5.92281786 5.48571429,8.99999643"
                                                                      id="Stroke-1" stroke="#E2948E"/>
                                                                <g id="Group-5">
                                                                    <mask id="mask-2" fill="white">
                                                                        <use xlink:href="#path-1"/>
                                                                    </mask>
                                                                    <g id="Clip-4"/>
                                                                    <path d="M0,0.00952142857 C4.98726786,0.00952142857 8.99048214,4.01287857 8.99048214,9.00000357"
                                                                          id="Stroke-3" stroke="#E2948E"
                                                                          mask="url(#mask-2)"/>
                                                                </g>
                                                                <path d="M1.98094821,7.93333214 C1.98094821,8.43827857 1.57160893,8.84761786 1.0666625,8.84761786 C0.561716071,8.84761786 0.152376786,8.43827857 0.152376786,7.93333214 C0.152376786,7.42838571 0.561716071,7.01904643 1.0666625,7.01904643 C1.57160893,7.01904643 1.98094821,7.42838571 1.98094821,7.93333214 Z"
                                                                      id="Stroke-6" stroke="#E2948E"/>
                                                            </g>
                                                        </g>
                                                    </g>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <div class="tab-title standart-margin-left">
                                    <div class="color-light-blue unisans-regular-italic font-16">{{ Lang::get('lang.solution') }}</div>
                                    <div class="color-dark-blue font-30 unisans-heavy standart-margin-top">BBoil RF
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-two-content product col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="col-lg-7 col-md-7 col-sm-12 clear-left-right-padding">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="ps-gallery-box">
                        <div class="ps-gallery-box-image">
                            <img src="{{ asset('images/products/bboil-rf/bboil-rf-1.jpg') }}" width="320"/>
                        </div>
                        <div class="ps-gallery-box-thumbs">
                            <a class="ps-gallery-thumb-btn selected">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/bboil-rf-1.jpg') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/bboil-rf-2.jpg') }}"
                                     width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/'.((App::getLocale() == 'bg') ? 'bg' : 'en').'/bboil-rf-3.jpg') }}"
                                     width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/bboil-rf-4.jpg') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/bboil-rf-5.jpg') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/bboil-rf/bboil-rf-6.jpg') }}" width="60"/>
                            </a>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-5">
                    <h1 class="unisans-bold color-dark-blue">BBoil RF</h1>

                    <p>
                        <img class="standart-padding-top standart-padding-bottom"
                             src="{{ asset('images/layer-two-displays.png') }}"/></p>
                    <br/>

                    @if(App::getLocale() == 'en')
                        <h2 class="unisans-bold color-dark-blue font-20">Universal control over</h2>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Pellet and gas boilers
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Pellet and gas stoves
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Pellet, gas and oil burners
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Heat pumps
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            Electric heaters
                        </div>
                        <br/><br/>
                    @endif

                    <div class="col-lg-12 clear-padding">
                        <div style="display: flex;align-items: center;margin-bottom: 20px">
                            <svg style="width:20px;color:#e1948e;margin-right: 10px"
                                 class="svg-inline--fa fa-file-pdf fa-w-12 fa-5x fa-pull-left" aria-hidden="true"
                                 data-prefix="fas" data-icon="file-pdf" role="img" xmlns="http://www.w3.org/2000/svg"
                                 viewBox="0 0 384 512" data-fa-i2svg="">
                                <path fill="currentColor"
                                      d="M181.9 256.1c-5-16-4.9-46.9-2-46.9 8.4 0 7.6 36.9 2 46.9zm-1.7 47.2c-7.7 20.2-17.3 43.3-28.4 62.7 18.3-7 39-17.2 62.9-21.9-12.7-9.6-24.9-23.4-34.5-40.8zM86.1 428.1c0 .8 13.2-5.4 34.9-40.2-6.7 6.3-29.1 24.5-34.9 40.2zM248 160h136v328c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V24C0 10.7 10.7 0 24 0h200v136c0 13.2 10.8 24 24 24zm-8 171.8c-20-12.2-33.3-29-42.7-53.8 4.5-18.5 11.6-46.6 6.2-64.2-4.7-29.4-42.4-26.5-47.8-6.8-5 18.3-.4 44.1 8.1 77-11.6 27.6-28.7 64.6-40.8 85.8-.1 0-.1.1-.2.1-27.1 13.9-73.6 44.5-54.5 68 5.6 6.9 16 10 21.5 10 17.9 0 35.7-18 61.1-61.8 25.8-8.5 54.1-19.1 79-23.2 21.7 11.8 47.1 19.5 64 19.5 29.2 0 31.2-32 19.7-43.4-13.9-13.6-54.3-9.7-73.6-7.2zM377 105L279 7c-4.5-4.5-10.6-7-17-7h-6v128h128v-6.1c0-6.3-2.5-12.4-7-16.9zm-74.1 255.3c4.1-2.7-2.5-11.9-42.8-9 37.1 15.8 42.8 9 42.8 9z"></path>
                            </svg>
                            @if(App::getLocale() == 'bg')
                                <a class="color-dark-blue font-20" style="margin-top: 5px;"
                                   href="https://bboilrf.com/documents/User_manual_BBoil_BG.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @elseif(App::getLocale() == 'ru')
                                <a class="color-dark-blue font-20" style="margin-top: 5px;"
                                   href="https://bboilrf.com/documents/User_manual_BBoil_RU.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @else
                                <a class="color-dark-blue font-20" style="margin-top: 5px;"
                                   href="https://bboilrf.com/documents/User_manual_BBoil_EN.pdf"
                                   target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                            @endif
                        </div>
                    </div>

                    <div class="col-lg-12 clear-left-padding hidden">
                        @if(empty(Session::get('init_user.ip_api')) || (Session::get('init_user.ip_api') && (Session::get('init_user.ip_api.country_code') != 'GR' && Session::get('init_user.ip_api.country_code') != 'XK' && Session::get('init_user.ip_api.country_code') != 'MK' && Session::get('init_user.ip_api.country_code') != 'AL' && Session::get('init_user.ip_api.country_code') != 'NL' && Session::get('init_user.ip_api.country_code') != 'RU') ))
                            @if(App::getLocale() != 'hu')
                                <div class="col-lg-6 clear-left-padding">
                                    <div class="font-50 line-height-50 pull-left">
                                        @if(config('app.locale') == 'bg')
                                            139
                                        @else
                                            69
                                        @endif
                                    </div>
                                    <div class="font-18 pull-left">00</div>
                                    <div class="font-22 line-height-60 pull-left">{{Config::get('app.currency')}}</div>
                                </div>
                                <div class="clearfix"></div>
                                <br/>
                            @endif
                            <div class="{{(App::getLocale() == 'gr') ? 'col-lg-8 col-md-9 col-sm-8 col-xs-12' : 'col-lg-6 col-md-7 col-sm-5 col-xs-12'}} clear-left-right-padding">
                                @if(App::getLocale() == 'hu')
                                    <a style="display: block;text-align: center;"
                                       href="http://www.quantrax.hu/viszontelado-partnereink" target="_blank"
                                       class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </a>
                                @else
                                    {!! Form::open(array('route' => 'post-add-to-cart')) !!}
                                    {!! Form::hidden('Good', '2') !!}
                                    <button type="submit"
                                            class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </button>
                                    {!! Form::close() !!}
                                @endif
                            </div>
                        @endif
                    </div>
                    <div class="clearfix"></div>
                </div>

                @if(App::getLocale() == 'en')
                    <style>
                        .benefits .tab-btn {
                            background-color: #f6f6f6;
                            border: 3px solid #fff;
                            padding: 10px;
                            text-align: center;
                            font-size: 16px;
                            font-weight: bold;
                            cursor: pointer;
                        }

                        .benefits .tab-btn.active, .benefits .tab-btn:hover {
                            background-color: #374771;
                            color: #fff;
                        }

                        .benefits .tab-content {
                            display: none;
                        }

                        .benefits .tab-content.active {
                            display: block;
                            background-color: #fff;
                            border: 10px solid #f6f6f6;
                            padding: 10px;
                        }
                    </style>

                    <script>
                        $(document).ready(function () {
                            $('body').on('click', '.tab-btn', function () {
                                $('.tab-content').removeClass('active');
                                $('.tab-btn').removeClass('active');
                                var target = $(this).data('target');
                                $('.tab-content[data-id="' + target + '"]').addClass('active');
                                $(this).addClass('active');
                            });
                        });
                    </script>

                    <div class="clearfix"></div>
                    <h2 class="unisans-bold color-dark-blue font-20">Benefits</h2>
                    <div class="col-lg-12 benefits">
                        <div class="col-lg-3 tab-btn active" data-target="homeowners">Homeowners</div>
                        <div class="col-lg-3 tab-btn" data-target="installers">Installers</div>
                        <div class="col-lg-3 tab-btn" data-target="distributors">Distributors</div>
                        <div class="col-lg-3 tab-btn" data-target="manufacturers">Manufacturers</div>
                        <div class="col-lg-12 tab-content active" data-id="homeowners">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Save up to 30% from your energy bill<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Control your home’s climate from any part of the world<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Enjoy extra comfort<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Use your favorite mobile devices. The proSmart app works with all devices and operating
                                systems.<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Share access with unlimited number of people<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Get free access to all app features<br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="installers">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Optimize any type of heating and cooling system <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Fast and easy setup<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Suitable for new installations as well as replacement of old thermostats.
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Trouble-free maintenance
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                System monitoring<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Installation of up to 4 wireless sensors<br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="distributors">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Comfort, user-friendliness and remote temperature control via a single app<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Become part of the fastest growing IoT network.<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                One of the most reliable and affordable solutions on the market
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Your own admin panel, where you can manage each sold device
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Fast and easy deliveries from an EU manufacturer<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Proven growing strategy with a growing network of partners in more than 15
                                countries.<br/><br/>
                            </div>
                        </div>
                        <div class="col-lg-12 tab-content" data-id="manufacturers">
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Comfort, user-friendliness and remote temperature control via a single app<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Made of high-quality materials with an average life expectancy of 10 years<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Ready reliable and affordable solution
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Add great value to the end product at a very small cost
                                <br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Possibility for full rebranding<br/><br/>
                            </div>
                            <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                            <div class="font-16 line-height-20 text-justify">
                                Get an app exclusively for your brand<br/><br/>
                            </div>
                        </div>
                    </div>
                @endif

                @if(App::getLocale() != 'en')
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.AboutProduct') !!}</h2>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-20 text-justify">
                            {!! Lang::get('lang.bboil_rf_description.about_ln_1') !!}<br/><br/>
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-20 text-justify">
                            {!! Lang::get('lang.bboil_rf_description.about_ln_2') !!}<br/><br/>
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-20 text-justify">
                            {!! Lang::get('lang.bboil_rf_description.about_ln_3') !!}<br/><br/>
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-20 text-justify">
                            {!! Lang::get('lang.bboil_rf_description.about_ln_4') !!}<br/><br/>
                        </div>
                        <br/>
                        <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.WhyChoose') !!} {!! Lang::get('lang.proSmartBBoil') !!}
                            RF</h2>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            {!! Lang::get('lang.why_choose_rf.choose_ln_1') !!}
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            {!! Lang::get('lang.why_choose_rf.choose_ln_2') !!}
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            {!! Lang::get('lang.why_choose_rf.choose_ln_3') !!}
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            {!! Lang::get('lang.why_choose_rf.choose_ln_4') !!}
                        </div>
                        <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                        <div class="font-16 line-height-30 text-justify">
                            {!! Lang::get('lang.why_choose_rf.choose_ln_5') !!}
                        </div>
                    </div>
                @endif
            </div>

            <div class="col-lg-5 col-md-5">
                @if(App::getLocale() == 'en')
                    <h2 class="unisans-bold color-dark-blue font-20">You gain</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Optimization</strong><br/>
                        BBoil optimizes any heating/cooling system by ensuring higher comfort and lower energy bills.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Control</strong><br/>
                        Easy and reliable remote control from any part of the world.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Real time information</strong><br/>
                        Constant information of the temperature in your home and status of the system.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Custom modes</strong><br/>
                        Create weekly or monthly schedules and pre-set scenarios – Vacation, Work week, I'll be home
                        late, etc.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Boost mode</strong><br/>
                        Select the number of hours you want your heating or your hot water to work on maximum power.
                        Perfect for occasions that are not in your usual schedule.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">High level of security</strong><br/>
                        Storing the data and logins using a secure server
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Fast and easy installation</strong><br/>
                        BBoil can be installed to any heating/cooling system regardless of the manufacturer. It connects
                        with any Wi-Fi without the need of any additional settings.
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        <strong class="font-18">Built to last</strong><br/>
                        Hardware made of high-quality materials. Software up-to-date with the latest IoT trends.
                    </div>
                @else
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.UsageRF') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.ManagingOf') !!} {!! Lang::get('lang.manage_description_rf.manage_ln_1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.ManagingOf') !!} {!! Lang::get('lang.manage_description_rf.manage_ln_2') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.ManagingOf') !!} {!! Lang::get('lang.manage_description_rf.manage_ln_3') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.ManagingOf') !!} {!! Lang::get('lang.manage_description_rf.manage_ln_4') !!}
                    </div>
                    <br/>

                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.real_time_info') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.real_time_description_rf.real_time_msg1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.real_time_description_rf.real_time_msg2') !!}
                    </div>

                    @if(App::getLocale() == 'bg')
                        <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.FirstStep') !!}</h2>
                        <iframe width="100%" height="315"
                                src="{{(App::getLocale() == 'bg') ? 'https://www.youtube.com/embed/K6QOvRHIAMM' : ((App::getLocale() == 'ru') ? '' : '')}}?rel=0&amp;showinfo=0"
                                frameborder="0"
                                allowfullscreen></iframe>
                        <div class="clearfix"></div>
                        <br/><br/>
                    @endif

                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.you_get') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg1') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg2') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg3') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg4') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg5') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg6') !!}
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.you_get_description.you_get_msg7') !!}
                    </div>
                @endif
            </div>
        </div>
        <div class="clearfix"></div>
        <br/>
    </section>
    <div class="clearfix"></div>
    @if(App::getLocale() == 'en')
        <div class="col-lg-12">
            <div class="col-lg-6">
                <iframe width="100%" height="315" src="https://www.youtube.com/embed/CBucNEB0SvE" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
            <div class="col-lg-6">
                <iframe width="100%" height="315" src="https://www.youtube.com/embed/CgISWdbRkcA" frameborder="0"
                        allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen></iframe>
            </div>
        </div>
        <div class="clearfix"></div>
        <br/><br/>
    @endif
    <div class="clearfix"></div>
    <div class="col-lg-12 text-center">
        <a target="_blank" href="https://play.google.com/store/apps/details?id=com.ProSmart.ProSmart">
            <img class="standart-margin-right"
                 src="{{ asset('images/google_app.png') }}" width="145"/>
        </a>
        <a target="_blank" href="https://itunes.apple.com/us/app/prosmart/id1087882546">
            <img class="standart-margin-right"
                 src="{{ asset('images/apple_app.jpg') }}" width="120"/>
        </a>
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart AD</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    @include('partials.cart-modal')
    @include('partials.success-payment-modal')
    @include('partials.failed-card-checkout-modal')
    @include('blocks.analytics')
@endsection
