@extends('layouts.main')
@section('content')
<section class="section-padding-smaller">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="page-title text-center">
                    <img src="{{asset('images/about-logo.svg')}}" alt="Logo">
                    <div class="space-20"></div>
                    <h3 class="title">{!! Lang::get('lang.aboutProsmart') !!}</h3>
                    <div class="space-30"></div>
                    <h4 class="">{!! Lang::get('lang.about_Description') !!}</h4>
                    <div class="space-20"></div>
                    <p></p>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="key-success section-padding-top" id="features_page">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="page-title text-center">
                    <h3 class="title">{!! Lang::get('lang.key_success_factors') !!}</h3>
                    <div class="space-60"></div>
                </div>
            </div>
        </div>
        <div class="row" id="key-success-boxes">
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box">
                    <div class="box-icon">
                        <img src="{{asset('/images/icons/improvement.svg')}}" alt="">
                    </div>
                    <div class="box-text">
                        <h3>{!! Lang::get('lang.factor_1_title') !!}</h3>
                        <p>{!! Lang::get('lang.factor_1_description') !!}</p>
                    </div>
                </div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box">
                    <img src="{{asset('/images/icons/support.svg')}}" alt="">
                    <h3>{!! Lang::get('lang.factor_2_title') !!}</h3>
                    <p>{!! Lang::get('lang.factor_2_description') !!}</p>
                </div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box">
                    <img src="{{asset('/images/icons/customer.svg')}}" alt="">
                    <h3>{!! Lang::get('lang.factor_3_title') !!}</h3>
                    <p>{!! Lang::get('lang.factor_3_description') !!}</p>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="section-padding-top">
    <div class="container">
        <div class="row" id="mission">
            <div class="col-xs-12 col-sm-6 col-md-6">
                <div class="page-title text-left">
                    <h3 class="title">{!! Lang::get('lang.mission_and_vision') !!}</h3>
                    <div class="space-30"></div>
                    <h5>{!! Lang::get('lang.mission') !!}</h5>
                    <h4 class="">{!! Lang::get('lang.mission_description') !!}</h4>
                    <div class="space-30"></div>
                    <h5>{!! Lang::get('lang.vision') !!}</h5>
                    <h4 class="">{!! Lang::get('lang.vision_description') !!}</h4>
                </div>
            </div>
            <div class="col-xs-12 col-sm-6 col-md-6">
                <div class="text-center">
                    <img src="{{asset('/images/icons/mission.svg')}}" alt="">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12">
                <div class="page-title text-center">
                    <div class="space-60"></div>
                    <h3 class="title">{!! Lang::get('lang.market_positioning') !!}</h3>
                    <div class="space-30"></div>
                    <h4 class="">{!! Lang::get('lang.market_positioning_description') !!}</h4>
                </div>
            </div>
        </div>
    </div>
    <div class="row" id="facts">
          <div class="col-xs-12 col-sm-4 col-md-4">
              <div class="box">
                  <h3>{!! Lang::get('lang.market_position_fact_1_heading') !!}</h3>
                  <p>{!! Lang::get('lang.market_position_fact_1_description') !!}</p>
              </div>
          </div>
          <div class="col-xs-12 col-sm-4 col-md-4">
              <div class="box">
                  <h3>{!! Lang::get('lang.market_position_fact_2_heading') !!}</h3>
                  <p>{!! Lang::get('lang.market_position_fact_2_description') !!}</p>
              </div>
          </div>
          <div class="col-xs-12 col-sm-4 col-md-4">
              <div class="box">
                  <h3>{!! Lang::get('lang.market_position_fact_3_heading') !!}</h3>
                  <p>{!! Lang::get('lang.market_position_fact_3_description') !!}</p>
              </div>
          </div>
    </div>
    <div class="row-eq-height bluebg">
        <div class="col-xs-12 col-sm-6">
            <div class="page-title text-center full-width-box">
                <div class="space-40"></div>
                <h3 class="title">{!! Lang::get('lang.our_strategy') !!}</h3>
                <div class="space-20"></div>
                <h4>{!! Lang::get('lang.our_strategy_description') !!}</h4>
            </div>
        </div>
        <div class="col-xs-12 col-sm-6" id="strategy">
          &nbsp;
        </div>
    </div>
    <div class="container">
      <div class="row section-padding-normal">
          <div class="col-xs-12 col-sm-6">
              <div class="page-title text-center">
                  <div class="space-20"></div>
                  <h3 class="title">{!! Lang::get('lang.global_trends') !!}</h3>
                  <div class="space-20"></div>
                  <h4>{!! Lang::get('lang.global_trends_description') !!}</h4>
              </div>
          </div>
          <div class="col-xs-12 col-sm-6">
            <ul style="list-style-type:none">
              <li><i class="fas fa-chevron-right"></i>  &nbsp;&nbsp; {!! Lang::get('lang.global_trends_1') !!}</li>
              <li><i class="fas fa-chevron-right"></i>  &nbsp;&nbsp; {!! Lang::get('lang.global_trends_2') !!}</li>
              <li><i class="fas fa-chevron-right"></i>  &nbsp;&nbsp; {!! Lang::get('lang.global_trends_3') !!}</li>
            </ul>
          </div>
      </div>
    </div>
    <div class="darkbluebg">
        <div class="col-xs-12 col-sm-8">
            <div class="page-title text-center full-width-box">
                <div class="space-20"></div>
                <h2 class="">{!! Lang::get('lang.work_with_us') !!}</h3>
                <div class="space-20"></div>
            </div>
        </div>
        <div class="col-xs-12 col-sm-4">
          <div class="page-title text-center full-width-box">
            <div class="space-20"></div>
            <a class="bttn-cta" href="#contact_page">{!! Lang::get('lang.contact_cta') !!}</a>
            <div class="space-20"></div>
          </div>
        </div>
    </div>
</section>

@endsection
