(function(window,undefined){
  '$:nomunge';
  var $ = window.jQuery || window.Cowboy || ( window.Cowboy = {} ),

      jq_throttle;

  $.throttle = jq_throttle = function( delay, no_trailing, callback, debounce_mode ) {

    var timeout_id,

        last_exec = 0;

    if ( typeof no_trailing !== 'boolean' ) {
      debounce_mode = callback;
      callback = no_trailing;
      no_trailing = undefined;
    }

    function wrapper() {
      var that = this,
          elapsed = +new Date() - last_exec,
          args = arguments;

      function exec() {
        last_exec = +new Date();
        callback.apply( that, args );
      };

      function clear() {
        timeout_id = undefined;
      };

      if ( debounce_mode && !timeout_id ) {
        exec();
      }

      timeout_id && clearTimeout( timeout_id );

      if ( debounce_mode === undefined && elapsed > delay ) {
        exec();

      } else if ( no_trailing !== true ) {

        timeout_id = setTimeout( debounce_mode ? clear : exec, debounce_mode === undefined ? delay - elapsed : delay );
      }
    };

    if ( $.guid ) {
      wrapper.guid = callback.guid = callback.guid || $.guid++;
    }

    return wrapper;
  };

  $.debounce = function( delay, at_begin, callback ) {
    return callback === undefined
      ? jq_throttle( delay, at_begin, false )
    : jq_throttle( delay, callback, at_begin !== false );
  };

})(this);
(function ($) {

    "use strict";
    $(".carousel-inner .item:first-child").addClass("active");
    /* Mobile menu click then remove
    ==========================*/
    // $(".mainmenu-area #primary_menu li a").on("click", function () {
    //     $(".navbar-collapse").removeClass("in");
    // });
    /* Scroll to top
    ===================*/
    $.scrollUp({
        scrollText: '<i class="lnr lnr-arrow-up"></i>',
        easingType: 'linear',
        scrollSpeed: 900,
        animation: 'fade'
    });

    /* testimonials Slider Active
    =============================*/
    $('.gallery-slide').owlCarousel({
        loop: true,
        margin: 0,
        responsiveClass: true,
        nav: false,
        autoplay: true,
        autoplayTimeout: 2000,
        smartSpeed: 1000,
        navText: ['<i class="lnr lnr-chevron-left"></i>', '<i class="lnr lnr-chevron-right"></i>'],
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 2
            },
            1280: {
                items: 3
            },
            1500: {
                items: 4
            }
        }
    });
    /* testimonials Slider Active
    =============================*/
    $('.team-slide').owlCarousel({
        loop: true,
        margin: 0,
        responsiveClass: true,
        nav: true,
        autoplay: true,
        autoplayTimeout: 4000,
        smartSpeed: 1000,
        navText: ['<i class="lnr lnr-chevron-left"></i>', '<i class="lnr lnr-chevron-right"></i>'],
        responsive: {
            0: {
                items: 1,
            },
            600: {
                items: 2
            },
            1000: {
                items: 3
            }
        }
    });
    $(".toggole-boxs").accordion();
    /*---------------------------
    MICHIMP INTEGRATION
    -----------------------------*/
    // $('#mc-form').ajaxChimp({
    //     url: 'https://quomodosoft.us14.list-manage.com/subscribe/post?u=b2a3f199e321346f8785d48fb&amp;id=d0323b0697', //Set Your Mailchamp URL
    //     callback: function (resp) {
    //         if (resp.result === 'success') {
    //             $('.subscrie-form, .join-button').fadeOut();
    //             $('body').css('overflow-y', 'scroll');
    //         }
    //     }
    // });

    /*-- Smoth-Scroll --*/
    $('a[href*="#"]')
        // Remove links that don't actually link to anything
        .not('[href="#"]')
        .not('[href="#0"]')
        .click(function (event) {
            // On-page links
            if (
                location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') &&
                location.hostname == this.hostname
            ) {
                // Figure out element to scroll to
                var target = $(this.hash);
                target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                // Does a scroll target exist?
                if (target.length) {
                    // Only prevent default if animation is actually gonna happen
                    event.preventDefault();
                    $('html, body').animate({
                        scrollTop: target.offset().top
                    }, 1000, function () {
                        // Callback after animation
                        // Must change focus!
                        var $target = $(target);
                        $target.focus();
                        if ($target.is(":focus")) { // Checking if the target was focused
                            return false;
                        } else {
                            $target.attr('tabindex', '-1'); // Adding tabindex for elements not focusable
                            $target.focus(); // Set focus again
                        };
                    });
                }
            }
        });
    /*--------------------
       MAGNIFIC POPUP JS
       ----------------------*/
    var magnifPopup = function () {
        $('.popup').magnificPopup({
            type: 'iframe',
            removalDelay: 300,
            mainClass: 'mfp-with-zoom',
            gallery: {
                enabled: true
            },
            zoom: {
                enabled: true, // By default it's false, so don't forget to enable it

                duration: 300, // duration of the effect, in milliseconds
                easing: 'ease-in-out', // CSS transition easing function

                // The "opener" function should return the element from which popup will be zoomed in
                // and to which popup will be scaled down
                // By defailt it looks for an image tag:
                opener: function (openerElement) {
                    // openerElement is the element on which popup was initialized, in this case its <a> tag
                    // you don't need to add "opener" option if this code matches your needs, it's defailt one.
                    return openerElement.is('img') ? openerElement : openerElement.find('img');
                }
            }
        });
    };
    // Call the functions
    magnifPopup();
    /* Preloader Js
    ===================*/
    $(window).on("load", function () {
        $('.preloader').fadeOut(500);
        /*WoW js Active
        =================*/
        new WOW().init({
            mobile: false,
        });
    });
    $(document).ready(function() {
      $('.product-wrapper .product-list a').on('click', function () {
          $('.product-wrapper .product-list a').removeClass('active');
          $(this).addClass('active');
          var data_target = $(this).data('target');
          $('.product-wrapper .product-description').hide();
          $('#' + data_target).fadeIn();
          var locale = $('#locale').val();
          var url = '/' + locale + '/' + data_target;
          $('#' + data_target).parent().attr('href', url);

          if ($(window).width() <= 769) {
              $('html, body').animate({
                  scrollTop: $('#product-list').offset().top-80
                }, 800, function(){
            });
          }

          $('.fill-red').attr('fill', '#D3D9E4');
          $('.stroke-red').attr('stroke', '#9197A2');

          $('.fill-red-2').attr('fill', '#9298A3');
          $('.stroke-red-2').attr('stroke', '#E2E8F5');

          $('#ps-plug-intro-pop').hide();
          $('.product-wrapper-house-sensor').hide();

          if (data_target == 'bboil-rf' || data_target == 'bboil') {
              $('#product-wrapper-house .bboil.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .bboil.fill-red-2').attr('fill', '#D07973');
              $('#product-wrapper-house .bboil.stroke-red').attr('stroke', '#d89190');
              if (data_target == 'bboil-rf')
                  $('.product-wrapper-house-sensor.white').fadeIn();
          } else if (data_target == 'bgate') {
              $('#product-wrapper-house .bgate.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .bgate.stroke-red').attr('stroke', '#d89190');
          } else if (data_target == 'bsafe-f') {
              $('#product-wrapper-house .pf-safe.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .pf-safe.stroke-red').attr('stroke', '#d89190');
          } else if (data_target == 'bsafe-w') {
              $('#product-wrapper-house .pw-safe.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .pw-safe.stroke-red').attr('stroke', '#d89190');
              $('.product-wrapper-house-sensor.black').fadeIn();
          } else if (data_target == 'bsafe-a') {
              $('#product-wrapper-house .pa-safe.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .pa-safe.stroke-red').attr('stroke', '#d89190');
              $('#product-wrapper-house .pa-safe.stroke-red-2').attr('stroke', '#d89190');
              $('.product-wrapper-house-sensor.gray').fadeIn();
          } else if (data_target == 'ps-plug') {
              $('#product-wrapper-house .ps-plug.fill-red').attr('fill', '#e8aeac');
              $('#product-wrapper-house .ps-plug.stroke-red').attr('stroke', '#d89190');
              $('#product-wrapper-house .ps-plug.stroke-red-2').attr('stroke', '#d89190');
              $('#ps-plug-intro-pop').fadeIn();
          }
      });
      $('#product-wrapper-house .bboil.fill-red').attr('fill', '#e8aeac');
      $('#product-wrapper-house .bboil.fill-red-2').attr('fill', '#D07973');
      $('#product-wrapper-house .bboil.stroke-red').attr('stroke', '#d89190');
      $('.product-wrapper-house-sensor.white').fadeIn();

        $(window).scroll(function() {
            var scroll = $(window).scrollTop();
            if (scroll >= 50) {
              $('#product_body .mainmenu').hide();
              $('#product_body  #product_menu').show();
              $('#product_body .navbar-brand').css('margin-top','3px');
              $('#product_body .right-button').css('margin-top','10px');
            } else {
              $('#product_body  .mainmenu').show();
              $('#product_body  #product_menu').hide();
              $('#product_body .navbar-brand').css('margin-top','0');
              $('#product_body .right-button').css('margin-top','0');
            }
        });


      $('#sendTicket').click(function () {

          $.ajax({
              method: 'POST',
              url: '/' + $('#locale').val() + "/sendTicket",
              data: $('#ticketForm').serialize() + '&_token=' + $('#_token').val(),
              dataType: 'json',
              beforeSend: function () {
                  $('.fader').removeClass('hidden');
              }
          })
              .done(function (data) {
                  $('.fader').addClass('hidden');
                  $('.removeError').empty();
                  if (!data.success) {
                      $.each(data.errors, function (index, value) {
                          $('.' + index + "Error").text(value[0]);
                      });
                  } else {
                      $('#modal-ticket').modal('hide');
                  }
              });
      });

      $('#sendRequest').click(function () {

          $.ajax({
              method: 'POST',
              url: '/' + $('#locale').val() + "/sendRequest",
              data: $('#requestForm').serialize() + '&_token=' + $('#_token').val(),
              dataType: 'json',
              beforeSend: function () {
                  $('.fader').removeClass('hidden');
              }
          })
              .done(function (data) {
                  $('.fader').addClass('hidden');
                  $('.removeError').empty();
                  if (!data.success) {
                      $.each(data.errors, function (index, value) {
                          $('.' + index + "Error").text(value[0]);
                      });
                  } else {
                      $('#modal-request').modal('hide');
                  }
              });
      });

      $('#sendMessage').click(function () {

          $.ajax({
              method: 'POST',
              url: '/' + $('#locale').val() + "/sendMessage",
              data: $('#footerContact').serialize() + '&_token=' + $('#_token').val(),
              dataType: 'json',
              beforeSend: function () {
                  // $('.fader').removeClass('hidden');
              }
          })
              .done(function (data) {
                  $('.removeError').empty();
                  if (!data.success) {
                      $.each(data.errors, function (index, value) {
                          $('.' + index + "Error").text(value[0]);
                      });
                  } else {
                      // $('#modal-request').modal('hide');
                      location.reload();
                  }
              });
      });
    });
})(jQuery);
