<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function getLanguageID(){
        $langID = -1;
        switch (App::getLocale()){
            case 'bg': $langID = 1; break;
            case 'en': $langID = 2; break;
            case 'de': $langID = 3; break;
            case 'fr': $langID = 4; break;
            case 'hu': $langID = 5; break;
            case 'ru': $langID = 6; break;

        }

        if($langID == -1){
            return 2;
        }
        else{
            return $langID;
        }
    }
}
