<?php
class ControllerCommonLanguage extends Controller {
    
    public function index() {
        $this->load->language('common/language');
        $data['action'] = $this->url->link('common/language/language', '', $this->request->server['HTTPS']);
        $data['code'] = $this->session->data['language'];
        $this->load->model('localisation/language');
        $data['languages'] = array();
        $results = $this->model_localisation_language->getLanguages();
        foreach ($results as $result) {
            if ($result['status']) {
                $data['languages'][] = array(
                    'name' => $result['name'],
                    'code' => $result['code']
                );
            }
        }
        $this->session->data['save_get'] = $this->request->get;
        return $this->load->view('common/language', $data);
    }
    
    public function language() {
        $this->load->model('localisation/language');
        $languages = $this->model_localisation_language->getLanguages();
        $url = '';
        if (isset($this->request->post['code']) && array_key_exists($this->request->post['code'], $languages) && $languages[$this->request->post['code']]['status']) {
            $this->session->data['language'] = $this->request->post['code'];
            if (isset($this->session->data['save_get'])) {
                $xlang_id = $languages[$this->request->post['code']]['language_id'];
                $curr_lang = $this->config->get('config_language_id');
                $this->config->set('config_language_id', $xlang_id);
                if (!isset($this->session->data['save_get']['route'])) {
                    $url_data = $this->session->data['save_get'];
                    unset($url_data['_route_']);
                    if ($url_data) $url = '&' . urldecode(http_build_query($url_data, '', '&'));
                    $redirect = $this->url->link('common/home', $url, $this->request->server['HTTPS']);
                } else {
                    $url_data = $this->session->data['save_get'];
                    unset($url_data['_route_']);
                    $route = $url_data['route'];
                    unset($url_data['route']);
                    if ($url_data) $url = '&' . urldecode(http_build_query($url_data, '', '&'));
                    $redirect = $this->url->link($route, $url, $this->request->server['HTTPS']);
                }
                $this->config->set('config_language_id', $curr_lang);
                unset($this->session->data['save_get']);
                $this->response->redirect($redirect);
            } else {
                $this->response->redirect($this->url->link('common/home', $url, $this->request->server['HTTPS']));
            }
        } else {
            $this->response->redirect($this->url->link('common/home', $url, $this->request->server['HTTPS']));
        }
    }
}