<?php
if (! class_exists ( 'WC_Braintree_Payment_Gateway' )) {
	return;
}
/**
 *
 * @author Payment Plugins
 *        
 */
class WC_PayPal_Credit_Payment_Gateway extends WC_Braintree_Payment_Gateway {
	const ID = 'braintree_paypal_credit_payments';
	
	/**
	 * Nonce id contained in the $_POST.
	 *
	 * @var string
	 */
	public static $nonce_id = 'braintree_paypal_credit_payments_nonce';
	
	/**
	 * Device data field key located in $_POST.
	 *
	 * @var string
	 */
	public static $device_data_id = 'braintree_paypal_credit_device_data';

	public function __construct() {
		// $this->enabled = $this->settings ['enabled'] = is_admin () ? (bwc_paypal_credit_enabled () ? 'yes' : 'no') : (bwc_paypal_credit_active () && ! bwc_smart_buttons_enabled () ? 'yes' : 'no');
		$this->enabled = $this->settings[ 'enabled' ] = bwc_paypal_credit_enabled () ? 'yes' : 'no';
		$this->id = static::ID;
		$this->title = bt_manager ()->get_option ( 'paypal_credit_title' );
		$this->method_title = __ ( 'PayPal Credit Payment Gateway', 'braintree-payments' );
		$this->has_fields = true;
		$this->actions ();
		$this->set_supports ();
		$this->init_settings ();
		$this->icon = 'https://www.paypalobjects.com/webstatic/en_US/i/buttons/PP_credit_logo_h_100x26.png';
	}

	public static function init() {
		add_filter ( 'bwc_add_payment_gateways', __CLASS__ . '::add_braintree_gateway' );
		
		add_filter ( 'woocommerce_payment_gateways', __CLASS__ . '::add_gateway' );
		
		add_filter ( 'woocommerce_payment_complete_order_status', __CLASS__ . '::maybe_update_order_status', 99, 3 );
		
		/**
		 *
		 * @since 2.6.26
		 */
		add_action ( 'wp_loaded', __CLASS__ . '::make_default_method' );
		
		add_filter ( 'woocommerce_available_payment_gateways', __CLASS__ . '::available_gateway' );
	}

	public static function add_braintree_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}

	public static function add_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}

	public function payment_fields() {
		bwc_get_template ( 'checkout/paypal-credit-checkout.php', array( 
				'gateway' => $this 
		) );
	}

	/**
	 * Add a payment method nonce order attributes array.
	 *
	 * @param array $attribs        	
	 */
	public static function add_order_payment_method(&$attribs) {
		$attribs[ 'paymentMethodNonce' ] = self::get_request_param ( static::$nonce_id );
		
		return $attribs;
	}

	/**
	 * Always add device data for PayPal Credit.
	 * With PayPal, deviceData is expected regardless of the merchant's control panel settings.
	 *
	 * @param array $attribs        	
	 */
	public static function add_device_data(&$attribs) {
		$attribs[ 'deviceData' ] = stripslashes ( self::get_request_param ( static::$device_data_id ) );
		
		return $attribs;
	}

	public function set_supports() {
		parent::set_supports ();
		if (($key = array_search ( 'bfwc_credit_card_form', $this->supports )) !== false) {
			unset ( $this->supports[ $key ] );
		}
	}

	public function get_key_mappings() {
		return array( 
				'enabled' => 'paypal_credit' 
		);
	}

	public static function available_gateway($gateways) {
		if (isset ( $gateways[ static::ID ] )) {
			if (is_admin ()) {
				return $gateways;
			}
			$active = bwc_paypal_credit_active ();
			if (! $active || ($active && bwc_smart_buttons_enabled ())) {
				unset ( $gateways[ static::ID ] );
			}
		}
		return $gateways;
	}
}
WC_PayPal_Credit_Payment_Gateway::init ();