<?php
if (! class_exists ( 'WC_Braintree_Payment_Gateway' )) {
	return;
}
class WC_Braintree_Venmo_Payment_Gateway extends WC_Braintree_Payment_Gateway {

	const ID = 'braintree_venmo';

	/**
	 * Nonce id contained in the $_POST.
	 *
	 * @var string
	 */
	public static $nonce_id = 'braintree_venmo_payments_nonce';

	public static $token_id = 'braintree_venmo_payment_method_token';

	/**
	 * Device data field key located in $_POST.
	 *
	 * @var string
	 */
	public static $device_data_id = 'braintree_venmo_device_data';
	
	public function __construct() {
		$this->enabled = $this->settings[ 'enabled' ] = bt_manager()->get_option('venmo_enabled');
		$this->title = bt_manager ()->get_option ( 'venmo_gateway_title' );
		$this->id = static::ID;
		$this->method_title = __ ( 'Venmo Payment Gateway', 'braintree-payments' );
		$this->has_fields = true;
		$this->actions ();
		$this->set_supports ();
		$this->init_settings ();
		$this->icon = bt_manager ()->plugin_assets_path () . 'img/payment-methods/venmo.svg';
	}
	
	public static function init() {
		add_filter ( 'bwc_add_payment_gateways', __CLASS__ . '::add_braintree_gateway' );
	
		add_filter ( 'woocommerce_payment_gateways', __CLASS__ . '::add_gateway' );
	
		add_filter ( 'woocommerce_payment_complete_order_status', __CLASS__ . '::maybe_update_order_status', 99, 3 );
	
		add_filter ( 'woocommerce_saved_payment_methods_list', __CLASS__ . '::saved_payment_method_list', 10, 2 );
	
		add_action ( 'bfwc_before_process_order_' . static::ID, __CLASS__ . '::maybe_save_payment_method' );
	
		add_action ( 'wp_loaded', __CLASS__ . '::maybe_delete_payment_method' );
	}
	

	public static function add_braintree_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}
	
	public static function add_gateway($gateways) {
		$gateways[] = __CLASS__;
		return $gateways;
	}
	
	public function payment_fields() {
		if (bwc_is_checkout () || bwcs_is_change_payment_method () || bfwcs_is_change_payment_method () || bfwcs_is_pay_for_subscription_request ()) {
			bwc_get_template ( 'checkout/venmo.php', array(
					'has_methods' => false,
					'gateway' => $this
			) );
		} else {
			bwc_get_template ( 'venmo.php', array(
					'has_methods' => false,
					'gateway' => $this
			) );
		}
	}
	
	public function get_key_mappings() {
		return array(
				'enabled' => 'venmo_enabled'
		);
	}
	
	public static function saved_payment_method_list($saved_methods, $user_id) {
		if (bt_manager()->is_active('venmo_enabled')) {
			$methods = bwc_get_user_venmo_payment_methods($user_id);
			$saved_methods = bwc_saved_payment_methods_list ( $saved_methods, $methods, static::ID );
		}
		return $saved_methods;
	}
}
WC_Braintree_Venmo_Payment_Gateway::init();