<?php

class Braintree_PayPal_Marketing
{

    public static function init ()
    {
        add_action('wp_footer', __CLASS__ . '::add_tag_to_content');
    }

    public static function add_tag_to_content ()
    {
        if (! bt_manager()->is_active('enable_paypal_marketing')) {
            return;
        }
        // get the current post.
        $post = get_post();
        $pages = bt_manager()->get_option('paypal_marketing_pages');
        $display = false;
        if (in_array($post->ID, $pages)) {
            $display = true;
        } else {
            if (in_array('product', $pages) && is_singular('product')) {
                $display = true;
            } elseif (in_array('products', $pages) && (is_post_type_archive(
                    'product') || is_page(wc_get_page_id('shop')))) {
                $display = true;
            }
        }
        if (apply_filters('bfwc_display_paypal_marketing_tag', $display)) {
            bwc_get_template('paypal-marketing.php', 
                    array(
                            'container_id' => bt_manager()->get_option(
                                    'paypal_marketing_container_id')
                    ));
        }
    }
}
Braintree_PayPal_Marketing::init();