<?php
class Braintree_Cart_Payments_Controller {

	public static function init() {
		include_once ( bt_manager ()->plugin_include_path () . 'api/class-paypal-cart-controller.php' );
		include_once ( bt_manager ()->plugin_include_path () . 'api/class-applepay-controller.php' );
		add_action ( 'rest_api_init', function () {
			$instance = new self ();
			register_rest_route ( 'woo-payment-gateway/v1', '/cart-checkout/(?P<payment_method>[\w_]+)', array( 
					'methods' => WP_REST_Server::CREATABLE, 
					'callback' => array( $instance, 
							'process_payment' 
					) 
			) );
			register_rest_route ( 'woo-payment-gateway/v1/product/', 'add-to-cart', array( 
					'methods' => WP_REST_Server::CREATABLE, 
					'callback' => array( $instance, 
							'add_to_cart' 
					) 
			) );
		} );
	}

	/**
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function process_payment($request) {
		wc_maybe_define_constant ( 'DOING_AJAX', true );
		$response = new WP_REST_Response ();
		$checkout = WC ()->checkout ();
		$payment_method = $request->get_param ( 'payment_method' );
		$_POST[ 'payment_method' ] = $_REQUEST[ 'payment_method' ] = $payment_method;
		if (WC ()->cart->needs_shipping ()) {
			$_POST[ 'ship_to_different_address' ] = true;
		}
		try {
			do_action ( 'bfwc_process_cart_checkout_' . $payment_method, $request );
			if (! is_user_logged_in ()) {
				// if user is not logged in make sure there is a $_SERVER nonce.
				if (empty ( $_SERVER[ 'HTTP_X_WP_NONCE' ] ) || ! wp_verify_nonce ( $_SERVER[ 'HTTP_X_WP_NONCE' ], 'wp_rest' )) {
					throw new Exception ( __ ( 'Forbidden', 'braintree-payments' ), 401 );
				}
				$this->create_customer ( $request );
			}
			// set the checkout nonce so no exceptions are thrown.
			$_REQUEST[ '_wpnonce' ] = $_POST[ '_wpnonce' ] = wp_create_nonce ( 'woocommerce-process_checkout' );
			$checkout->process_checkout ();
		} catch ( Exception $e ) {
			wc_add_notice ( $e->getMessage (), 'error' );
		}
		if (wc_notice_count ( 'error' ) > 0) {
			return $this->send_response ( $response, false );
		}
		return $this->send_response ( $response, true );
	}

	/**
	 *
	 * @param WP_REST_Request $request        	
	 */
	private function create_customer($request) {
		$create = WC ()->checkout ()->is_registration_required ();
		// create an account for the user if it's required for things like subscriptions.
		if (bfwcs_cart_contains_subscriptions ()) {
			$create = true;
		}
		if (class_exists ( 'WC_Subscriptions_Cart' ) && WC_Subscriptions_Cart::cart_contains_subscription ()) {
			$create = true;
		}
		if ($create) {
			$password = wp_generate_password ();
			$username = $email = $request->get_param ( 'billing_email' );
			$result = wc_create_new_customer ( $email, $username, $password );
			if ($result instanceof WP_Error) {
				// for email exists errors you want customer to either login or use a different email address.
				if ($result->get_error_code () === 'registration-error-email-exists') {
					bwc_set_checkout_error ();
				}
				throw new Exception ( $result->get_error_message () );
			}
			$this->customer_id = $result;
			
			// log the customer in
			wp_set_current_user ( $this->customer_id );
			wc_set_customer_auth_cookie ( $this->customer_id );
			
			// As we are now logged in, cart will need to refresh to receive updated nonces
			WC ()->session->set ( 'reload_checkout', true );
		}
	}

	private function send_response($response, $success) {
		$reload = WC ()->session->get ( 'reload_checkout', false );
		$data = array( 
				'result' => $success ? 'success' : 'failure', 
				'messages' => $reload ? null : $this->get_error_messages (), 
				'reload' => $reload 
		);
		unset ( WC ()->session->reload_checkout );
		$response->set_data ( $data );
		return $response;
	}

	private function get_error_messages() {
		$notices = wc_get_notices ();
		unset ( $notices[ 'notice' ], $notices[ 'success' ] );
		wc_set_notices ( $notices );
		ob_start ();
		$messages = wc_print_notices ();
		return ob_get_clean ();
	}

	/**
	 * Method that is called when a product is added to the cart using a gateway that supports product checkout.
	 * The purpose of this method
	 * is to add the selected product to the cart and perform cart calculations.
	 *
	 * @param WP_REST_Request $request        	
	 */
	public function add_to_cart($request) {
		$response = new WP_REST_Response ();
		// always empty the cart to start since the Product Page Apple Pay options is only for single items.
		WC ()->cart->empty_cart ();
		$product_id = $request->get_param ( 'product_id' );
		$qty = $request->get_param ( 'qty' );
		$variation_id = $request->get_param ( 'variation_id' ) == null ? 0 : $request->get_param ( 'variation_id' );
		if (WC ()->cart->add_to_cart ( $product_id, $qty, $variation_id ) == false) {
			$response->set_data ( array( 
					'success' => false, 
					'messages' => $this->get_error_messages () 
			) );
		} else {
			// send a refreshed nonce since the uid used to generate nonces will contain the WC session id if the user is not logged in.
			rest_get_server()->send_header('X-WP-Nonce', wp_create_nonce('wp_rest'));
			$response->set_data ( array( 
					'success' => true 
			) );
		}
		return $response;
	}
}
Braintree_Cart_Payments_Controller::init ();