<?php
/**
 * Base class that initializes all API controllers.
 * @author Payment Plugins
 *
 */
class Braintree_Gateway_API {

	public static function init() {
		add_action ( 'rest_api_init', array( __CLASS__, 
				'register_controllers' 
		) );
		add_filter ( 'woocommerce_is_rest_api_request', array( 
				__CLASS__, 'is_rest_api_request' 
		) );
	}

	/**
	 * Register all of the api controllers with Wordpress.
	 */
	public static function register_controllers() {
		$controllers = apply_filters ( 'bfwc_register_route_controllers', array() );
		
		foreach ( $controllers as $class ) {
			$controller = new $class ();
			foreach ( $controller->get_notification_kinds () as $key => $function ) {
				add_action ( "bfwc_webhook_{$key}_notification", $function );
			}
		}
	}

	/**
	 * Added after WC 3.6 so Cart, Customer, and Session are loaded for Braintree rest requests.
	 *
	 * @param unknown $bool        	
	 */
	public static function is_rest_api_request($bool) {
		if (! empty ( $_SERVER[ 'REQUEST_URI' ] ) && strpos ( $_SERVER[ 'REQUEST_URI' ], 'woo-payment-gateway' )) {
			$bool = false;
		}
		return $bool;
	}
}
Braintree_Gateway_API::init ();