<?php
class Braintree_Gateway_Kount_Settings extends Braintree_Gateway_Settings_API
{

	public function __construct()
	{
		$this->tab = 'checkout-settings';
		$this->page = 'braintree-gateway-settings';
		$this->id = 'checkout_settings';
		$this->title = array (
				'title' => __( 'Kount Settings', 'braintree-payments' ), 
				'description' => __( 'These options allow you to customize how you handle responses from Kount.', 'braintree-payments' ) 
		);
		add_filter( 'braintree_gateway_default_settings', array (
				$this, 
				'get_default_settings' 
		) );
		add_action( "braintree_gateway_{$this->tab}_save_settings", array (
				$this, 
				'save' 
		) );
		
		add_action( 'bfwc_settings_modal_description', array (
				$this, 
				'output_ens_api_url' 
		) );
		
		add_filter( 'braintree_settings_localized_variables', array (
				$this, 
				'localized_vars' 
		) );
	}

	public function settings()
	{
		return array (
				'kount_enabled' => array (
						'type' => 'checkbox', 
						'title' => __( 'Kount Logic Enabled', 'braintree-payments' ), 
						'default' => '', 
						'value' => 'yes', 
						'tool_tip' => true, 
						'description' => __( 'If enabled, certain actions related to the order status will be taken. For example, an order that has a Kount status of review will be placed under a 
								review status. This will prevent actions such as order fulfillment from taking place.', 'braintree-payments' ) 
				), 
				'kount_review_action' => array (
						'type' => 'select', 
						'title' => __( 'Review Status', 'braintree-payments' ), 
						'options' => array (
								'review' => __( 'Assign review status to order', 'braintree-payments' ), 
								'cancel' => __( 'Cancel order', 'braintree-payments' ), 
								'payment_complete' => __( 'Complete order', 'braintree-payments' ) 
						), 
						'default' => 'review', 
						'tool_tip' => true, 
						'description' => __( 'The option selected here will determine how the WC order is handled when the Kount status for the transaction is Review.', 'braintree-payments' ) 
				), 
				'kount_send_processing_email' => array (
						'type' => 'checkbox', 
						'title' => __( 'Send Processing Email', 'braintree-payments' ), 
						'default' => 'yes', 
						'value' => 'yes', 
						'attributes' => array (
								'data-parent-setting' => "{$this->get_field_key_name('kount_review_action')}", 
								'data-show-if' => 'review' 
						), 
						'tool_tip' => true, 
						'description' => __( 'If enabled the order processing email will be sent to the customer when the Kount Review status is assigned to the order.', 'braintree-payments' ) 
				), 
				'kount_decline_action' => array (
						'type' => 'select', 
						'title' => __( 'Declined In Kount', 'braintree-payments' ), 
						'options' => array (
								'do_nothing' => __( 'Do Nothing', 'braintree-payments' ), 
								'cancel_transaction' => __( 'Void / Refund Transaction', 'braintree-payments' ) 
						), 
						'default' => 'cancel_transaction', 
						'tool_tip' => true, 
						'description' => __( 'Some merchants may wish to void or refund a transaction in WooCommerce if the order is declined in Kount. Selecting do nothing means no void or refund action will be taken.', 'braintree-payments' ) 
				) 
		);
	}

	public function output_settings( $key, $data )
	{
		$field_key = $this->get_field_key_name( $key );
		$data = wp_parse_args( $data, $this->get_default_custom_html_args() );
		include bt_manager()->plugin_admin_path() . 'html-helpers/settings-modal.php';
	}

	public function output_ens_api_url( $settings )
	{
		if ( $settings === $this ) {
			
			$key = get_option( 'bfwc_kount_key', false );
			
			if ( ! $key ) {
				$key = $this->generate_key();
				update_option( 'bfwc_kount_key', $key );
			}
			
			echo '<div class="kountKeyContainer">';
			echo '<p><a href="https://support.paymentplugins.com/hc/en-us/articles/115003004013-Configure-Kount-Custom" target="_blank">' . __( 'Configuration guide', 'braintree-payments' ) . '</a></p>';
			echo '<label><strong>' . __( 'Ens Api Url:', 'braintree-payments' ) . '</strong></label>&nbsp<input type="text" value="' . get_rest_url( null, 'braintree-gateway/v1/kount/' . $key ) . '"/>';
			echo '<a class="waves-effect waves-light btn createKey">' . __( 'generate api key', 'braintree-payments' ) . '</a>';
			echo '</div>';
		}
	}

	public function localized_vars( $vars )
	{
		$vars [ 'kount' ] = array (
				'routes' => array (
						'key' => add_query_arg( '_wpnonce', wp_create_nonce( 'wp_rest' ), get_rest_url( null, 'bfwc/settings/kount/api_key/' ) ) 
				) 
		);
		return $vars;
	}

	public function generate_key()
	{
		return 'api_' . wc_rand_hash();
	}
}