<?php
use Braintree\PaymentInstrumentType;

class Braintree_Gateway_GooglePay_Settings extends Braintree_Gateway_Settings_API
{

    public function __construct ()
    {
        $this->tab = 'checkout-settings';
        $this->page = 'braintree-gateway-settings';
        $this->id = 'checkout_settings';
        $this->title = array(
                'title' => __('Google Pay Settings', 'braintree-payments'),
                'description' => __(
                        'These options allow you to customize the Google Pay Gateway.
						<p>You must register for a <a target="_blank" href="https://services.google.com/fb/forms/googlepayAPIenable/">Google Pay Account</a> in order to accept payments.</p>
                		<p>To have the Google API team approve your integration you can enable sandbox mode and Google Pay. When sandbox mode is enabled, Google Pay will work, allowing you to capture the necessary screenshots the Google API team needs to approve your Merchant ID request.</p>', 
                        'braintree-payments')
        );
        add_filter('braintree_gateway_default_settings', 
                array(
                        $this,
                        'get_default_settings'
                ));
        add_action("braintree_gateway_{$this->tab}_save_settings", 
                array(
                        $this,
                        'save'
                ));
    }

    public function settings ()
    {
        return array(
                'googlepay_enabled' => array(
                        'type' => 'checkbox',
                        'title' => __('Enable Google Pay', 'braintree-payments'),
                        'default' => 'no',
                        'value' => 'yes',
                        'description' => __(
                                'If enabled, Google Pay will be an available payment option.', 
                                'braintree-payments'),
                        'tool_tip' => true
                ),
                'googlepay_merchant_id' => array(
                        'title' => __('Google Merchant ID', 
                                'braintree-payments'),
                        'type' => 'text',
                        'default' => '',
                        'tool_tip' => true,
                        'description' => __(
                                'Once you have been approved by Google to accept payments you will be issued a merchant ID. Enter that merchant ID in this field.', 
                                'braintree-payments')
                ), 
				'googlepay_gateway_title' => array (
						'type' => 'text', 
						'title' => __( 'Gateway Title', 'braintree-payments' ), 
						'default' => __( 'Google Pay', 'braintree-payments' ), 
						'tool_tip' => true, 
						'description' => __( 'The title that appears on the checkout page for the gateway.', 'braintree-payments' ) 
				), 
				'googlepay_icon' => array(
                        'type' => 'select',
                        'title' => __('Gateway Icon'),
                        'options' => array(
                                'google_pay_standard' => 'Standard',
                                'google_pay_white_outline' => 'White With Outline'
                        ),
                        'default' => 'google_pay_white_outline',
                        'description' => __(
                                'Google Pay icon that appears on the checkout page.', 
                                'braintree-payments'),
                        'tool_tip' => true
                ),
                'googlepay_format' => array(
                        'title' => __('Google Pay Method Display', 
                                'braintree-payments'),
                        'type' => 'select',
                        'options' => $this->get_googlepay_options(),
                        'value' => '',
                        'default' => 'google_type_last4',
                        'tool_tip' => true,
                        'description' => __(
                                'This option allows you to customize how the Google Pay method will be displayed for your customers on orders, payment methods page, etc.')
                ),
                'googlepay_submit_form' => array(
                        'title' => __('Submit Form', 'braintree-payments'),
                        'type' => 'checkbox',
                        'default' => 'yes',
                        'value' => 'yes',
                        'tool_tip' => true,
                        'description' => __(
                                'If enabled, the checkout form will submit once the Google Pay payment method is chosen by the customer. The customer will not have to click the Place Order button.', 
                                'braintree-payments')
                ),
                'googlepay_button_color' => array(
                        'title' => __('Button Color', 'braintree-payments'),
                        'type' => 'select',
                        'default' => 'default',
                        'options' => array(
                                'default' => __('Default', 'braintree-payments'),
                                'black' => __('Black', 'braintree-payments'),
                                'white' => __('White', 'braintree-payments')
                        ),
                        'tool_tip' => true,
                        'description' => __(
                                'The color of the Google Pay button on the checkout page.', 
                                'braintree-payments')
                ),
                'googlepay_button_type' => array(
                        'title' => __('Button Type', 'braintree-payments'),
                        'type' => 'select',
                        'default' => 'long',
                        'options' => array(
                                'long' => __('Long', 'braintree-payments'),
                                'short' => __('Short', 'braintree-payments')
                        ),
                        'tool_tip' => true,
                        'description' => __(
                                'The type of Google Pay button on the checkout page.', 
                                'braintree-payments')
                )
        );
    }

    public function get_googlepay_options ()
    {
        $patterns = braintree_get_payment_method_formats()[PaymentInstrumentType::ANDROID_PAY_CARD];
        $formats = array();
        foreach ($patterns as $k => $v) {
            $formats[$k] = $v['example'];
        }
        return $formats;
    }
}