<?php
class Braintree_Gateway_Update {

	private static function get_updates() {
		return array( 
				'2.5.4' => bt_manager ()->plugin_admin_path () . 'updates/braintree-update-2.5.4.php', 
				'2.6.0' => bt_manager ()->plugin_admin_path () . 'updates/braintree-update-2.6.0.php', 
				'2.6.22' => bt_manager ()->plugin_admin_path () . 'updates/braintree-update-2.6.22.php' 
		);
	}

	public static function init() {
		/* Run updates when admin_init action is called. */
		add_action ( 'braintree_wc_before_init', __CLASS__ . '::check_version' );
		
		add_action ( 'in_plugin_update_message-' . BFWC_PLUGIN_NAME, __CLASS__ . '::get_admin_update_notice', 10, 2 );
		add_action ( 'activate_' . BFWC_PLUGIN_NAME, __CLASS__ . '::maybe_install' );
		
		add_filter ( 'plugin_action_links_' . BFWC_PLUGIN_NAME, array( 
				__CLASS__, 'plugin_action_links' 
		) );
	}

	public static function plugin_action_links($links) {
		return array_merge ( array( 
				'settings' => sprintf ( '<a href="%1$s">%2$s</a>', admin_url ( 'admin.php?page=braintree-gateway-settings' ), __ ( 'Settings', 'braintree-payments' ) ), 
				'documentation' => sprintf ( '<a href="%1$s">%2$s</a>', 'https://support.paymentplugins.com/hc/en-us', __ ( 'Documentation', 'braintree-payments' ) ) 
		), $links );
	}

	/**
	 * On plugin activate, add the version if necessary.
	 */
	public static function maybe_install() {
		$version = get_option ( 'braintree_for_woocommerce_version' );
		if (! $version) {
			
			$previous_versions = array();
			foreach ( self::get_updates () as $v => $file ) {
				$previous_versions[ $v ] = $v;
			}
			
			update_option ( 'braintree_for_woocommerce_version', array( 
					'currentVersion' => bt_manager ()->version, 
					'previousVersions' => $previous_versions 
			) );
		}
	}

	/**
	 * Check the version of the current installation.
	 */
	public static function check_version() {
		$version = get_option ( 'braintree_for_woocommerce_version' );
		if (! $version || version_compare ( $version[ 'currentVersion' ], bt_manager ()->version, '<' )) {
			self::update ();
			add_action ( 'admin_notices', __CLASS__ . '::update_notice' );
		}
	}

	public static function update() {
		if (! get_option ( 'braintree_for_woocommerce_version' )) {
			$previousVersions = array();
			foreach ( self::get_updates () as $version => $update ) {
				if (file_exists ( $update )) {
					include_once ( $update );
					$previousVersions[ $version ] = $version;
				}
			}
		} else {
			$versions = get_option ( 'braintree_for_woocommerce_version' );
			if (! is_array ( $versions )) {
				delete_option ( 'braintree_for_woocommerce_version' );
				$versions = array( 
						'previousVersions' => array() 
				);
			}
			$previousVersions = $versions[ 'previousVersions' ];
			foreach ( self::get_updates () as $version => $update ) {
				if (! array_key_exists ( $version, $previousVersions )) {
					if (file_exists ( $update )) {
						include_once $update;
						$previousVersions[ $version ] = $version;
					}
				}
			}
		}
		update_option ( 'braintree_for_woocommerce_version', array( 
				'currentVersion' => bt_manager ()->version, 
				'previousVersions' => $previousVersions 
		) );
		
		do_action ( 'bfwc_admin_after_plugin_update' );
	}

	public static function update_notice() {
		$message = sprintf ( __ ( 'Thank you for updating Braintree For WooCommerce to version %s.', 'braintree-payments' ), bt_manager ()->version );
		echo '<div class="notice notice-success is-dismissible"><p>' . $message . '</p></div>';
	}

	public static function get_admin_update_notice($plugin_data, $response) {
		if ($response && property_exists ( $response, 'upgrade_notice' )) {
			echo '<div class="" style="background-color: #FFF2A7; padding: 12px 24px;">' . $response->upgrade_notice . '</div>';
		}
	}
}
Braintree_Gateway_Update::init ();