<?php
class Braintree_Gateway_Admin_Donation_Page extends Braintree_Gateway_Page_API {

	public function __construct() {
		$this->page = 'braintree-donations-page';
		parent::__construct ();
		/* add_action ( 'admin_init', array( __CLASS__, 
				'show_donation_deprecated_message' 
		), 50 ); */
	}

	public static function output() {
		bfwc_admin_get_template ( 'views/donation-page.php' );
	}

	public static function show_donation_deprecated_message() {
		if (isset ( $_POST[ 'bfwc_deprecated_donation_dismiss' ] )) {
			update_option ( 'bfwc_show_deprecated_donations', 'no' );
		}
		if (get_option ( 'bfwc_show_deprecated_donations', 'yes' ) === 'yes') {
			add_action ( 'admin_notices', function () {
				echo "<div class=\"notice notice-info\">
					<p style=\"font-size: 18px\">" . __ ( 'Braintree Gateway Pro: donation functionality will no longer be supported when version 3.0.0 is released in the coming weeks. If you wish to continue using donations, please do not update to 3.0.0 when it\'s released. If you have questions please contact support@paymentplugins.com', 'braintree-payments' ) . "</p>
				<form method=\"post\"><p><button name=\"bfwc_deprecated_donation_dismiss\" valu\"true\" class=\"button button-secondary\">" . __ ( 'Dismiss', 'braintree-payments' ) . "</button></p></form></div>";
			} );
		}
	}
}
new Braintree_Gateway_Admin_Donation_Page ();