<?php

/**
 * Plugin Name: Braintree For WooCommerce
 * Plugin URI: https://support.paymentplugins.com
 * Description: Official partner of Braintree & PayPal. Accept credit cards, PayPal, PayPal Credit, Google Pay, & Apple Pay.
 * Version: 2.6.61
 * Author: Payment Plugins, support@paymentplugins.com
 * Author URI: https://support.paymentplugins.com
 * Text Domain: braintree-payments
 * Domain Path: /i18n/languages/
 * Tested up to: 5.1
 * WC requires at least: 2.3.8
 * WC tested up to: 3.6.2
 */

function bfwc_pro_version_check_error()
{
	$message = sprintf( __( 'Your PHP version is %s but Braintree For WooCommerce requires version 5.4+.', 'braintree-payments' ), PHP_VERSION );
	echo '<div class="notice notice-error"><p style="font-size: 16px">' . $message . '</p></div>';
}

if ( version_compare( PHP_VERSION, '5.4', '<' ) ) {
	add_action( 'admin_notices', 'bfwc_pro_version_check_error' );
	return;
}

define( 'BRAINTREE_GATEWAY_PATH', plugin_dir_path( __FILE__ ) );
define( 'BRAINTREE_GATEWAY_ASSETS', plugin_dir_url( __FILE__ ) . 'assets/' );
define( 'BFWC_PLUGIN_NAME', plugin_basename( __FILE__ ) );
require_once ( BRAINTREE_GATEWAY_PATH . 'Braintree.php' );
require_once BRAINTREE_GATEWAY_PATH . 'includes/class-braintree-manager.php';