jQuery(function($) {
	var smartbutton = {
		container : 'li.bfwc_cart_gateway_' + braintree_smartbuttons_cart_vars.gateway_id,
		message_container: '.shop_table',
		form_id : '#bfwc-cart-fields-form',
		vars : braintree_smartbuttons_cart_vars,
		nonce_id : '#' + braintree_smartbuttons_cart_vars.nonce_id,
		device_data_id : '#' + braintree_smartbuttons_cart_vars.device_data_id,
		options : braintree_smartbuttons_cart_vars.options,
		init : function() {
			this.client_token = braintree_smartbuttons_cart_client_token;
			this.setup_paypal();
			$(document.body)
					.on('updated_wc_div, updated_cart_totals', this.initialize_paypal_button);
			//$(document.body).on('bfwc_paypal_process_cart_order', this.validate_cart_page);
		},
		setup_paypal : function() {
			if (typeof this.client_token === 'undefined') {
				this.submit_error({
					code : 'INVALID_CLIENT_TOKEN'
				});
				return;
			}
			braintree.client.create({
				authorization : this.client_token
			}, function(err, clientInstance) {
				if (err) {
					smartbutton.submit_error(err);
					return;
				}
				smartbutton.clientInstance = clientInstance;

				smartbutton.initialize_fraud_tools();

				braintree.paypalCheckout.create({
					client : smartbutton.clientInstance
				}, function(err, paypalInstance) {
					if (err) {
						smartbutton.submit_error(err);
						return;
					}
					smartbutton.paypalInstance = paypalInstance;
					smartbutton.initialize_paypal_button();
					/*if(smartbutton.vars.paypal_response){
						smartbutton.populate_fields(smartbutton.vars.paypal_response);
					}*/
				});
			})
		},
		initialize_fraud_tools : function() {
			if(smartbutton.vars.advanced_fraud.enabled){
				braintree.dataCollector.create({
					client : smartbutton.clientInstance,
					paypal : true,
					kount: true
				}, function(err, dataCollectorInstance) {
					if (err) {
						if(err.code === 'DATA_COLLECTOR_KOUNT_NOT_ENABLED'){
							return;
						}
						smartbutton.submit_error(err);
						return;
					}
					smartbutton.dataCollectorInstance = dataCollectorInstance;
					$(smartbutton.device_data_id).val(
							smartbutton.dataCollectorInstance.deviceData);
				})
			}
		},
		initialize_paypal_button : function() {
			var $container = $('.paypal-button-container');
			$container.find('.paypal-button').remove();
			paypal.Button.render(smartbutton.render_options(), $container[0]);
			smartbutton.$button = $container.find(".paypal-button");
		},
		is_valid: function(){
			smartbutton.validate_cart_page();
		},
		render_options : function() {
			return {
				braintree : braintree,
				client : {
					sandbox : smartbutton.client_token,
					production : smartbutton.client_token
				},
				locale : smartbutton.vars.locale,
				style : smartbutton.vars.buttonStyle,
				funding : {
					allowed : smartbutton.get_allowed_funding(),
					disallowed : [ paypal.FUNDING.CREDIT, paypal.FUNDING.CARD ]
				},
				env : smartbutton.vars.environment,
				validate : function(actions) {
					smartbutton.actions = actions;
					if ($(smartbutton.nonce_id).val().length > 0) {
						smartbutton.actions.disable();
					}
					if($('[name="terms"]').length){
						smartbutton.actions.disable();
						if($('[name="terms"]').is(':checked')){
							smartbutton.actions.enable();
						}
						$(document.body).on('change', '[name="terms"]', function(){
							if($(this).is(':checked')){
								smartbutton.actions.enable();
							}else{
								smartbutton.actions.disable();
							}
						});
					}
				},
				onClick : function() {
					if ($(smartbutton.nonce_id).val().length > 0) {
						smartbutton.process_order();
					}
					smartbutton.is_valid();
				},
				payment : function(data, actions) {
					return smartbutton.paypalInstance.createPayment(smartbutton
							.get_options())['catch']
							(function(err) {
								if (err.code === 'PAYPAL_INVALID_PAYMENT_OPTION') {
									if (err.details.originalError.details.originalError.paymentResource.errorDetails) {
										err.code = err.code + '_ADDRESS';
									}
								}
								smartbutton.submit_error(err);
								return;
							});
				},
				onAuthorize : function(data, actions) {
					return smartbutton.paypalInstance.tokenizePayment(data,
							function(err, response) {
								smartbutton.tokenize_response = response;
								smartbutton
										.on_payment_method_received(response);
							});
				},
				onCancel : function(data) {

				},
				onError : function(err) {

				}
			}
		},
		get_options : function() {
			return $.extend(smartbutton.options, {
				amount : $('#bfwc_cart_total').val()
			});
		},
		populate_fields: function(response){
			// add the nonce and update the shipping fields.
			$(this.nonce_id).val(response.nonce);
			if (this.dataCollectorInstance) {
				$(this.device_data_id).val(
						this.dataCollectorInstance.deviceData);
			}
			if (this.vars.options.enableShippingAddress) {
				// add shipping address to inputs
				$.each(this.get_address_fields('shipping'),
						function(index, key) {
							$('[name="' + key + '"]').val(
									response.details.shippingAddress[index]);
						});
				$('[name="shipping_first_name"]').val(
						response.details.shippingAddress.recipientName
								.split(" ")[0]);
				$('[name="shipping_last_name"]').val(
						response.details.shippingAddress.recipientName
								.split(" ")[1]);
				$('[name="shipping_email"]').val(response.details.email);
				$('[name="shipping_phone"]').val(response.details.phone);
			}
			var addressObject = response.details.billingAddress ? response.details.billingAddress
					: response.details.shippingAddress;
			$.each(this.get_address_fields("billing"), function(index, key) {
				$('[name="' + key + '"]').val(addressObject[index]);
			});
			$('[name="billing_first_name"]').val(response.details.firstName);
			$('[name="billing_last_name"]').val(response.details.lastName);
			$('[name="billing_email"]').val(response.details.email);
			$('[name="billing_phone"]').val(response.details.phone);
		},
		on_payment_method_received : function(response) {
			this.populate_fields(response);
			this.process_order();
		},
		process_order : function() {
			// create the order using ajax;
			if($(document.body).triggerHandler('bfwc_paypal_process_cart_order') === false){
				return;
			}
			$form = $(smartbutton.form_id);
			$.blockUI({
				message : null,
				overlayCSS : {
					background : '#fff',
					opacity : 0.6
				}
			});
			$.ajax({
				type : 'POST',
				url : smartbutton.vars.cart_url,
				data : $form.serialize(),
				dataType : 'json',
				beforeSend : function(xhr, settings) {
					xhr.setRequestHeader('X-WP-Nonce',
							smartbutton.vars._wpnonce);
				},
				success : function(result, status, jqXHR) {
					smartbutton.vars._wpnonce = jqXHR
							.getResponseHeader('X-WP-Nonce');
					if (result.reload) {
						window.location.reload();
						return;
					}
					if (result.result === 'success') {
						window.location = result.redirect;
					} else {
						if (result.messages) {
							smartbutton.submit_error(result.messages);
						}
						$.unblockUI();
						$(smartbutton.nonce_id).val("");
						smartbutton.actions.enable();
						/*if (smartbutton.has_error()) {
							$.unblockUI();
							$(smartbutton.nonce_id).val("");
							smartbutton.actions.enable();
						}else{
							smartbutton.actions.disable();
						}*/
						$.unblockUI();
					}
				},
				error : function(jqXHR, textStatus, errorThrown) {
					smartbutton.submit_error(errorThrown);
					smartbutton.actions.disable();
					$.unblockUI();
				}
			});
		},
		submit_form : function() {
			$(this.form_id).submit();
		},
		get_allowed_funding : function() {
			options = [];
			//options.push(paypal.FUNDING.CARD);
			/*if (smartbutton.vars.options.offerCredit) {
				options.push(paypal.FUNDING.CREDIT);
			}*/
			return options;
		},
		get_address_fields : function(prefix) {
			fields = {
				// recipientName: [prefix+'first_name', prefix+'last_name'],
				line1 : prefix + '_address_1',
				line2 : prefix + '_address_2',
				city : prefix + '_city',
				countryCode : prefix + '_country',
				postalCode : prefix + '_postcode',
				state : prefix + '_state',
				phone : prefix + '_phone'
			}
			return fields;
		},
		submit_error : function(error) {
			smartbutton.clear_error();
			$(document.body).triggerHandler('bfwc_submit_error', {
				error : error,
				element : smartbutton.message_container
			});
		},
		has_error: function(){
			return $('#bfwc_checkout_error').length > 0;
		},
		clear_error: function(){
			$('#bfwc_checkout_error').remove();
		},
		validate_cart_page: function(){
			if($('[name="terms"]').length){
				if(!$('[name="terms"]').is(':checked')){
					smartbutton.submit_error(smartbutton.vars.messages.terms_required);
					smartbutton.actions.disable();
					return false;
				}
			}
		}
	}
	smartbutton.init();
});