jQuery(function($) {

	var smartbutton = {
		container : 'li.payment_method_'
				+ braintree_paypal_smartbuttons_vars.gateway_id,
		gateway_id: braintree_paypal_smartbuttons_vars.gateway_id,
		button_container : '.bfwc-paypal-smartbutton',
		token_selector : '.bfwc-payment-method-token',
		tokenized_selector : '.bfwc-tokenized-paypal-method',
		nonce_selector : '.bfwc-nonce-value',
		device_data_selector : '.bfwc-device-data',
		vars : braintree_paypal_smartbuttons_vars,
		banner_container: '.bfwc_banner_gateway_' + braintree_paypal_smartbuttons_vars.gateway_id,
		tokenize_response: null,
		init : function() {
			this.banner_enabled = this.vars.banner_enabled === "1";
			
			$(document.body).on('updated_checkout', this.maybe_update_vars);
			$(document.body).on('updated_checkout', this.initialize_paypal_button);
			$(document.body).on('checkout_error', this.checkout_error);
			$(document.body).on('bfwc_pre_form_submit_' + this.gateway_id, this.set_device_data);
			$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.woocommerce_form_submit);
			$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.pre_submit_validations);
			
			$(document.body).on('bfwc_display_saved_methods', this.display_saved_methods);
			$(document.body).on('bfwc_display_new_payment_method_container', this.display_new_payment_method_container);
			
			$(this.container).closest('form').on('woocommerce_form_submit_' + this.gateway_id, this.woocommerce_form_submit);
			$(this.container).closest('form').on('woocommerce_form_submit_' + this.gateway_id, this.set_device_data);
			
			this.setup_instances();
		},
		initialize_paypal_button : function() {
			var $parent = $("#place_order").parent();
			$parent.find(".paypal-button").remove();
			paypal.Button.render(smartbutton.render_options(), $parent[0]);
			smartbutton.$button = $parent.find(".paypal-button");
			smartbutton.payment_gateway_changed(null,$('[name="payment_method"]:checked').val());
			if(smartbutton.tokenize_response){
				smartbutton.create_payment_html(smartbutton.tokenize_response);
				$('.bfwc-cancel-saved').trigger('click');
			}
		},
		setup_instances: function(){
			if(typeof braintree_paypal_smartbuttons_client_token === 'undefined'){
				this.submit_error({
					code: 'INVALID_CLIENT_TOKEN'
				});
				return;
			}
			if(typeof braintree === "undefined"){
				setTimeout(smartbutton.setup_instances, 1500);
				return;
			}
			braintree.client.create({
				authorization: braintree_paypal_smartbuttons_client_token
			}, function(err, clientInstance){
				if(err){
					smartbutton.submit_error(err);
					return;
				}
				smartbutton.clientInstance = clientInstance;
				
				smartbutton.initialize_fraud_tools();
				
				braintree.paypalCheckout.create({
					client: smartbutton.clientInstance
				}, function(err, paypalInstance){
					if(err){
						smartbutton.submit_error(err);
						return;
					}
					smartbutton.paypalInstance = paypalInstance;
					smartbutton.initialize_paypal_button();
					if(smartbutton.banner_enabled){
						if($(smartbutton.banner_container).length){
							$(smartbutton.banner_container).prepend('<div class="paypal-top-container"></div>');
							paypal.Button.render($.extend(smartbutton.render_options(), {funding:{allowed:[], disallowed: [paypal.FUNDING.CARD, paypal.FUNDING.CREDIT]}}), '.paypal-top-container');
						}
					}
					$(document.body).on('bfwc_payment_method_selected', smartbutton.payment_gateway_changed);
				});
			})
		},
		initialize_fraud_tools: function(){
			if(smartbutton.vars.advanced_fraud.enabled){
				braintree.dataCollector.create({
					client: smartbutton.clientInstance,
					paypal: true,
					kount: true
				}, function(err, dataCollectorInstance){
					if(err){
						if(err.code === 'DATA_COLLECTOR_KOUNT_NOT_ENABLED'){
							return;
						}
						smartbutton.submit_error(err);
						return;
					}
					smartbutton.dataCollectorInstance = dataCollectorInstance;
				})
			}
		},
		render_options : function() {
			return {
				braintree : braintree,
				client : {
					sandbox : braintree_paypal_smartbuttons_client_token,
					production : braintree_paypal_smartbuttons_client_token
				},
				style : smartbutton.vars.buttonStyle,
				funding : {
					allowed: smartbutton.get_allowed_funding(),
					disallowed : !smartbutton.vars.options.offerCredit ? [ paypal.FUNDING.CREDIT] : []
				},
				env : smartbutton.vars.environment,
				onClick: function(){
					if(smartbutton.banner_enabled){
						$('#payment_method_' + smartbutton.gateway_id).prop('checked', true).trigger('click');
						$('.bfwc-cancel-saved').trigger('click');
					}
				},
				payment : function(data, actions) {
					return smartbutton.paypalInstance.createPayment(smartbutton.options())['catch'](function(err){
						if(err.code === 'PAYPAL_INVALID_PAYMENT_OPTION'){
							if(err.details.originalError.details.originalError.paymentResource.errorDetails){
								err.code = err.code + '_ADDRESS';
							}
						}
						smartbutton.submit_error(err);
						return;
					});
				},
				onAuthorize : function(data, actions) {
					return smartbutton.paypalInstance.tokenizePayment(data, function(err, response){
						smartbutton.on_payment_method_received(response);
					});
				},
				onCancel : function(data) {
					
				},
				onError : function(err) {
					//smartbutton.submit_error(err);
				}
			}
		},
		get_allowed_funding: function(){
			options = [];
			options.push(paypal.FUNDING.CARD);
			if(smartbutton.vars.options.offerCredit){
				options.push(paypal.FUNDING.CREDIT);
			}
			return options;
		},
		is_production : function() {
			return smartbutton.vars.environment === 'production';
		},
		get_address_object: function(prefix){
			var object = {};
			var useAddress = true;
			$.each(this.get_address_fields(prefix), function(key, val){
				if(Array.isArray(val)){
					var fieldVal = '';
					for(var i=0;i<val.length;i++){
						fieldVal += $(val[i]).length ? $(val[i]).val().trim() + ' ' : '';
					}
					object[key] = fieldVal.trim();
				}else{
					object[key] = $(val).length ? $(val).val().trim() : '';
				}
				if(object[key] == '' && (key.match(/(city)|(countryCode)|(line1)|(postalCode)|(state)/) != null)){
					useAddress = false;
				}
			});
			return useAddress ? object : {};
		},
		get_address_fields: function(prefix){
			fields = {
					recipientName: [prefix+'first_name', prefix+'last_name'],
					line1: prefix + 'address_1',
					line2: prefix + 'address_2',
					city: prefix + 'city',
					countryCode: prefix + 'country',
					postalCode: prefix + 'postcode',
					state: prefix + 'state',
					phone: prefix + 'phone'
			}
			return fields;
		},
		get_shipping_prefix: function(){
			var prefix = $('[name^="shipping_"]').length
			&& $('[name="ship_to_different_address"]').is(
					':checked') ? '#shipping_' : '#billing_';
			return prefix;
		},
		options : function() {
			var options = smartbutton.vars.options;
			if (options.enableShippingAddress
					&& ($('[name^="shipping_"]').length || $('[name^="billing_"]').length)) {
				options.shippingAddressOverride = smartbutton.get_address_object(smartbutton.get_shipping_prefix());
			}
			options.amount = $('#bfwc_cart_total').length ? $(
					'#bfwc_cart_total').val() : smartbutton.vars.order_total;
			return options;
		},
		on_payment_method_received : function(response) {
			smartbutton.payment_method_received = true;
			smartbutton.tokenize_response = response;
			smartbutton.update_addresses(response.details);
			smartbutton.create_payment_html(response);
			$(smartbutton.container).find(smartbutton.nonce_selector).val(
					response.nonce);
			smartbutton.$button.hide();
			$("#place_order").show();
			if (smartbutton.vars.form.submit) {
				$(smartbutton.container).closest('form').submit();
			}
		},
		update_addresses: function(details){
			//update billing fields:
			if(details.billingAddress || (details.shippingAddress && !$('[name="ship_to_different_address"]').is(':checked'))){
				var billingAddress = details.billingAddress ? details.billingAddress : details.shippingAddress;
				if(billingAddress && !$.isEmptyObject(billingAddress)){
					var fields = smartbutton.get_address_fields('billing_');
					$.each(fields, function(key, name){
						if(key == 'recipientName'){
							$("#billing_first_name").val(details.firstName);
							$("#billing_last_name").val(details.lastName);
						}else{
							name = "#" + name;
							if($(name).length > 0){
								$(name).val(billingAddress[key]);
							}
						}
					});
					$('#billing_phone').val(details.phone);
					$('#billing_email').val(details.email);
				}
			}
			//update shipping fields;
			if(details.shippingAddress && !$.isEmptyObject(details.shippingAddress)){
				//if shipping enabled, then update shipping fiels;
				if($('[name^="shipping_"]').length > 0){
					fields = smartbutton.get_address_fields('shipping_');
					$.each(fields, function(key, name){
						if(key == 'recipientName'){
							var recipientName = details.shippingAddress.recipientName.match(/^[a-z ,.'-]+$/);
							if(recipientName){
								$("#shipping_first_name").val(recipientName[0]);
								$("#shipping_last_name").val(recipientName.length == 2 ? recipientName[1] : '');
							}else{
								$("#shipping_first_name").val(details.firstName);
								$("#shipping_last_name").val(details.lastName);
							}
						}else{
							name = "#" + name;
							if($(name).length > 0){
								$(name).val(details.shippingAddress[key]);
							}
						}
					});
				}
				$('[name*="_state"], [name*="_country"]').trigger("change");
			}
			//compare billing and shipping address to see if different
			if($('[name="ship_to_different_address"]').length){
				$('.ship_to_different_address').prop('checked', smartbutton.get_address_hash('billing') !== smartbutton.get_address_hash('shipping')).trigger('change')
			}
		},
		create_payment_html: function(response){
			var container = $(smartbutton.container).find(
					smartbutton.tokenized_selector);
			container.empty();
			var html = $(smartbutton.vars.html);
			$(html).find('.payment-method-description').text(
					response.details.email);
			container.append(html);
			$(smartbutton.container).find('.braintree-paypal-button').slideUp(
					400);
			$(smartbutton.container).on('click', '.bfwc-paypal-cancel', this.remove_method);
			container.slideDown(400);
		},
		submit_error: function(error){
			$(document.body).triggerHandler('bfwc_submit_error', {error: error, element: smartbutton.container});
		},
		maybe_update_vars: function(e){
			if(smartbutton.should_update_vars()){
				$(smartbutton.container).closest('form').block({
					message: null,
					overlayCSS: {
						background: '#fff',
						opacity: 0.6
					}
				});
				var data = {
						bfwc_handle: 'paypal-smartbuttons', 
						security: smartbutton.vars.update_checkout_nonce,
						billing_country: $('#billing_country').val(),
						shipping_country: $('#shipping_country').val()
				};
				$.ajax({
					type: 'POST',
					url: smartbutton.vars.wc_ajax_url.toString().replace( '%%endpoint%%', 'bfwc_updated_checkout' ),
					data: data,
					success: function(response){
						$(smartbutton.container).closest('form').unblock();
						if(response.success){
							smartbutton.vars = response.data;
							smartbutton.initialize_paypal_button();
						}
					},
					error: function(jqXHR, textStatus, errorThrown ){
						$(paypal.container).closest('form').unblock();
					}
				});
			}
		},
		should_update_vars: function(){
			return smartbutton.vars.creditConditions.enabled;
		},
		checkout_error: function(){
			if(smartbutton.is_gateway_selected() && smartbutton.has_checkout_error()){
				smartbutton.payment_method_received = false;
				smartbutton.remove_method();
				smartbutton.payment_gateway_changed(null,$('[name="payment_method"]:checked').val());
			}
		},
		woocommerce_form_submit: function(e){
			if(smartbutton.is_payment_method_selected()){
				return true;
			}else{
				if(smartbutton.payment_method_received){
					return true;
				}else{
					return false;
				}
			}
		},
		is_gateway_selected: function(){
			return $('input[name="payment_method"]:checked').val() === smartbutton.vars.gateway_id;
		},
		is_payment_method_selected: function(){
			if($(smartbutton.container).find(smartbutton.token_selector).length){
				if($(smartbutton.container).find(smartbutton.token_selector).val() !== ''){
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}
		},
		set_device_data: function(){
			if(smartbutton.dataCollectorInstance){
				$(smartbutton.container).find(smartbutton.device_data_selector).val(smartbutton.dataCollectorInstance.deviceData);
			}
			return true;
		},
		pre_submit_validations: function(){
			if($('[name="terms"]').length > 0 && !$('[name="terms"]').is(':checked')){
				var data = {
						element: $(smartbutton.container),
						error: {
							message: smartbutton.vars.terms.message
						}
				};
				$(document.body).triggerHandler('bfwc_submit_error', data);
				return false;
			}else{
				return true;
			}
		},
		remove_method: function(){
			smartbutton.payment_method_received = false;
			smartbutton.tokenize_response = false;
			$(smartbutton.container).find(smartbutton.nonce_selector).val('');
			var container = $(smartbutton.container).find(smartbutton.tokenized_selector);
			container.slideUp(400, function(){
				$(this).empty();
				$(smartbutton.container).find('.braintree-paypal-button').slideDown(400);
			});
			smartbutton.payment_gateway_changed(null,$('[name="payment_method"]:checked').val());
		},
		payment_gateway_changed: function(e, payment_gateway){
			var button = $('#place_order');
			if(payment_gateway === smartbutton.gateway_id){
				if(smartbutton.is_payment_method_selected() || smartbutton.payment_method_received){
					smartbutton.$button.hide();
					button.show();
				}else{
					smartbutton.$button.show();
					button.hide();
				}
			}else{
				smartbutton.$button.hide();
			}
		},
		display_saved_methods: function(e, gateway_id){
			if(smartbutton.gateway_id == gateway_id){
				smartbutton.$button.hide();
				$("#place_order").show();
			}
		},
		display_new_payment_method_container: function(e, gateway_id){
			if(smartbutton.gateway_id == gateway_id){
				if(!smartbutton.payment_method_received){
					smartbutton.$button.show();
					$("#place_order").hide();
				}
			}
		},
		has_checkout_error: function(){
			return $('#bfwc_checkout_error').length > 0;
		},
		get_address_hash: function(prefix){
			var fields = ['_first_name', '_last_name', '_country', '_address_1', '_address_2', '_city', '_state', '_postcode'];
			var hash = '';
			$.each(fields, function(i, k){
				k = '#' + prefix + k;
				hash += $(k).val();
			});
			return JSON.stringify(hash);
		}
	}

	smartbutton.init();

})