jQuery(function($){
	
	if(typeof braintree_googlepay_vars === 'undefined'){
		return;
	}
	
	var googlepay = {
			list_container: 'li.payment_method_' + braintree_googlepay_vars.gateway_id,
			container: '.payment_method_' + braintree_googlepay_vars.gateway_id,
			gateway_id: braintree_googlepay_vars.gateway_id,
			button_selector: '.bfwc-googlepay-tokenize',
			button_class: 'bfwc-googlepay-tokenize',
			nonce_selector: '.bfwc-nonce-value',
			token_selector: '.bfwc-payment-method-token',
			method_container: '.bfwc-new-payment-method-container',
			submit_form: braintree_googlepay_vars.form_actions.submit_form,
			html: braintree_googlepay_vars.html,
			buttonOptions: braintree_googlepay_vars.buttonOptions,
			cannot_pay: true,
			tokenize_response: null,
			init: function(){
				
				$(document.body).on('click', this.button_selector, this.tokenize);
				
				$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.woocommerce_form_submit);
				$(this.container).closest('form').on('checkout_place_order_' + this.gateway_id, this.pre_submit_validations);
				
				$(document.body).on('updated_checkout', this.create_button);
				$(document.body).on('updated_checkout', this.maybe_hide_gateway);
				
				this.maybe_hide_gateway();
				$(document.body).on('checkout_error', this.checkout_error);
				
				this.initialize();
				
			},
			initialize: function(){
				if(typeof braintree_googlepay_client_token === 'undefined'){
					this.submit_error({
						code: 'INVALID_CLIENT_TOKEN'
					});
					return;
				}
				if(typeof braintree === "undefined"){
					setTimeout(googlepay.initialize, 1500);
					return;
				}
				braintree.client.create({
					authorization: braintree_googlepay_client_token
				}, function(err, clientInstance){
					if(err){
						googlepay.submit_error(err);
						return;
					}
					googlepay.clientInstance = clientInstance;
					braintree.googlePayment.create({
						client: clientInstance,
						googlePayVersion: 2,
						googleMerchantId: googlepay.get_merchant_id()
					}, function(err, googlePayInstance){
						if(err){
							if(err.code === 'GOOGLE_PAYMENT_NOT_ENABLED'){
								$(googlepay.container).hide();
								googlepay.cannot_pay = true;
							}
							googlepay.submit_error(err);
							return;
						}
						googlepay.googlePayInstance = googlePayInstance;
						
						googlepay.paymentsClient = new google.payments.api.PaymentsClient({
							environment: googlepay.get_environment()
						});
						
						googlepay.paymentsClient.isReadyToPay({
							apiVersion: 2,
					        apiVersionMinor: 0,
							allowedPaymentMethods: googlePayInstance.createPaymentDataRequest().allowedPaymentMethods
						}).then(function(response){
							if(!response.result){
								googlepay.cannot_pay = true;
							}else{
								//show googlepay gateway
								googlepay.cannot_pay = false;
								$(googlepay.list_container).show();
								googlepay.create_button();
								$(document.body).on('bfwc_payment_method_selected', googlepay.payment_gateway_changed);
								$(document.body).on('bfwc_display_saved_methods', googlepay.display_saved_methods);
								$(document.body).on('bfwc_display_new_payment_method_container', googlepay.display_new_payment_method_container);
								setInterval(googlepay.maybe_hide_gateway, 2000);
							}
						})['catch'](function(err){
							googlepay.submit_error({message: err.statusMessage});
							return;
						});
					});
				});
			},
			create_button: function(){
				if(googlepay.$button){
					googlepay.$button.remove();
				}
				if(googlepay.paymentsClient){
					googlepay.$button = $(googlepay.paymentsClient.createButton($.extend({onClick: googlepay.tokenize}, googlepay.buttonOptions)));
					googlepay.$button.addClass('wc-braintree-googlepay-button-container');
					googlepay.$button.hide();
					$("#place_order").parent().append(googlepay.$button);
					googlepay.payment_gateway_changed(null, $('input[name="payment_method"]:checked').val());
				}
				if(googlepay.tokenize_response){
					googlepay.on_payment_method_received(googlepay.tokenize_response);
					$('.bfwc-cancel-saved').trigger('click');
				}
			},
			tokenize: function(e){
				e.preventDefault();
				var paymentDataRequest = googlepay.googlePayInstance.createPaymentDataRequest(googlepay.get_payment_data_request());
				try{
					googlepay.paymentsClient.loadPaymentData(paymentDataRequest).then(function(paymentData){
						return googlepay.googlePayInstance.parseResponse(paymentData);
					}).then(function(response){
						googlepay.on_payment_method_received(response);
					})['catch'](function(err){
						if(err.statusCode === 'CANCELED'){
							return;
						}
						var error = {
								message: err.statusMessage
						};
						googlepay.submit_error(error);
						return;
					});
				}catch(err){
					googlepay.submit_error({message: err});
				}
			},
			get_payment_data_request: function(){
				return {
					transactionInfo: {
						currencyCode: $('#bfwc_cart_currency').val(),
						totalPriceStatus: 'FINAL',
						totalPrice: $('#bfwc_cart_total').val()
					}
				}
			},
			get_environment: function(){
				return $('#bfwc_environment').val();
			},
			get_merchant_id: function(){
				return $('#bfwc_google_merchant_id').val();
			},
			on_payment_method_received: function(response){
				if(googlepay.googlepayView){
					googlepay.googlepayView.removeView();
				}
				googlepay.tokenize_response = response;
				googlepay.payment_method_received = true;
				$(googlepay.container).find(googlepay.nonce_selector).val(response.nonce);
				
				//render paypal payment method using Backbone.
				googlepay.googlepayView = new GooglePayMethodView({
					model: new GooglePayMethod(response),
					parent: $(googlepay.container).find(googlepay.method_container),
					nonce: $(googlepay.container).find(googlepay.nonce_selector),
					button: googlepay.$button,
					html: googlepay.html
				});
				
				$("#place_order").show();
				
				if(googlepay.submit_form){
					$(googlepay.container).closest('form').submit();
				}
			},
			woocommerce_form_submit: function(e){
				if(googlepay.payment_method_received){
					return true;
				}else{
					return false;
				}
			},
			submit_error: function(error){
				$(document.body).triggerHandler('bfwc_submit_error', {error: error, element: googlepay.container});
			},
			pre_submit_validations: function(){
				if($('[name="terms"]').length > 0 && !$('[name="terms"]').is(':checked')){
					var data = {
							element: $(googlepay.container),
							error: {
								message: braintree_googlepay_vars.terms.message
							}
					};
					$(document.body).triggerHandler('bfwc_submit_error', data);
					return false;
				}else{
					return true;
				}
			},
			checkout_error: function(){
				if(googlepay.is_gateway_selected() && googlepay.has_checkout_error()){
					googlepay.payment_method_received = false;
					googlepay.tokenize_response = null;
					if(googlepay.googlepayView){
						googlepay.googlepayView.removeView();
					}
					if(googlepay.is_gateway_selected()){
						googlepay.payment_gateway_changed(null, googlepay.gateway_id);
					}
				}
			},
			is_gateway_selected: function(){
				return $('input[name="payment_method"]:checked').val() === googlepay.gateway_id;
			},
			payment_gateway_changed: function(e, payment_gateway){
				var button = $('#place_order');
				if(payment_gateway === googlepay.gateway_id && !googlepay.cannot_pay){
					if(!googlepay.is_payment_method_selected() && !googlepay.payment_method_received){
						googlepay.$button.show();
						button.hide();
					}else{
						googlepay.$button.hide();
						button.show();
					}
				}else{
					googlepay.$button.hide();
				}
			},
			maybe_hide_gateway: function(){
				if(!googlepay.cannot_pay){
					$(googlepay.list_container).show();
				}
			},
			has_checkout_error: function(){
				return $('#bfwc_checkout_error').length > 0;
			},
			display_saved_methods: function(e, gateway_id){
				if(googlepay.gateway_id == gateway_id){
					googlepay.$button.hide();
					$("#place_order").show();
				}
			},
			display_new_payment_method_container: function(e, gateway_id){
				if(googlepay.gateway_id == gateway_id){
					if(!googlepay.payment_method_received){
						googlepay.$button.show();
						$("#place_order").hide();
					}
				}
			},
			is_payment_method_selected: function(){
				if($(googlepay.container).find(googlepay.token_selector).length){
					if($(googlepay.container).find(googlepay.token_selector).val() !== ''){
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			},
	}
	
	var GooglePayMethod = Backbone.Model.extend({
		initialize: function(){
			var cardType = this.get('details').cardType;
		}
	});
	
	var GooglePayMethodView = Backbone.View.extend({
		events: {
			'click .googlepay-remove-method':'removeView'
		},
		initialize: function(params){
			this.parent = params.parent;
			this.$nonce = params.nonce;
			this.$button = params.button;
			this.template = _.template($(params.html).html());
			this.render();
		},
		render: function(){
			this.setElement(this.template(this.model.toJSON()));
			this.$button.hide();
			this.parent.append(this.$el);
		},
		removeView: function(){
			googlepay.payment_method_received = false;
			googlepay.tokenize_response = null;
			googlepay.payment_gateway_changed(null, googlepay.gateway_id);
			this.$nonce.val('');
			this.$button.show();
			this.remove();
		}
	});
	
	googlepay.init();
});