jQuery(function($){
	
	if(typeof braintree_applepay_vars === 'undefined'){
		return;
	}
	
	var applepay = {
			vars: braintree_applepay_vars,
			warning_container: '#braintree-applepay-warning',
			applepay_button: '.apple-pay-button',
			container: 'li.payment_method_' + braintree_applepay_vars.gateway_id,
			gateway_id: braintree_applepay_vars.gateway_id,
			nonce_selector: '.bfwc-nonce-value',
			token_selector: '.bfwc-payment-method-token',
			banner_container: '.bfwc_banner_gateway_' + braintree_applepay_vars.gateway_id,
			banner_enabled: braintree_applepay_vars.banner_enabled === "1",
			init: function(){
				this.needs_shipping = this.vars.needs_shipping === "1";
				this.assign_parent_class();
				
				//checkout page functionality.
				$(applepay.container).closest('form').on('checkout_place_order_' + braintree_applepay_vars.gateway_id, this.woocommerce_form_submit);
				$(document.body).on('updated_checkout', this.check_setup);
				$(document.body).on('checkout_error', this.checkout_error);
				
				$(document.body).on('bfwc_display_saved_methods', this.display_saved_methods);
				$(document.body).on('bfwc_display_new_payment_method_container', this.display_new_payment_method_container);
				
				//other page form functionality.
				$(applepay.container).closest('form').on('woocommerce_form_submit_' + braintree_applepay_vars.gateway_id, this.woocommerce_form_submit);
				
				this.setup_applepay();
			},
			assign_parent_class: function(){
				//ensure container has proper classes.
				$('input[name="payment_method"]').each(function(){
					
					var payment_gateway = $(this).val();
					
					if( !$(this).closest('li').hasClass('payment_method_' + payment_gateway)){
						
						$(this).closest('li').addClass('payment_method_' + payment_gateway);
					}
				})
			},
			setup_applepay: function(){

				if(!$(applepay.container).length){
					return;
				}
				
				if(typeof braintree_applepay_client_token === 'undefined'){
					this.submit_error({
						code: 'INVALID_CLIENT_TOKEN'
					});
					return;
				}
				
				if(this.can_initialize_applepay()){
					applepay.show_gateway();
					this.create_button();
					if(applepay.banner_enabled && $(applepay.banner_container).length){
						$(applepay.banner_container).prepend('<div class="applepay-top-container">' + applepay.vars.button_html + '</div>');
					}
					applepay.payment_gateway_changed(null, $('[name="payment_method"]:checked').val());
					$(document.body).on('bfwc_payment_method_selected', this.payment_gateway_changed);
					braintree.client.create({
						authorization: braintree_applepay_client_token
					}, function(err, clientInstance){
						if(err){
							applepay.submit_error(err);
							return;
						}
						braintree.applePay.create({
							client: clientInstance
						}, function(err, applePayInstance){
							if(err){
								applepay.submit_error(err);
								return;
							}
							applepay.applePayInstance = applePayInstance;
			
							var promise = ApplePaySession.canMakePaymentsWithActiveCard(applePayInstance.merchantIdentifier);
							
							promise.then(function(canMakePaymentsWithActiveCard){
								$(document.body).on('click', applepay.applepay_button, applepay.tokenize_method);
							});
							
						})
					});
				}else{
					applepay.hide_gateway();
				}
			},
			create_button: function(){
				var $parent = $('#place_order').parent();
				$parent.find('.apple-pay-button').remove();
				applepay.$button = $(applepay.vars.button_html);
				$parent.append(applepay.$button);
				applepay.payment_gateway_changed(null,$('[name="payment_method"]:checked').val());
			},
			tokenize_method: function(e){
				
				e.preventDefault();
				
				if(!applepay.can_initialize_applepay()){
					return;
				}
				if(applepay.banner_enabled){
					$('#payment_method_' + applepay.gateway_id).prop('checked', true).trigger('click');
					$('.bfwc-cancel-saved').trigger('click');
				}
				var paymentRequest = applepay.applePayInstance.createPaymentRequest({
					total: {
						label: braintree_applepay_vars.store_name,
						amount: $("#bfwc_cart_total").val(),
						type: 'final'
					},
					currencyCode: $('#bfwc_cart_currency').val(),
					requiredBillingContactFields: applepay.get_billing_fields_array(),
					requiredShippingContactFields: applepay.get_shipping_fields_array()
					//billingContact: applepay.get_billing_contact(),
					//shippingContact: applepay.get_shipping_contact()
				});

				try{
					var applePaySession = new ApplePaySession(3, paymentRequest);
				}catch(err){
					applepay.submit_error(err);
					return;
				}
				applePaySession.onvalidatemerchant  = function(event){
					applepay.applePayInstance.performValidation({
						validationURL: event.validationURL,
						displayName: braintree_applepay_vars.store_name
					}, function(err, merchantSession){
						if(err){
							applepay.submit_error(err);
							applePaySession.abort();
							return;
						}
						applePaySession.completeMerchantValidation(merchantSession);
					})
				};
				applePaySession.onpaymentauthorized = function(event){
					applepay.applePayInstance.tokenize({
						token: event.payment.token
					}, function(err, response){
						if(err){
							applepay.submit_error(err);
							applePaySession.completePayment(ApplePaySession.STATUS_FAILURE);
							return;
						}
						applePaySession.completePayment(ApplePaySession.STATUS_SUCCESS);
						$(applepay.container).find(applepay.nonce_selector).val(response.nonce);
						applepay.payment_method_received = true;
						applepay.populate_address_data(event.payment);
						applepay.tokenize_response = {payment: event.payment, response: response};
						if(!applepay.pre_submit_validations()){
							return;
						}
						$(applepay.container).closest('form').submit();
					})
				};
				
				//open the payments sheet.
				applePaySession.begin();
			},
			populate_address_data: function(response){
				if(response.shippingContact){
					//populate the shipping fields
					var mappings = applepay.get_object_mappings();
					$.each(response.shippingContact, function(k, v){
						if(mappings[k]){
							mappings[k].set(v, "#shipping");
						}
					});
				}
				if(response.billingContact){
					//populate the billing fields
					var mappings = applepay.get_object_mappings();
					$.each(response.billingContact, function(k, v){
						if(mappings[k]){
							if(mappings[k]){
								mappings[k].set(v, "#billing");
							}
						}
					});
				}
				applepay.address_compare(response);
				
				$('[name*="_state"], [name*="_country"]').trigger("change");
			},
			address_compare: function(response){
				if(response.shippingContact && response.billingContact){
					if($('[name="ship_to_different_address"]').length){
						var newAddress = {}, billingAddress = {},
						shippingAddress = {};
						fields = ['givenName', 'familyName', 'addressLines', 'administrativeArea', 'countryCode', 'locality', 'postalCode'];
						$.each(fields, function(i, k){
							if(response.billingContact[k]){
								billingAddress[k] = response.billingContact[k];
							}
							if(response.shippingContact[k]){
								shippingAddress[k] = response.shippingContact[k];
							}
						});
						$('[name="ship_to_different_address"]').prop('checked', JSON.stringify(billingAddress) !== JSON.stringify(shippingAddress)).trigger('change');
					}
				}
			},
			can_initialize_applepay: function(){
				return window.ApplePaySession && ApplePaySession.canMakePayments();
			},
			check_setup: function(e){
				if(!applepay.can_initialize_applepay()){
					applepay.hide_gateway();
				}else{
					applepay.show_gateway();
					applepay.create_button();
					if(applepay.tokenize_response){
						$(applepay.container).find(applepay.nonce_selector).val(applepay.tokenize_response.response.nonce);
						applepay.payment_gateway_changed(null, $('input[name="payment_method"]:checked').val());
						$('.bfwc-cancel-saved').trigger('click');
					}
				}
			},
			submit_error: function(error){
				$(document.body).triggerHandler('bfwc_submit_error', {error: error, element: applepay.container});
			},
			woocommerce_form_submit: function(){
				if(applepay.is_payment_method_selected()){
					return true;
				}else{
					if(applepay.payment_method_received){
						return true;
					}else{
						return false;
					}
				}
			},
			is_payment_method_selected: function(){
				if($(applepay.container).find(applepay.token_selector).length > 0){
					if($(applepay.container).find(applepay.token_selector).val() !== ''){
						return true;
					}else{
						return false;
					}
				}else{
					return false;
				}
			},
			checkout_error: function(){
				if(applepay.is_gateway_selected() && applepay.has_checkout_error()){
					applepay.payment_method_received = false;
					applepay.tokenize_response = null;
				}
			},
			is_gateway_selected: function(){
				return $('input[name="payment_method"]:checked').val() === applepay.gateway_id;
			},
			hide_gateway: function(){
				$(applepay.container).hide();
			},
			show_gateway: function(){
				$(applepay.container).show();
			},
			pre_submit_validations: function(){
				if($('[name="terms"]').length > 0 && !$('[name="terms"]').is(':checked')){
					var data = {
							element: $(applepay.container),
							error: {
								message: braintree_applepay_vars.terms.message
							}
					};
					$(document.body).triggerHandler('bfwc_submit_error', data);
					return false;
				}else{
					return true;
				}
			},
			payment_gateway_changed: function(e, payment_gateway){
				var button = $('#place_order');
				if(payment_gateway === applepay.gateway_id){
					if(applepay.is_payment_method_selected() || applepay.payment_method_received){
						applepay.$button.hide();
						button.show();
					}else{
						applepay.$button.show();
						button.hide();
					}
				}else{
					applepay.$button.hide();
				}
			},
			display_saved_methods: function(e, gateway_id){
				if(applepay.gateway_id == gateway_id){
					applepay.$button.hide();
					$("#place_order").show();
				}
			},
			display_new_payment_method_container: function(e, gateway_id){
				if(applepay.gateway_id == gateway_id){
					applepay.$button.show();
					$("#place_order").hide();
				}
			},
			get_billing_fields_array: function(){
				return ["postalAddress"];
			},
			get_shipping_fields_array: function(){
				//check if needs shipping;
				var fields = [];
				if(applepay.needs_shipping){	
					fields.push("postalAddress");
				}
				fields = fields.concat(applepay.get_apple_address_fields());
				return fields;
			},
			get_apple_address_fields: function(){
				var fields = [];
				if($("#billing_email").length){
					fields.push("email");
				}
				if($("#billing_phone").length){
					fields.push("phone");
				}
				return fields;
			},
			get_object_mappings: function(){
				return {
					"givenName": {
						get: function(prefix){
							return $(prefix + "_first_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_first_name").val(v);
						}
					},
					"familyName": {
						get: function(prefix){
							return $(prefix + "_last_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_last_name").val(v);
						}
					},
					"addressLines": {
						get: function(prefix){
							var addressLines = [];
							if($(prefix + "_address_1").val() != ''){
								addressLines.push($(prefix + "_address_1").val());
							}
							if($(prefix + "_address_2").val() != ''){
								addressLines.push($(prefix + "_address_2").val());
							}
							return addressLines;
						},
						set: function(v, prefix){
							$(prefix + "_address_1").val(v[0]);
							if(v.length == 2){
								$(prefix + "_address_2").val(v[0]);
							}
						}
					},
					"administrativeArea": {
						get: function(prefix){
							return $(prefix + "_state").val();
						},
						set: function(v, prefix){
							if(v.length == 2){
								$(prefix + "_state").val(v.toUpperCase());
							}else{
								$(prefix + '_state option').each(function(){
									var $this = $(this);
									var text = $this.text().toLowerCase();
									v = v.toLowerCase();
									if(text.indexOf(v) >= 0){
										$(prefix + "_state").val($this.val());
									}
								});
							}
						}
					},
					"locality": {
						get: function(prefix){
							return $(prefix + "_city").val();
						},
						set: function(v, prefix){
							$(prefix + "_city").val(v);
						}
					},
					"postalCode": {
						get: function(prefix){
							return $(prefix + "_postcode").val();
						},
						set: function(v, prefix){
							$(prefix + "_postcode").val(v);
						}
					},
					"phoneNumber": {
						get: function(prefix){
							return $("#billing_phone").val();
						},
						set: function(v, prefix){
							$("#billing_phone").val(v);
						}
					},
					"emailAddress": {
						get: function(prefix){
							return $("#billing_email").val();
						},
						set: function(v, prefix){
							$("#billing_email").val(v);
						}
					},
					"countryCode": {
						get: function(prefix){
							return $(prefix + "_country").val();
						},
						set: function(v, prefix){
							$(prefix + "_country").val(v);
						}
					}
				}
			},
			has_checkout_error: function(){
				return $('#bfwc_checkout_error').length > 0;
			},
			should_use_billing_address: function(){
				return applepay.needs_shipping && ($('[name="ship_to_different_address"]').length && !$('[name="ship_to_different_address"]').is(":checked"));
			},
			get_billing_contact: function(){
				var mappings = applepay.get_object_mappings();
				var billingContact = {};
				$.each(mappings, function(k, obj){
					var val = obj.get("#billing");
					if(val != null && val.length > 0){
						billingContact[k] = val;
					}
				});
				return billingContact;
			},
			get_shipping_contact: function(){
				var mappings = applepay.get_object_mappings();
				var shippingContact = {
						emailAddress: mappings.emailAddress.get(),
						phoneNumber: mappings.phoneNumber.get()
				};
				if(applepay.needs_shipping){
					$.each(mappings, function(k, obj){
						var val = obj.get("#shipping");
						if(val != null && val.length > 0){
							shippingContact[k] = val;
						}
					});
				}
				return shippingContact;
			}
	}
	
	applepay.init();
})