<?php
/**
 * @package: provesrc-plugin
 */

/**
 * Plugin Name: ProveSource
 * Description: ProveSource is a social proof marketing platform that works with your Wordpress and WooCommerce websites out of the box
 * Version: 1.3.5
 * Author: ProveSource LTD
 * Author URI: https://provesrc.com
 * License: GPLv3 or later
 * Text Domain: provesrc-plugin
 */

if (!defined('ABSPATH')) {
    die;
}

/** constants */
class PSConstants
{
    public static function options_group()
    {
        return 'provesrc_options';
    }

    public static function option_api_key()
    {
        return 'api_key';
    }
}

/* hooks */
add_action('admin_menu', 'provesrc_admin_menu'); //1.5.0
add_action('admin_init', 'provesrc_admin_init'); //2.5.0
add_action('admin_notices', 'provesrc_admin_notice_html'); //3.1.0
add_action('wp_head', 'provesrc_inject_code'); //1.2.0
// add_action('woocommerce_checkout_create_order', 'provesrc_woocommerce_order_created', 20, 2);
add_action('woocommerce_checkout_order_processed', 'provesrc_order_processed');

if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    add_action('woocommerce_created_customer', 'provesrc_woo_user_register', 999, 3);
} else {
    add_action('user_register', 'provesource_user_register', 999);
}

function provesrc_admin_menu()
{
    add_menu_page('ProveSource Settings', 'ProveSource', 'manage_options', 'provesrc', 'provesrc_menu_page_html', 'dashicons-provesrc');
}

function provesrc_admin_init()
{
    wp_enqueue_style('provesrc_admin_style', plugin_dir_url(__FILE__).'style.css');
    register_setting(PSConstants::options_group(), PSConstants::option_api_key());
    wp_register_style('dashicons-provesrc', plugin_dir_url(__FILE__).'/assets/css/dashicons-provesrc.css');
    wp_enqueue_style('dashicons-provesrc');
}

function provesrc_inject_code()
{
    $apiKey = provesrc_get_api_key(); ?>

    <!-- Start of Async ProveSource Code (Wordpress) --><script>!function(o,i){window.provesrc&&window.console&&console.error&&console.error("ProveSource is included twice in this page."),provesrc=window.provesrc={dq:[],display:function(o,i){this.dq.push({n:o,g:i})}},o._provesrcAsyncInit=function(){provesrc.init({apiKey:"<?php echo $apiKey; ?>",v:"0.0.3"})};var r=i.createElement("script");r.type="text/javascript",r.async=!0,r.src="https://cdn.provesrc.com/provesrc.js";var e=i.getElementsByTagName("script")[0];e.parentNode.insertBefore(r,e)}(window,document);</script><!-- End of Async ProveSource Code -->

    <?php
}

function provesrc_order_processed($id)
{
    $order = wc_get_order($id);
    $items = $order->get_items();
    $products = array();
    foreach ($items as $item) {
        $quantity = $item->get_quantity();
        $product = $item->get_product();
        $images_arr = wp_get_attachment_image_src($product->get_image_id(), array('72', '72'), false);
        $image = null;
        if ($images_arr !== null && $images_arr[0] !== null) {
            $image = $images_arr[0];
            if (is_ssl() && strpos($image, "https") == false) {
				$image = str_replace('http', 'https', $image);
            }
        }
        $p = array(
            'id' => $product->get_id(),
            'quantity' => (int) $quantity,
            'price' => (int) $product->get_price(),
            'name' => $product->get_name(),
            'link' => get_permalink($product->get_id()),
            'image' => $image,
        );
        array_push($products, $p);
    }
    provesrc_send_webhook($order, $products);
}

function provesource_user_register($id)
{
    $user = new WP_User($id);
    $meta = get_user_meta($id);
    if (!isset($user)) {
        return;
    }

    // provesrc_log('wp user event', $user);
    provesrc_send_user($user->user_email, $meta);
}

function provesrc_woo_user_register($id, $data, $pass)
{
    $user = new WP_User($id);
    $meta = get_user_meta($id);
    // provesrc_log('woo user event', $user);
    provesrc_send_user($data['user_email'], $meta);
}

/** hooks - END */

/** helpers */
function provesrc_send_user($email, $meta)
{
    $apiKey = provesrc_get_api_key();
    if (!isset($email) || !isset($apiKey)) {
        // provesrc_log('no email or api key');
        return;
    }

    $data = array(
        'email' => $email,
        'siteUrl' => get_site_url(),
    );

    if (isset($meta['first_name'][0])) {
        $data['firstName'] = $meta['first_name'][0];
    } elseif (isset($_POST['first_name']) && strlen($_POST['first_name']) > 0) {
        $data['firstName'] = $_POST['first_name'];
    }

    if (isset($meta['last_name'][0])) {
        $data['lastName'] = $meta['last_name'][0];
    } elseif (isset($_POST['last_name']) && strlen($_POST['last_name' > 0])) {
        $data['lastName'] = $_POST['last_name'];
    }

    if (isset($_SERVER['REMOTE_ADDR'])) {
        $data['ip'] = $_SERVER['REMOTE_ADDR'];
    }

    $headers = array(
        'Content-Type' => 'application/json',
        'Authorization' => "Bearer $apiKey",
    );

    $url = 'https://api.provesrc.com/webhooks/track/wordpress';
    $json = json_encode($data);
    // provesrc_log('sending data', $json);
    $res = wp_remote_post($url, array(
        'headers' => $headers,
        'body' => $json,
    ));
}

function provesrc_send_webhook($order, $products)
{
    $apiKey = provesrc_get_api_key();
    if (!isset($apiKey)) {
        return;
    }

    $headers = array(
        'Content-Type' => 'application/json',
        'authorization' => "Bearer $apiKey",
    );
    $data = array(
        'firstName' => $order->get_billing_first_name(),
        'lastName' => $order->get_billing_last_name(),
        'email' => $order->get_billing_email(),
        'ip' => $order->get_customer_ip_address(),
        'siteUrl' => get_site_url(),
        'total' => (int) $order->get_total(),
        'currency' => $order->get_currency(),
        'products' => $products,
    );
    $url = 'https://api.provesrc.com/webhooks/track/woocommerce';
    $res = wp_remote_post($url, array(
        'headers' => $headers,
        'body' => json_encode($data),
    ));
}

function provesrc_get_api_key()
{
    $apiKey = get_option(PSConstants::option_api_key());
    if (isset($apiKey) && strlen($apiKey) > 30) {
        $start = strpos($apiKey, '.');
        $end = strpos($apiKey, '.', $start + 1);
        $substr = substr($apiKey, $start + 1, $end - $start - 1);
        $json = json_decode(base64_decode($substr));

        if (!is_object($json) || !isset($json->accountId)) {
            return null;
        }

        return $apiKey;
    }

    return null;
}

function provesrc_menu_page_html()
{
    if (!current_user_can('manage_options')) {
        return;
    }

    $apiKey = provesrc_get_api_key(); ?>

	<div class="wrap" id="ps-settings">
		<!-- <h1><?=esc_html(get_admin_page_title()); ?></h1> -->
		<a href="https://provesrc.com">
			<img class="top-logo" src="<?php echo plugin_dir_url(__FILE__).'assets/top-logo.png'; ?>">
		</a>
		<form action="options.php" method="post">
			<?php
				settings_fields(PSConstants::options_group());
				do_settings_sections(PSConstants::options_group()); 
			?>

			<div class="ps-settings-container">
				<?php if (isset($apiKey)) { ?>
					<div class="ps-success">ProveSource is Installed</div>
					<div class="ps-warning">If you still see <strong>"waiting for data..."</strong> open your website in <strong>incognito</strong> or <strong>clear cache</strong></div>
				<?php } else { ?>
					<div class="account-link">If you don't have an account - <a href="https://console.provesrc.com/?utm_source=woocommerce&utm_medium=plugin&utm_campaign=woocommerce-signup#/signup" target="_blank">signup here!</a></div>
				<?php } ?>

				<div class="label">Your API Key:</div>
				<input type="text" placeholder="required" name="<?php echo PSConstants::option_api_key(); ?>" value="<?php echo esc_attr(get_option(PSConstants::option_api_key())); ?>" />
				<div class="m-t"><a href="https://console.provesrc.com/#/settings" target="_blank">Where is my API Key?</a></div>
			</div>

			<?php submit_button('Save'); ?>
		
        </form>
    </div>

    <?php
}

function provesrc_admin_notice_html()
{
    $apiKey = provesrc_get_api_key();
    if ($apiKey !== null) {
        return;
    }

    // $screen = get_current_screen();
    // if($screen !== null && strpos($screen->id, 'provesrc') > 0) return;

    ?>

	<div class="notice notice-error is-dismissible">
        <p class="ps-error">ProveSource is not configured! <a href="admin.php?page=provesrc">Click here</a></p>
    </div>

	<?php
}

function provesrc_log($message, $data = null)
{
    if (isset($data)) {
        error_log($message.': '.print_r($data, true));
        echo print_r($message);
    } else {
        error_log($message);
        echo $message;
    }
}

function provesrc_var_dump_str($data)
{
    ob_start();
    var_dump($data);

    return ob_get_clean();
}

/* helpers - END */

?>
