<?php
class ControllerStartupSeoUrl extends Controller {
	public function index() {

			if ($this->config->get('module_seoproml_status')) {
				$code = null;

				if (isset($this->request->get['_route_'])) {
					$route_ = $this->request->get['_route_']; 
					$tokens = explode('/', $this->request->get['_route_']);

					if (array_key_exists($tokens[0], $this->languages)) {
						$code = $tokens[0];
						$this->request->get['_route_'] = substr($this->request->get['_route_'], strlen($code) + 1);
					}

					if (trim($this->request->get['_route_']) == '' || trim($this->request->get['_route_']) == 'index.php') {
						unset($this->request->get['_route_']);
					}
				}

				$xhttprequested = isset($this->request->server['HTTP_X_REQUESTED_WITH']) && (strtolower($this->request->server['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest');

				if (!isset($code) && $xhttprequested) { 
					if (isset($this->session->data['language'])) {
						$code = $this->prefix[$this->session->data['language']];
					} elseif (isset($this->request->cookie['language'])) {
						$code = $this->prefix[$this->request->cookie['language']];
					} else {
						$code = $this->prefix[$this->config_language];
					}
				} elseif (!isset($code) && !$xhttprequested) {
					$code = $this->prefix[$this->config_language];
				}

				if (!isset($this->session->data['language']) || $this->session->data['language'] != $this->languages[$code]['code']) {
					$this->session->data['language'] = $this->languages[$code]['code'];
				}
				
				$captcha = isset($this->request->get['route']) && strripos($this->request->get['route'],'extension/captcha');
				
				if (!$xhttprequested && !$captcha) {
					setcookie('language', $this->languages[$code]['code'], time() + 60 * 60 * 24 * 30, '/',
						($this->request->server['HTTP_HOST'] != 'localhost') ? $this->request->server['HTTP_HOST'] : false);
				}
				
				$this->config->set('config_language_id', $this->languages[$code]['language_id']);
				$this->config->set('config_language', $this->languages[$code]['code']);

				$language = new Language($this->languages[$code]['code']);
				$language->load('default');
				$language->load($this->languages[$code]['code']);
				$this->registry->set('language', $language);
			}
			
		// Add rewrite to url class
		if ($this->config->get('config_seo_url')) {
			$this->url->addRewrite($this);
		}

		// Decode URL
		if (isset($this->request->get['_route_'])) {
			$parts = explode('/', $this->request->get['_route_']);

			// remove any empty arrays from trailing
			if (utf8_strlen(end($parts)) == 0) {
				array_pop($parts);
			}

			foreach ($parts as $part) {
				$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE keyword = '" . $this->db->escape($part) . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "'");

				if ($query->num_rows) {
					$url = explode('=', $query->row['query']);

					if ($url[0] == 'product_id') {
						$this->request->get['product_id'] = $url[1];
					}

					if ($url[0] == 'category_id') {
						if (!isset($this->request->get['path'])) {
							$this->request->get['path'] = $url[1];
						} else {
							$this->request->get['path'] .= '_' . $url[1];
						}
					}

					if ($url[0] == 'manufacturer_id') {
						$this->request->get['manufacturer_id'] = $url[1];
					}

					if ($url[0] == 'information_id') {
						$this->request->get['information_id'] = $url[1];
					}

					if ($query->row['query'] && $url[0] != 'information_id' && $url[0] != 'manufacturer_id' && $url[0] != 'category_id' && $url[0] != 'product_id') {
						$this->request->get['route'] = $query->row['query'];
					}
				} else {
					$this->request->get['route'] = 'error/not_found';

					break;
				}
			}

			if (!isset($this->request->get['route'])) {
				if (isset($this->request->get['product_id'])) {
					$this->request->get['route'] = 'product/product';
				} elseif (isset($this->request->get['path'])) {
					$this->request->get['route'] = 'product/category';
				} elseif (isset($this->request->get['manufacturer_id'])) {
					$this->request->get['route'] = 'product/manufacturer/info';
				} elseif (isset($this->request->get['information_id'])) {
					$this->request->get['route'] = 'information/information';
				}
			}
		}
	}

	
				public function rewrite($link, $code = '') {
					if (!$code) {
						
                    // Check if $this->session->data['language'] is set and is not null
                    if (isset($this->session->data['language']) && isset($this->prefix[$this->session->data['language']])) {
                        $code = $this->prefix[$this->session->data['language']];
                    } else {
                        // Handle the case where $this->session->data['language'] or $this->prefix is not set
                        $code = ''; // or another default value
                    }
            
					}
			
		$url_info = parse_url(str_replace('&amp;', '&', $link));

		$url = '';

		$data = array();

		parse_str($url_info['query'], $data);

		foreach ($data as $key => $value) {
			if (isset($data['route'])) {
				if (($data['route'] == 'product/product' && $key == 'product_id') || (($data['route'] == 'product/manufacturer/info' || $data['route'] == 'product/product') && $key == 'manufacturer_id') || ($data['route'] == 'information/information' && $key == 'information_id')) {
					$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE `query` = '" . $this->db->escape($key . '=' . (int)$value) . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");

					if ($query->num_rows && $query->row['keyword']) {
						$url .= '/' . $query->row['keyword'];

						unset($data[$key]);
					}
				} elseif ($key == 'path') {
					$categories = explode('_', $value);

					foreach ($categories as $category) {
						$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "seo_url WHERE `query` = 'category_id=" . (int)$category . "' AND store_id = '" . (int)$this->config->get('config_store_id') . "' AND language_id = '" . (int)$this->config->get('config_language_id') . "'");

						if ($query->num_rows && $query->row['keyword']) {
							$url .= '/' . $query->row['keyword'];
						} else {
							$url = '';

							break;
						}
					}

					unset($data[$key]);
				}
			}
		}

		if ($url) {
			unset($data['route']);

			$query = '';

			if ($data) {
				foreach ($data as $key => $value) {
					$query .= '&' . rawurlencode((string)$key) . '=' . rawurlencode((is_array($value) ? http_build_query($value) : (string)$value));
				}

				if ($query) {
					$query = '?' . str_replace('&', '&amp;', trim($query, '&'));
				}
			}

			
				
                    if (isset($this->languages[$code]) && isset($this->languages[$code]['code']) && $this->languages[$code]['code'] != $this->config_language) {
            
					return $url_info['scheme'] . '://' . $url_info['host'] . (isset($url_info['port']) ? ':' . $url_info['port'] : '') . '/' . $code . str_replace('/index.php', '', $url_info['path']) . $url . $query;
				} else{
					return $url_info['scheme'] . '://' . $url_info['host'] . (isset($url_info['port']) ? ':' . $url_info['port'] : '') . str_replace('/index.php', '', $url_info['path']) . $url . $query;
				}
			
		} else {
			
			
                    if (isset($this->languages[$code]) && isset($this->languages[$code]['code']) && $this->languages[$code]['code'] != $this->config_language) {
            
				return str_replace($url_info['scheme'] . '://' . $url_info['host'] . (isset($url_info['port']) ? ':' . $url_info['port'] : '') . '/', $url_info['scheme'] . '://' . $url_info['host'] . (isset($url_info['port']) ? ':' . $url_info['port'] : '') . '/' . $code. '/', $link);
			} else {
				return $link;
			}
			
		}
	}
}
