<?php $locale = session()->get('locale'); ?>
<nav class="mainmenu-area" data-spy="affix" data-offset-top="200">
    <div class="container-fluid">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#primary_menu">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand" href="<?php echo e(route('get-home-page')); ?>"><img src="<?php echo e(asset('/images/logo.svg')); ?>" alt="Logo"></a>
        </div>
        <div class="collapse navbar-collapse" id="primary_menu">
            <ul class="nav navbar-nav mainmenu">
                <li><a href="<?php echo e(route('get-about-page')); ?>"> <?php echo Lang::get('lang.aboutCompany'); ?> </a></li>
                <li class="dropdown">
                   <a class="dropdown-toggle" role="button" aria-expanded="false"><?php echo Lang::get('lang.business_areas'); ?></a>
                   <span class="caret" data-toggle="dropdown"></span>
                    <ul class="dropdown-menu" role="menu">
                       <li><a href="<?php echo e(route('get-smart-home-page')); ?>"><?php echo Lang::get('lang.smarthome'); ?></a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-hvac-page')); ?>"><?php echo Lang::get('lang.hvac'); ?></a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-access-control-page')); ?>"><?php echo Lang::get('lang.access-control'); ?></a></li>
                    </ul>
                </li>
                <li class="dropdown">
                   <a href="<?php echo e(route('get-products-page')); ?>" class="dropdown-toggle" role="button" aria-expanded="false"><?php echo Lang::get('lang.products'); ?></a>
                   <span class="caret" data-toggle="dropdown"></span>
                    <ul class="dropdown-menu" role="menu">
                       <li><a href="<?php echo e(route('get-bboil-rf-page')); ?>">BBoil RF</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-bboil-page')); ?>">BBoil</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-bgate-page')); ?>">PS Gate</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-ps-plug-page')); ?>">PS Plug</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-bsafe-f-page')); ?>">PS Fire</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-bsafe-w-page')); ?>">PS Water</a></li>
                       <li class="divider"></li>
                       <li><a href="<?php echo e(route('get-bsafe-a-page')); ?>">PS Alarm</a></li>
                    </ul>
                </li>
                <li><a href="<?php echo e(route('get-white-label-page')); ?>"><?php echo Lang::get('lang.white-label'); ?></a></li>
                <li><a href="#contact_page"><?php echo Lang::get('lang.contacts'); ?></a></li>
                <li><a href="<?php echo e(route('get-faq-page')); ?>"><?php echo Lang::get('lang.faq'); ?></a></li>
                <li class="nav-item dropdown">
                    <a id="navbarDropdown" class="nav-link dropdown-toggle" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                      <?php if(request()->segment(1) == 'bg'): ?>
                          <img src="<?php echo e(asset('/images/bg.png')); ?>" width="30px" height="20x"> BG
                          <?php else: ?>
                          <img src="<?php echo e(asset('/images/en.png')); ?>" width="30px" height="20x"> EN
                      <?php endif; ?> <span class="caret"></span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="/en"><img src="<?php echo e(asset('/images/en.png')); ?>" width="30px" height="20x"> EN</a>
                        <a class="dropdown-item" href="/bg"><img src="<?php echo e(asset('/images/bg.png')); ?>" width="30px" height="20x"> BG</a>
                    </div>
                </li>
            </ul>
            <?php if($currentPage == 'bboil-rf' || $currentPage == 'bboil' || $currentPage == 'bgate' || $currentPage == 'ps-plug' || $currentPage == 'bsafe-f' || $currentPage == 'bsafe-a' || $currentPage == 'bsafe-w'): ?>
            <div class="hidden-state" id="product_menu">
              <?php echo $__env->make('blocks.top-product-navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <?php endif; ?>
            <div class="right-button hidden-xs">
                <a target="_blank" href="https://sys.prosmartsystem.com/bg/"><?php echo Lang::get('lang.login'); ?></a>
            </div>
        </div>
    </div>
</nav>
<?php /**PATH /Users/milenchavdarov/Desktop/prosmart/prosmart/resources/views/layouts/partials/nav.blade.php ENDPATH**/ ?>