@extends('layouts.main')
@section('content')
<section class="section-padding-product product-heading">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-12 col-sm-12">
                <div class="page-title text-center">
                    <div class="clearfix"></div>
                    @include('blocks.top-product-navigation')
                    <div class="space-20"></div>
                    <h3 class="title color-dark-blue">PS Plug</h3>
                    <div class="space-30"></div>
                </div>
            </div>

            <div class="col-xs-12 col-md-5 col-lg-5 col-sm-5 text-center">
                <img src="{{ asset('images/plug.png') }}" />
                <div class="clearfix"></div>
            </div>
            <div class="col-xs-12 col-lg-7 col-md-7 col-sm-7">
                <h2 class="color-dark-blue">{!! Lang::get('lang.psplug_page_heading') !!}</h2>
                <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-6">
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list1') !!}</li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list2') !!}</li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list3') !!}</li>
                </ul>
                <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-9">
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list4') !!}</li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list5') !!}</li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list6') !!}</li>
                    <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_page_list7') !!}</li>
                </ul>
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-12">
        <div class="page-title text-center full-width-box">

            <h2 class="facts-heading">{!! Lang::get('lang.psplug_page_accent1') !!}
                </h3>

        </div>
    </div>
</div>
<!-- About-Area-End -->
<!-- Feature-Area -->
<section class="feature-area section-padding-normal" id="">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="page-title text-center">
                    <h3 class="title">{!! Lang::get('lang.features') !!}</h3>
                    <div class="space-30"></div>
                </div>
            </div>
        </div>
        <div class="row" id="">
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                  <img src="{{asset('/images/icons/savings.svg')}}" alt="">
                  <div class="box-strengths_contents">
                      <h4>{!! Lang::get('lang.savings') !!}</h4>
                  </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                  <img src="{{asset('/images/icons/realtime.png')}}" alt="">
                  <div class="box-strengths_contents">
                      <h4>{!! Lang::get('lang.real_time_system') !!}</h4>
                  </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                  <img src="{{asset('/images/icons/smart-home.svg')}}" alt="">
                  <div class="box-strengths_contents">
                      <h4>{!! Lang::get('lang.remote_control') !!}</h4>
                  </div>
                </div>
                <div class="space-10"></div>
            </div>
        </div>
        <div class="row" id="">
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/mortgage.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.optimize_work') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/maintenance.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.fast_installation_plug') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <div class="box-strengths text-center">
                    <img src="{{asset('/images/icons/calendar.svg')}}" alt="">
                    <div class="box-strengths_contents">
                        <h4>{!! Lang::get('lang.schedule_plug') !!}</h4>
                    </div>
                </div>
                <div class="space-10"></div>
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-12">
        <div class="page-title text-center full-width-box">

            <h2 class="facts-heading">{!! Lang::get('lang.psplug_page_accent2') !!}</h3>

        </div>
    </div>
</div>
<!-- How-To-Use -->
<section class="section-padding">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-7 col-md-7">
                <div class="page-title">
                    <h3 class="title wow fadeInUp" data-wow-delay="0.2s">{!! Lang::get('lang.specifications') !!}</h3>
                    <div class="space-10"></div>
                </div>
                <!-- <div class="space-20"></div> -->
                <div class="desc wow fadeInUp" data-wow-delay="0.6s">
                    <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-6">
                        <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification1') !!}</li>
                        <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification2') !!}</li>
                        <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification3') !!}</li>
                        <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification4') !!}</li>
                        <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification5') !!}</li>
                    </ul>
                    <ul style="list-style-type:none;" class="col-xs-12 col-lg-6 col-md-6 col-sm-9">
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification6') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification7') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification8') !!}</li>
                      <li><i class="fa fa-angle-right"></i> {!! Lang::get('lang.psplug_specification9') !!}</li>
                    </ul>
                </div>
                <div class="space-50"></div>
                @if(request()->segment(1) == 'en')
                <a target="_blank" href="{{asset('/images/usermanuals/User_manual_PS_Plug_EN.pdf')}}" class="bttn-default wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.UserManual') !!}</a>
                @else
                <a target="_blank" href="{{asset('/images/usermanuals/User_manual_PS_Plug_BG.pdf')}}" class="bttn-default wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.UserManual') !!}</a>
                @endif
            </div>
            <div class="col-xs-12 col-sm-5 col-md-5">
                <img class="special_image" src="{{ asset('images/products/ps-plug/wallpaper_ps_plug_2.png') }}" />
            </div>
        </div>
    </div>
</section>
<div class="darkbluebg">
    <div class="col-xs-12 col-sm-8">
        <div class="page-title text-center full-width-box">
            <div class="space-30"></div>
            <h2 class="">{!! Lang::get('lang.need_more_info') !!}</h3>
                <div class="space-20"></div>
        </div>
    </div>
    <div class="col-xs-12 col-sm-4">
        <div class="page-title text-center full-width-box">
            <div class="space-30"></div>
            <a class="bttn-cta" href="{{{route('get-accelerate-your-business-page')}}}">{!! Lang::get('lang.contact_cta') !!}</a>
            <div class="space-20"></div>
        </div>
    </div>
</div>
@endsection
