@extends('layouts.main')
@section('content')
<header class="home-area overlay" id="home_page">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 hidden-sm col-md-5">
                <figure class="mobile-image wow fadeInUp" data-wow-delay="0.2s">
                    <img src="images/header-mobile.png" alt="">
                </figure>
            </div>
            <div class="col-xs-12 col-md-7">
                <div class="space-80 hidden-xs"></div>
                <h1 class="wow fadeInUp" data-wow-delay="0.4s">
                  {!!  Lang::get('lang.main-heading-home') !!} </h1>
                <div class="space-20"></div>
                <p>{!!  Lang::get('lang.main-description-home') !!}</p>
                <div class="desc wow fadeInUp" data-wow-delay="0.6s">
                    <p></p>
                </div>
                <div class="space-20"></div>
                <a href="#" class="bttn-white wow fadeInUp" data-wow-delay="0.8s">{!!  Lang::get('lang.demo') !!}</a>
                <a href="/products" class="bttn-white wow fadeInUp" data-wow-delay="0.8s">{!!  Lang::get('lang.all-products') !!}</a>
            </div>
        </div>
    </div>
</header>
<section class="section-padding" id="home">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-10 col-md-offset-1">
                <div class="page-title text-center">
                    <img src="{{asset('images/about-logo.svg')}}" alt="Logo">
                    <div class="space-20"></div>
                    <h5 class="title">{!!  Lang::get('lang.aboutProsmart') !!}</h5>
                    <div class="space-30"></div>
                    <h3 class="">{!!  Lang::get('lang.home-aboutdescr') !!}</h3>
                    <div class="space-20"></div>
                    <p></p>
                </div>
            </div>
        </div>
    </div>
    <div class="product-wrapper">
        <div class="product-list" id="product-list">
            <a class="active" data-target="bboil-rf">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px"
                     height="28px" viewBox="0 0 32 28" version="1.1">
                    <defs>
                        <polygon id="path-1"
                                 points="0 4.50476071 0 9 8.99048214 9 8.99048214 0.00952142857 0 0.00952142857"/>
                    </defs>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="index" transform="translate(-266.000000, -116.000000)">
                            <g id="products-2" transform="translate(-1.000000, 27.000000)">
                                <g id="BBOIL-RF" transform="translate(259.000000, 88.000000)">
                                    <g id="icon" transform="translate(9.000000, 1.000000)">
                                        <g id="t-copy">
                                            <path d="M30.5,4.57806404 L24.5000665,0.599917044 L18.5,4.57806721 L18.5,14.5 L30.5,14.5 L30.5,4.57806404 Z"
                                                  id="Fill-9" stroke="#E2948E"/>
                                            <path d="M25.5,11.5 L27.5,11.5 L27.5,9.5 L25.5,9.5 L25.5,11.5 Z"
                                                  id="Fill-13" stroke="#E2948E"/>
                                            <path d="M25.5,7.5 L27.5,7.5 L27.5,5.5 L25.5,5.5 L25.5,7.5 Z"
                                                  id="Fill-13-Copy" stroke="#E2948E"/>
                                            <path d="M21.5,7.5 L23.5,7.5 L23.5,5.5 L21.5,5.5 L21.5,7.5 Z"
                                                  id="Fill-13-Copy-2" stroke="#E2948E"/>
                                            <path d="M21.5,11.5 L23.5,11.5 L23.5,9.5 L21.5,9.5 L21.5,11.5 Z"
                                                  id="Fill-13-Copy-3" stroke="#E2948E"/>
                                            <g id="tt" transform="translate(0.000000, 1.000000)" stroke="#E2948E"
                                               stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M4.48803191,22.5 C6.96579953,22.5 8.97606383,20.484375 8.97606383,18 C8.97606383,16.6875 8.41505984,15.46875 7.48005319,14.625 L7.48005319,3 C7.48005319,1.359375 6.12429355,0 4.48803191,0 C2.85177028,0 1.49601064,1.359375 1.49601064,3 L1.49601064,14.625 C0.561003989,15.46875 0,16.6875 0,18 C0,20.484375 2.0102643,22.5 4.48803191,22.5 Z"
                                                      id="Stroke-1"/>
                                                <path d="M4.48803191,16.5 C5.3295379,16.5 5.98404255,17.15625 5.98404255,18 C5.98404255,18.84375 5.3295379,19.5 4.48803191,19.5 C3.64652593,19.5 2.99202128,18.84375 2.99202128,18 C2.99202128,17.15625 3.64652593,16.5 4.48803191,16.5 Z"
                                                      id="Stroke-3" stroke-width="2"/>
                                            </g>
                                            <path d="M4.42819149,17.5159574 L4.42819149,9.64095745" id="Stroke-6"
                                                  stroke="#E2948E" stroke-width="2" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M4.5,25.5 L4.5,27.5" id="Line-5" stroke="#E2948E"
                                                  stroke-linecap="square"/>
                                            <path d="M4.5,27.5 L24.5,27.5" id="Line-6" stroke="#E2948E"
                                                  stroke-linecap="square"/>
                                            <g id="wave"
                                               transform="translate(24.500000, 20.500000) rotate(-45.000000) translate(-24.500000, -20.500000) translate(20.000000, 16.000000)">
                                                <path d="M0,3.51428214 C3.07733929,3.51428214 5.48571429,5.92281786 5.48571429,8.99999643"
                                                      id="Stroke-1" stroke="#E2948E"/>
                                                <g id="Group-5">
                                                    <mask id="mask-2" fill="white">
                                                        <use xlink:href="#path-1"/>
                                                    </mask>
                                                    <g id="Clip-4"/>
                                                    <path d="M0,0.00952142857 C4.98726786,0.00952142857 8.99048214,4.01287857 8.99048214,9.00000357"
                                                          id="Stroke-3" stroke="#E2948E" mask="url(#mask-2)"/>
                                                </g>
                                                <path d="M1.98094821,7.93333214 C1.98094821,8.43827857 1.57160893,8.84761786 1.0666625,8.84761786 C0.561716071,8.84761786 0.152376786,8.43827857 0.152376786,7.93333214 C0.152376786,7.42838571 0.561716071,7.01904643 1.0666625,7.01904643 C1.57160893,7.01904643 1.98094821,7.42838571 1.98094821,7.93333214 Z"
                                                      id="Stroke-6" stroke="#E2948E"/>
                                            </g>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>
                BBoil RF
            </a>
            <a data-target="bboil">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="32px"
                     height="28px" viewBox="0 0 32 28" version="1.1">
                    <defs/>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="index" transform="translate(-396.000000, -116.000000)" stroke="#D8D8D8">
                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                <g id="BBOIL" transform="translate(139.000000, 0.000000)">
                                    <g id="icon" transform="translate(0.000000, 1.000000)">
                                        <g id="t">
                                            <path d="M30.5,4.57806404 L24.5000665,0.599917044 L18.5,4.57806721 L18.5,14.5 L30.5,14.5 L30.5,4.57806404 Z"
                                                  id="Fill-9"/>
                                            <path d="M25.5,11.5 L27.5,11.5 L27.5,9.5 L25.5,9.5 L25.5,11.5 Z"
                                                  id="Fill-13"/>
                                            <path d="M25.5,7.5 L27.5,7.5 L27.5,5.5 L25.5,5.5 L25.5,7.5 Z"
                                                  id="Fill-13-Copy"/>
                                            <path d="M21.5,7.5 L23.5,7.5 L23.5,5.5 L21.5,5.5 L21.5,7.5 Z"
                                                  id="Fill-13-Copy-2"/>
                                            <path d="M21.5,11.5 L23.5,11.5 L23.5,9.5 L21.5,9.5 L21.5,11.5 Z"
                                                  id="Fill-13-Copy-3"/>
                                            <g id="tt" transform="translate(0.000000, 1.000000)"
                                               stroke-linecap="round" stroke-linejoin="round">
                                                <path d="M4.48803191,22.5 C6.96579953,22.5 8.97606383,20.484375 8.97606383,18 C8.97606383,16.6875 8.41505984,15.46875 7.48005319,14.625 L7.48005319,3 C7.48005319,1.359375 6.12429355,0 4.48803191,0 C2.85177028,0 1.49601064,1.359375 1.49601064,3 L1.49601064,14.625 C0.561003989,15.46875 0,16.6875 0,18 C0,20.484375 2.0102643,22.5 4.48803191,22.5 Z"
                                                      id="Stroke-1"/>
                                                <path d="M4.48803191,16.5 C5.3295379,16.5 5.98404255,17.15625 5.98404255,18 C5.98404255,18.84375 5.3295379,19.5 4.48803191,19.5 C3.64652593,19.5 2.99202128,18.84375 2.99202128,18 C2.99202128,17.15625 3.64652593,16.5 4.48803191,16.5 Z"
                                                      id="Stroke-3" stroke-width="2"/>
                                            </g>
                                            <path d="M4.42819149,17.5159574 L4.42819149,9.64095745" id="Stroke-6"
                                                  stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                            <path d="M4.5,25.5 L4.5,27.5" id="Line-5" stroke-linecap="square"/>
                                            <path d="M4.5,27.5 L24.5,27.5" id="Line-6" stroke-linecap="square"/>
                                            <path d="M24.5,16.5 L24.5,26.5" id="Line-7" stroke-linecap="square"/>
                                        </g>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>BBoil</a>
            <a data-target="bgate">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="26px"
                     height="30px" viewBox="0 0 26 30" version="1.1">
                    <defs/>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"
                       stroke-linecap="round" stroke-linejoin="round">
                        <g id="index" transform="translate(-539.000000, -115.000000)" stroke="#D8D8D8">
                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                <g id="PS-Gate" transform="translate(260.000000, 1.000000)">
                                    <g id="icon" transform="translate(22.000000, 0.000000)">
                                        <path d="M9.75068699,12.1788618 L9.75068699,23.1056911 C9.75068699,25.7877724 7.5764187,27.9620407 4.8943374,27.9620407 C2.21219919,27.9620407 0.0379308943,25.7877724 0.0379308943,23.1056911 L0.0379308943,4.89430894 C0.0379308943,2.21222764 2.21219919,0.0379593496 4.8943374,0.0379593496 C6.62880081,0.0372195122 8.23191463,0.96195935 9.09963008,2.46382927"
                                              id="Stroke-1" stroke-width="2"/>
                                        <path d="M3.68020732,7.32248374 L3.68020732,7.32248374 C3.68020732,8.66352439 4.76736992,9.75068699 6.10841057,9.75068699 L21.8915894,9.75068699 C23.2326301,9.75068699 24.3197927,8.66352439 24.3197927,7.32248374 C24.3197927,5.98144309 23.2326301,4.89428049 21.8915894,4.89428049 L6.10841057,4.89428049 C4.76736992,4.89428049 3.68020732,5.98144309 3.68020732,7.32248374 Z"
                                              id="Stroke-3"/>
                                        <path d="M6.10841057,19.4634146 C6.10841057,20.133935 5.56485772,20.6774878 4.8943374,20.6774878 C4.22376016,20.6774878 3.68020732,20.133935 3.68020732,19.4634146 C3.68020732,18.7928943 4.22376016,18.2493415 4.8943374,18.2493415 C5.56485772,18.2493415 6.10841057,18.7928943 6.10841057,19.4634146 Z"
                                              id="Stroke-5"/>
                                        <path d="M4.89430894,20.6774878 L4.89430894,23.1056911" id="Stroke-8"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>PS Gate</a>
            <a data-target="ps-plug">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1"
                     width="30px" height="30px" id="Capa_1" x="0px" y="0px" viewBox="0 0 19.1 26.9"
                     style="enable-background:new 0 0 19.1 26.9;" xml:space="preserve">
                        <g>
                            <g id="_x32_5_1_">
                                <g>
                                    <path class="st0-plug"
                                          d="M18.6,6.7h-2.4V1.9c0-1-0.8-1.9-1.9-1.9c-1,0-1.9,0.9-1.9,1.9v4.8H7.2V1.9c0-1-0.8-1.9-1.9-1.9     c-1,0-1.9,0.9-1.9,1.9v4.8H0.5C0.2,6.7,0,6.9,0,7.2v7.9c0,1.7,1.4,3,3,3h3.7c0,0.1,0,0.1,0,0.2v8.1c0,0.3,0.2,0.5,0.5,0.5     c0.3,0,0.5-0.2,0.5-0.5v-8.1c0-0.1,0-0.1,0-0.2h3.9c0,0.1,0,0.1,0,0.2v5.2c0,0.3,0.2,0.5,0.5,0.5c0.3,0,0.5-0.2,0.5-0.5v-5.2     c0-0.1,0-0.1,0-0.2H16c1.7,0,3-1.4,3-3V7.2C19.1,6.9,18.9,6.7,18.6,6.7z M13.4,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9     v4.8h-1.9V1.9z M4.3,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9v4.8H4.3C4.3,6.7,4.3,1.9,4.3,1.9z M18.1,15.1     c0,1.2-0.9,2.1-2.1,2.1H3c-1.2,0-2.1-0.9-2.1-2.1V7.6h17.2L18.1,15.1L18.1,15.1z"/>
                                </g>
                            </g>
                        </g>
                    </svg>
                <br/>PS Plug</a>
            <a data-target="bsafe-f">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                     height="29px" viewBox="0 0 25 29" version="1.1">
                    <defs/>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="index" transform="translate(-668.000000, -117.000000)" stroke="#D8D8D8">
                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                <g id="PF-Safe" transform="translate(396.000000, 3.000000)">
                                    <g id="icon-copy-2" transform="translate(15.000000, 0.000000)">
                                        <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                              id="Fill-1" fill="#D8D8D8"/>
                                        <path d="M10.5231897,4 C10.2812396,6.51462069 9.24930366,8.88821065 7.5751895,10.7807088 C5.06346879,13.5867319 5.50228195,17.5995447 9.2755256,18.7273631 C7.7133813,16.9844736 9.11779708,13.3601059 9.11779708,13.3601059 C9.88033987,13.3940815 10.5289591,13.9270067 10.709857,14.6682423 C11.4930354,13.3814437 11.9342907,11.9159146 11.9917103,10.4107626 C15.4403696,14.6284057 14.8088145,17.4874527 13.5109044,18.8074637 C17.9232431,17.6873073 19.3523546,12.5585812 10.5231897,4 Z"
                                              id="Page-1" stroke-linecap="round" stroke-linejoin="round"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>PS Fire</a>
            <a data-target="bsafe-w">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                     height="29px" viewBox="0 0 25 29" version="1.1">
                    <defs/>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="index" transform="translate(-806.000000, -116.000000)" fill="#D8D8D8">
                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                <g id="PW-Safe" transform="translate(532.000000, 2.000000)">
                                    <g id="icon" transform="translate(17.000000, 0.000000)">
                                        <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                              id="Fill-1" stroke="#D8D8D8"/>
                                        <path d="M11.25,19.75 C8.28841947,19.75 6,17.5187295 6,14.63125 C6,13.9749795 6.13459435,13.3187705 6.40384615,12.7937295 L6.40384615,12.6625 C6.5384405,12.5312705 6.5384405,12.26875 6.67309796,12.1375205 L10.7115595,4.26252051 C10.7115595,4.13122949 10.9807482,4 11.25,4 C11.3845944,4 11.6538462,4.13122949 11.7885036,4.26252051 L15.8269651,12.1375205 C15.9615595,12.26875 16.0961538,12.5312705 16.0961538,12.6625 C16.3654056,13.3187705 16.5,13.9749795 16.5,14.63125 C16.5,17.3875 14.0769231,19.75 11.25,19.75 M7.48079026,13.05625 L7.48079026,13.05625 C7.34613281,13.5812295 7.21153846,14.1062705 7.21153846,14.63125 C7.21153846,16.862459 9.09617488,18.56875 11.25,18.56875 C13.5384826,18.56875 15.2884615,16.862459 15.2884615,14.63125 C15.2884615,14.1062705 15.1538672,13.5812295 15.0192097,13.05625 C14.8846154,12.924959 14.8846154,12.7937295 14.7499579,12.6625 L11.25,5.83745898 L7.74997897,12.6625 C7.74997897,12.7937295 7.61538462,12.924959 7.48079026,13.05625"
                                              id="Fill-3"/>
                                        <path d="M10.625,17.625 C9.18124077,17.625 8,16.4437592 8,15 L9.18124077,15 C9.18124077,15.7875554 9.83750615,16.4437592 10.625,16.4437592 L10.625,17.625 Z"
                                              id="Fill-5"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>PS Water</a>
            <a data-target="bsafe-a">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="25px"
                     height="29px" viewBox="0 0 25 29" version="1.1">
                    <defs/>
                    <g id="Page-1" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="index" transform="translate(-944.000000, -116.000000)" fill="#D8D8D8">
                            <g id="products-2" transform="translate(258.000000, 115.000000)">
                                <g id="PA-Safe" transform="translate(672.000000, 2.000000)">
                                    <g id="icon-copy-4" transform="translate(15.000000, 0.000000)">
                                        <path d="M11.2640823,27 L11.0109375,27 C4.42970728,24.613916 0,18.2092695 0,11.3023174 L0,3.76743912 C0,1.25585228 5.6953125,0 11.390625,0 C17.0859375,0 22.78125,1.25585228 22.78125,3.76743912 L22.78125,11.3023174 C22.78125,18.33489 18.225,24.6139748 11.6437698,27 L11.2640823,27 Z M11.2640823,1.00461119 C5.06253955,1.00461119 1.01251978,2.63720739 1.01251978,3.64187744 L1.01251978,11.1767557 C1.01251978,17.7069639 5.18908228,23.4837431 11.2640823,25.7441477 C17.3390823,23.4837431 21.5156448,17.7069639 21.5156448,11.1767557 L21.5156448,3.64187744 C21.5156448,2.63720739 17.5922271,1.00461119 11.2640823,1.00461119 L11.2640823,1.00461119 Z"
                                              id="Fill-1" stroke="#D8D8D8"/>
                                        <path d="M9,18 C9.27427432,18.867318 10.1225529,19.5 11.1270083,19.5 C12.126143,19.5 12.9711353,18.8743368 13.25,18.0136422 C12.5216447,18.1151679 11.7963148,18.1647445 11.1708254,18.1647445 C10.5188892,18.165041 9.75876649,18.1103239 9,18 M17.4880588,14.5612033 C17.3385726,13.7564575 17.1046587,13.2964369 16.8781126,12.8516002 C16.593366,12.2919789 16.2982397,11.7132733 16.1345741,10.1408824 C15.8339799,7.25873063 14.5979156,5.5890607 12.4628953,5.15114265 C12.4251299,4.50998345 11.8991944,4 11.2498146,4 C10.5857457,4 10.0476696,4.53324683 10.0331658,5.19562632 C8.62912646,5.57341247 6.69720537,6.78324756 6.30504744,10.5414676 C6.14490355,12.0753648 5.89435435,12.4978668 5.62934771,12.9448395 C5.41248618,13.3102278 5.16717317,13.7241395 5.01180208,14.5612033 C4.97361962,14.768995 5.02908613,14.9826837 5.16365148,15.1448309 C6.34869778,16.576295 9.66306475,16.9545455 11.2500463,16.9545455 C12.8367961,16.9545455 16.1513948,16.5760628 17.3369508,15.1450631 C17.4710064,14.9824516 17.5265193,14.7687628 17.4880588,14.5612033 M11.2492858,16.0181406 C9.43101444,16.0181406 7.12330319,15.5675201 6.19047619,14.8746368 C6.2939102,14.5103064 6.42049373,14.2970698 6.57131036,14.043029 C6.90771716,13.4770922 7.28874835,12.8354114 7.49330142,10.8779422 C7.90230904,6.96532008 10.0224107,6.38095238 11.2492858,6.38095238 C12.770209,6.38095238 14.564198,6.8439423 14.9414859,10.4527997 C15.1450046,12.4007084 15.5398763,13.1757915 15.8888922,13.8591144 C16.0578836,14.1903776 16.199342,14.4676788 16.3095238,14.8734048 C15.3772386,15.5672737 13.068296,16.0181406 11.2492858,16.0181406"
                                              id="Page-1"/>
                                    </g>
                                </g>
                            </g>
                        </g>
                    </g>
                </svg>
                <br/>PS Alarm</a>
            </ul>
        </div>
        <div class="product-content margin-auto">
            <a href="{{{route('get-bboil-rf-page')}}}"
               class="product no-decoration color-dark-blue">
                <div id="bboil-rf" class="product-description active col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">BBoil RF</p>
                    <p>
                        {!! Lang::get('lang.layer2RfMsg1') !!}
                    </p>
                    <p>
                        {!! Lang::get('lang.layer2RfMsg2') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="bboil" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">BBoil</p>
                    <p>
                        {!! Lang::get('lang.layer2BoilMsg1') !!}
                    </p>
                    <p>
                        {!! Lang::get('lang.layer2BoilMsg2') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="bgate" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">PS Gate</p>
                    <p>
                        {!! Lang::get('lang.layer2GateMsg1') !!}
                    </p>
                    <p>
                        {!! Lang::get('lang.layer2GateMsg2') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="ps-plug" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">PS Plug</p>
                    <p>
                        {!! Lang::get('lang.layer2PSPlugMsg1') !!}
                    </p>
                    <p>
                        {!! Lang::get('lang.layer2PSPlugMsg2') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="bsafe-f" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">PS Fire</p>
                    <p>
                        {!! Lang::get('lang.layer2BSafeFMsg1') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="bsafe-w" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">PS Water</p>
                    <p>
                        {!! Lang::get('lang.layer2BSafeWMsg1') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div id="bsafe-a" class="product-description col-lg-4 col-md-4 col-sm-12">
                    <p class="color-dark-blue font-30 bold">PS Alarm</p>
                    <p>
                        {!! Lang::get('lang.layer2BSafeAMsg1') !!}
                    </p>
                    <p class="text-center visible-md visible-lg visible-xs"><br/><br/>
                        <span class="buy-btn">
                            {!! Lang::get('lang.seeMore') !!}
                    </span>
                    </p>
                    @include('blocks.banner-device-compatibility')
                </div>
                <div class="product-image col-lg-8 col-md-8 col-sm-12">
                    @include('banners.house')
                </div>
                <div class="clearfix"></div>
            </a>

        </div>
    </div>
</section>
<div class="clearfix"></div>
<!-- About-Area-End -->
<!-- Progress-Area -->
<section class="progress-area gray-bg" id="progress_page">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-6">
                <div class="page-title section-padding">
                    <h3 class="dark-color wow fadeInUp" data-wow-delay="0.4s">{!! Lang::get('lang.white-label-products') !!}</h3>
                    <div class="space-20"></div>
                    <div class="desc wow fadeInUp" data-wow-delay="0.6s">
                        <p>{!! Lang::get('lang.white-label-products-description') !!}</p>
                    </div>
                    <div class="space-50"></div>
                    <a href="{{{route('get-white-label-page')}}}" class="bttn-default wow fadeInUp" data-wow-delay="0.8s">{!! Lang::get('lang.learn_more') !!}</a>
                </div>
            </div>
            <div class="col-xs-12 col-md-6">
                <figure class="mobile-image">
                    <img src="{{asset('/images/progress-phone.png')}}" alt="">
                </figure>
            </div>
        </div>
    </div>
</section>
<!-- Progress-Area-End -->
<!-- Video-Area -->
<section class="video-area section-padding-normal">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-md-8 col-md-offset-2 text-center">
              <div class="space-50"></div>
              <h3 class="dark-color wow fadeInUp" data-wow-delay="0.4s">{!! Lang::get('lang.video_heading') !!}</h3>
              <div class="space-50"></div>
                <div class="video-photo">
                    <img src="images/video-bg-new.jpg" alt="">
                    <a href="https://www.youtube.com/watch?v=UFjNiTp6eUI" class="popup video-button">
                        <img src="images/youtube.png" alt="">
                    </a>
                    <div class="space-50"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Video-Area-End -->
<!-- Feature-Area -->
<section class="feature-area section-padding-top" id="home-features">
    <div class="container">
        <div class="row">
            <div class="col-xs-12 col-sm-12">
                <div class="page-title text-center">
                    <h3 class="title">{!! Lang::get('lang.features_heading') !!}</h3>
                    <div class="space-10"></div>
                    <h4>{!! Lang::get('lang.features_description') !!}</h4>
                    <div class="space-60"></div>
                    <h4 class="title">{!! Lang::get('lang.features_subheading') !!}</h4>
                    <div class="space-20"></div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12 col-sm-4 col-md-4">
              <div class="box-icon">
                <img src="{{asset('/images/3.png')}}" alt="">
              </div>
                <h3>{!! Lang::get('lang.smarthome') !!}</h3>
                <p>{!! Lang::get('lang.smarthome_description') !!}</p>
                <a class="bttn-white" href="{{{route('get-smart-home-page')}}}">{!! Lang::get('lang.learn_more') !!}</a>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <img src="{{asset('/images/2.png')}}" alt="">
                <h3>{!! Lang::get('lang.hvac') !!}</h3>
                <p>{!! Lang::get('lang.hvac_description') !!}</p>
                <a class="bttn-white" href="{{{route('get-hvac-page')}}}">{!! Lang::get('lang.learn_more') !!}</a>
            </div>
            <div class="col-xs-12 col-sm-4 col-md-4">
                <img src="{{asset('/images/1.png')}}" alt="">
                <h3>{!! Lang::get('lang.access-control') !!}</h3>
                <p>{!! Lang::get('lang.access-control-description') !!}</p>
                <a class="bttn-white" href="{{{route('get-access-control-page')}}}">{!! Lang::get('lang.learn_more') !!}</a>
            </div>
            <div class="col-xs-12 col-sm-12 col-sm-12 learn-more">
              <div class="space-40"></div>
                <h3><a href="{{{route('get-products-page')}}}">{!! Lang::get('lang.feature_cta') !!}</a></h3>
            </div>
        </div>
    </div>
</section>
<!-- Testimonial-Area -->
<section class="testimonial-area" id="testimonial_page">
    <div class="container">
        <div class="row">
            <div class="col-xs-12">
                <div class="page-title text-center">
                  <img src="{{asset('images/about-logo.svg')}}" alt="Logo">
                  <div class="space-20"></div>
                    <h5 class="title">{!! Lang::get('lang.testimonials') !!}</h5>
                    <h3 class="dark-color">{!! Lang::get('lang.testimonials_description') !!}</h3>
                    <div class="space-60"></div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="team-slide">
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_1_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_1_description') !!}</p>
                    </div>
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_2_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_2_description') !!}</p>
                    </div>
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_3_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_3_description') !!}</p>
                    </div>
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_4_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_4_description') !!}</p>
                    </div>
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_5_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_5_description') !!}</p>
                    </div>
                    <div class="team-box">
                        <h6 class="position">⭐⭐⭐⭐⭐</h6>
                        <h4>{!! Lang::get('lang.testimonial_6_author') !!}</h4>
                        <p>{!! Lang::get('lang.testimonial_6_description') !!}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Testimonial-Area-End -->
@endsection
