@extends('layouts.master')

@section('title', 'PS Plug - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')

    <script type="text/javascript">
        $(document).ready(function () {
            @if(Session::get('ShowCartBox'))
            $('#order-modal').modal('show');
            @if(config('app.locale') == 'bg')
            getDeliveryPrice($('select[data-action="get-delivery-price"]').val());
            @endif
            @endif

            @if(Session::has('transaction'))
            $('#modal-success').modal('show');
            @endif

            @if($errors->has('exception'))
            $('#modal-error').modal('show');
            @endif
        });

    </script>
    <section class="layer-one col-lg-12 col-md-12 col-sm-12 clear-left-right-padding text-center">
        <div class="main-menu-box">
            <div class="col-lg-3 col-md-3 col-sm-3 clear-left-padding">
                <a href="{{url().'/'.App::getLocale()}}" class="logo-box pull-left no-decoration">
                    <img src="{{ asset('images/logo_40.png') }}" width="40" height="40" class="standart-margin-right"
                         style="margin-top:-5px"/>
                    <div class="color-dark-blue font-22 display-inline-block" style="margin-top: 10px">
                        proSmart
                    </div>
                </a>
            </div>
            <div class="col-lg-6 col-md-6 visible-lg visible-md">
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.aboutCompany') !!}</a>
                <a
                        @if(App::getLocale() == 'bg')
                        href="http://bboilrf.com/forum/"
                        @elseif(App::getLocale() == 'ru')
                        href="http://bboilrf.com/forum-ru/"
                        @else
                        href="http://bboilrf.com/forum-en/"
                        @endif

                        target="_blank" class="color-dark-blue font-16 standart-margin-right line-height-50">
                    {!! Lang::get('lang.forum') !!}</a>
                <a href="{{url().'/'.App::getLocale()}}#contacts"
                   class="cursor-pointer color-dark-blue font-16 standart-margin-righ line-height-50t">
                    {!! Lang::get('lang.contacts') !!}</a>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-5 pull-right clear-left-right-padding margin-minus-1-sm">
                <a target="_blank" href="https://sys.prosmartsystem.com/{{App::getLocale()}}/"
                   class="login-btn pull-right" style="background-color: #6a89d5;">
                    {!! Lang::get('lang.login') !!}
                </a>
                <a target="_blank" href="https://sys.prosmartsystem.com?demo={{$demoEmail}}"
                   class="login-btn pull-right">
                    {!! Lang::get('lang.demo') !!}
                </a>
                <div class="lang-btn pull-right">
                    @if(App::getLocale() == 'bg')
                        Български
                    @elseif(App::getLocale() == 'en')
                        English
                    @elseif(App::getLocale() == 'ru')
                        Русский
                    @elseif(App::getLocale() == 'de')
                        Deutsch
                    @elseif(App::getLocale() == 'fr')
                        Français
                    @elseif(App::getLocale() == 'hu')
                        Magyar
                    @elseif(App::getLocale() == 'gr')
                        Ελληνικά
                    @elseif(App::getLocale() == 'pl')
                        Polski
                    @elseif(App::getLocale() == 'mk')
                        Македонски
                    @endif
                    <ul class="lang-menu">
                        @if(App::getLocale() != 'bg')
                            <li>
                                <a href="{{url().'/bg/ps-plug'}}">Български</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'en')
                            <li>
                                <a href="{{url().'/en/ps-plug'}}">English</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'ru')
                            <li>
                                <a href="{{url().'/ru/ps-plug'}}">Русский</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'de')
                            <li>
                                <a href="{{url().'/de/ps-plug'}}">Deutsch</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'fr')
                            <li>
                                <a href="{{url().'/fr/ps-plug'}}">Français</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'pl')
                            <li>
                                <a href="{{url().'/pl/ps-plug'}}">Polski</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'hu')
                            <li>
                                <a href="{{url().'/hu/ps-plug'}}">Magyar</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'gr')
                            <li>
                                <a href="{{url().'/gr/ps-plug'}}">Ελληνικά</a>
                            </li>
                        @endif
                        @if(App::getLocale() != 'mk')
                            <li>
                                <a href="{{url().'/mk/ps-plug'}}">Македонски</a>
                            </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
    </section>

    <div class="clearfix"></div>
    @include('blocks.top-product-navigation')
    <div class="clearfix"></div>

    <section
            class="layer-two col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding standart-padding-bottom standart-margin-bottom">
        <div class="layer-two-header" id="layer-two-header">
            <div class="col-lg-4 col-lg-offset-4 col-md-4 col-md-offset-4 col-sm-12 col-xs-12 clear-left-right-padding">
                <ul class="col-lg-12 col-md-12 clear-left-right-padding">
                    <li class="tab-left col-lg-12 col-md-12 col-sm-12 col-xs-12 clear-left-right-padding">
                        <a id="layer-two-boil-btn" class="active">
                            <div class="tab-content">
                                <svg width="50px" height="50px" xmlns="http://www.w3.org/2000/svg" version="1.1"
                                     id="Capa_1" x="0px" y="0px" viewBox="0 0 19.1 26.9"
                                     style="enable-background:new 0 0 19.1 26.9; float:left;" xml:space="preserve">
                                    <style type="text/css">
                                        .st0-ps-plug {
                                            fill: #E2948E;
                                        }
                                    </style>
                                    <g>
                                        <g id="_x32_5_1_">
                                            <g>
                                                <path class="st0-ps-plug"
                                                      d="M18.6,6.7h-2.4V1.9c0-1-0.8-1.9-1.9-1.9c-1,0-1.9,0.9-1.9,1.9v4.8H7.2V1.9c0-1-0.8-1.9-1.9-1.9     c-1,0-1.9,0.9-1.9,1.9v4.8H0.5C0.2,6.7,0,6.9,0,7.2v7.9c0,1.7,1.4,3,3,3h3.7c0,0.1,0,0.1,0,0.2v8.1c0,0.3,0.2,0.5,0.5,0.5     c0.3,0,0.5-0.2,0.5-0.5v-8.1c0-0.1,0-0.1,0-0.2h3.9c0,0.1,0,0.1,0,0.2v5.2c0,0.3,0.2,0.5,0.5,0.5c0.3,0,0.5-0.2,0.5-0.5v-5.2     c0-0.1,0-0.1,0-0.2H16c1.7,0,3-1.4,3-3V7.2C19.1,6.9,18.9,6.7,18.6,6.7z M13.4,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9     v4.8h-1.9V1.9z M4.3,1.9c0-0.5,0.4-0.9,1-0.9c0.5,0,0.9,0.4,0.9,0.9v4.8H4.3C4.3,6.7,4.3,1.9,4.3,1.9z M18.1,15.1     c0,1.2-0.9,2.1-2.1,2.1H3c-1.2,0-2.1-0.9-2.1-2.1V7.6h17.2L18.1,15.1L18.1,15.1z"/>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                                <div class="tab-title standart-margin-left">
                                    <div class="color-light-blue unisans-regular-italic font-16">{{ Lang::get('lang.solution') }}</div>
                                    <div class="color-dark-blue font-30 unisans-heavy standart-margin-top">PS Plug</div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-two-content product col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <div class="col-lg-7 col-md-7 col-sm-12 clear-left-right-padding">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <div class="ps-gallery-box">
                        <div class="ps-gallery-box-image">
                            <img src="{{ asset('images/products/ps-plug/1.png') }}"/>
                        </div>
                        <div class="ps-gallery-box-thumbs">
                            <a class="ps-gallery-thumb-btn selected">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/1.png') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/2.png') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/3.png') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn clear-right-margin">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/4.png') }}" width="50"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/5.png') }}" width="60"/>
                            </a>
                            <a class="ps-gallery-thumb-btn">
                                <img class="standart-padding-top standart-padding-bottom"
                                     src="{{ asset('images/products/ps-plug/wallpaper_ps_plug_2.png') }}" width="60"/>
                            </a>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-5">
                    <h1 class="unisans-bold color-dark-blue">PS Plug</h1>
                    <p>
                        <img class="standart-padding-top standart-padding-bottom"
                             src="{{ asset('images/layer-two-displays.png') }}"/></p>
                    <br/>
                    <div class="col-lg-12 clear-left-padding hidden">
                        @if(empty(Session::get('init_user.ip_api')) || (Session::get('init_user.ip_api') && (Session::get('init_user.ip_api.country_code') != 'GR' && Session::get('init_user.ip_api.country_code') != 'XK' && Session::get('init_user.ip_api.country_code') != 'MK' && Session::get('init_user.ip_api.country_code') != 'AL' && Session::get('init_user.ip_api.country_code') != 'NL' && Session::get('init_user.ip_api.country_code') != 'RU') ))
                            @if(App::getLocale() != 'hu')
                                <div class="col-lg-6 clear-left-padding">
                                    <div class="font-50 line-height-50 pull-left">
                                        @if(config('app.locale') == 'bg')
                                            49
                                        @else
                                            24
                                        @endif
                                    </div>
                                    <div class="font-18 pull-left">00</div>
                                    <div class="font-22 line-height-60 pull-left">{{Config::get('app.currency')}}</div>
                                </div>
                                <div class="clearfix"></div>
                                <br/>
                            @endif
                            <div class="col-lg-6 col-md-7 col-sm-5 col-xs-12 clear-left-right-padding">
                                @if(App::getLocale() == 'hu')
                                    <a style="display: block;text-align: center;"
                                       href="http://www.quantrax.hu/viszontelado-partnereink" target="_blank"
                                       class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </a>
                                @else
                                    {!! Form::open(array('route' => 'post-add-to-cart')) !!}
                                    {!! Form::hidden('Good', '7') !!}
                                    <button type="submit"
                                            class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20">
                                        {!! Lang::get('lang.buy') !!}
                                    </button>
                                    {!! Form::close() !!}
                                @endif
                            </div>
                        @endif
                    </div>
                    <div class="clearfix"></div>
                </div>
                <div class="col-lg-12"><br/>
                    <div style="display: flex;align-items: center;margin-bottom: 20px">
                        <svg style="width:20px;color:#e1948e;margin-right: 10px"
                             class="svg-inline--fa fa-file-pdf fa-w-12 fa-5x fa-pull-left" aria-hidden="true"
                             data-prefix="fas" data-icon="file-pdf" role="img" xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 384 512" data-fa-i2svg="">
                            <path fill="currentColor"
                                  d="M181.9 256.1c-5-16-4.9-46.9-2-46.9 8.4 0 7.6 36.9 2 46.9zm-1.7 47.2c-7.7 20.2-17.3 43.3-28.4 62.7 18.3-7 39-17.2 62.9-21.9-12.7-9.6-24.9-23.4-34.5-40.8zM86.1 428.1c0 .8 13.2-5.4 34.9-40.2-6.7 6.3-29.1 24.5-34.9 40.2zM248 160h136v328c0 13.3-10.7 24-24 24H24c-13.3 0-24-10.7-24-24V24C0 10.7 10.7 0 24 0h200v136c0 13.2 10.8 24 24 24zm-8 171.8c-20-12.2-33.3-29-42.7-53.8 4.5-18.5 11.6-46.6 6.2-64.2-4.7-29.4-42.4-26.5-47.8-6.8-5 18.3-.4 44.1 8.1 77-11.6 27.6-28.7 64.6-40.8 85.8-.1 0-.1.1-.2.1-27.1 13.9-73.6 44.5-54.5 68 5.6 6.9 16 10 21.5 10 17.9 0 35.7-18 61.1-61.8 25.8-8.5 54.1-19.1 79-23.2 21.7 11.8 47.1 19.5 64 19.5 29.2 0 31.2-32 19.7-43.4-13.9-13.6-54.3-9.7-73.6-7.2zM377 105L279 7c-4.5-4.5-10.6-7-17-7h-6v128h128v-6.1c0-6.3-2.5-12.4-7-16.9zm-74.1 255.3c4.1-2.7-2.5-11.9-42.8-9 37.1 15.8 42.8 9 42.8 9z"></path>
                        </svg>
                        @if(App::getLocale() == 'bg')
                            <a class="color-dark-blue font-20" style="margin-top: 5px;"
                               href="https://bboilrf.com/documents/User_manual_PS_Plug_BG.pdf"
                               target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                        @elseif(App::getLocale() == 'ru')
                            <a class="color-dark-blue font-20" style="margin-top: 5px;"
                               href="https://bboilrf.com/documents/User_manual_PS_Plug_RU.pdf"
                               target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                        @else
                            <a class="color-dark-blue font-20" style="margin-top: 5px;"
                               href="https://bboilrf.com/documents/User_manual_PS_Plug_EN.pdf"
                               target="_blank">{!! Lang::get('lang.UserManual') !!}</a>
                        @endif
                    </div>
                </div>
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.AboutProduct') !!}</h2>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.ps_plug_description.about_ln_1') !!}<br/><br/>
                    </div>
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-20 text-justify">
                        {!! Lang::get('lang.ps_plug_description.about_ln_2') !!}<br/><br/>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 col-md-5">
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.ps_plug_usage') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_manage_description.manage_ln_1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_manage_description.manage_ln_2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_manage_description.manage_ln_3') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_manage_description.manage_ln_4') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_manage_description.manage_ln_5') !!}
                </div>
                @if(Lang::get('lang.ps_plug_manage_description.manage_ln_6') != '')
                    <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                    <div class="font-16 line-height-30 text-justify">
                        {!! Lang::get('lang.ps_plug_manage_description.manage_ln_6') !!}
                    </div>
                @endif
                <br/>
                <h2 class="unisans-bold color-dark-blue font-20">{!! Lang::get('lang.ps_plug_why_choose') !!}</h2>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_why_choose_description.choose_ln_1') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_why_choose_description.choose_ln_2') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_why_choose_description.choose_ln_3') !!}
                </div>
                <div class="dz-icon color-dark-blue font-20 pull-left standart-margin-right">&#59013;</div>
                <div class="font-16 line-height-30 text-justify">
                    {!! Lang::get('lang.ps_plug_why_choose_description.choose_ln_4') !!}
                </div>
                <br/><br/>
                <a target="_blank" href="https://www.microsoft.com/bg-bg/store/apps/prosmart/9nblggh5qfnz">
                    <img class="standart-margin-right"
                         src="{{ asset('images/ms_app.png') }}" width="120"/>
                </a>
                <a target="_blank" href="https://play.google.com/store/apps/details?id=com.ProSmart.ProSmart">
                    <img class="standart-margin-right"
                         src="{{ asset('images/google_app.png') }}" width="145"/>
                </a>
                <a target="_blank" href="https://itunes.apple.com/us/app/prosmart/id1087882546">
                    <img class="standart-margin-right"
                         src="{{ asset('images/apple_app.jpg') }}" width="120"/>
                </a>
            </div>
        </div>
        <div class="clearfix"></div>
        <br/>
    </section>
    <section
            class="footer col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-8 col-lg-offset-2 col-md-8 col-md-offset-2 col-sm-12 col-xs-12">
                <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12 clear-left-right-padding text-center standart-margin-top color-white">
                    {!! Lang::get('lang.bulletin_subscribe') !!}
                </div>
                <div class="standart-margin-top col-lg-7 col-md-7 col-sm-7 col-xs-12 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12 unisans-regular-regular standart-margin-top text-center">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16">{{ Lang::get('lang.send') }}</button>
                </div>
                <div class="clearfix"></div>
            </div>
        </div>
    </section>
    <div class="clearfix"></div>
    <div class="text-center fixed-content margin-auto standart-margin-bottom"><br/>
        @include('partials.well-sell-internationaly')
        <br/><br/>
    </div>
    <div class="clearfix"></div>
    <div class="layer-tree-under-header text-center standart-margin-top">
        <div class="font-30 unisans-regular-italic color-light-blue">
            {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
        </div>
        <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
        <br/>
    </div>
    <div class="clearfix"></div>
    <div class="modal success" id="subscribe-form-modal-success">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">

                    <p class="unisans-regular-italic color-dark-gray font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="modal error" id="subscribe-form-modal-error">
        <div class="modal-dialog">
            <div class="modal-content text-center"><br/>
                <button type="button" class="close close-popup" data-dismiss="modal" aria-hidden="true"></button>
                <div class="modal-body text-center">
                    <p class="color-red font-20">
                        {{ Lang::get('lang.error') }}!
                    </p>
                    <p class="unisans-regular-italic color-red font-18 message"></p>
                </div>
                <button class="custom-btn-blue-bold-fill-to-blue-fill centered standart-margin-bottom font-20"
                        data-dismiss="modal">{{ Lang::get('lang.ok') }}</button>
            </div>
        </div>
    </div>
    <div class="clearfix"></div>
    @include('partials.cart-modal')
    @include('partials.success-payment-modal')
    @include('partials.failed-card-checkout-modal')
    @include('blocks.analytics')
@endsection