@extends('layouts.master')

@section('title', 'BBoil - '.Lang::get('lang.pss_brand').' - '.Lang::get('lang.pss_title'))

@section('content')

    <section>
        <nav class="navbar navbar-default">
            <div class="navbar-header navbar-header-product">
                <button type="button" class="navbar-toggle collapsed color-white" data-toggle="collapse"
                        data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a href="{{url()}}" class='navbar-logo'>
                    <img src="{{ asset('images/logo.png') }}" width="40"
                         class="pull-left standart-margin-top standart-margin-left standart-margin-right"/>
                    <div class="pull-left">
                        <span class="font-22 unisans-bold color-white no-uppcase">{{ Lang::get('lang.pss_brand') }}</span>
                    </div>
                </a>
                <div class="to-center-xs">
                    <ul class="lang-nav-mobile col-lg-6 col-md-7 col-sm-8 col-xs-12 clear-right-padding">
                        <li>
                            <a href="{{url().'/bg/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'bg') ? 'active' :''}}">BG</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/en/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'en') ? 'active' :''}}">EN</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/ru/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'ru') ? 'active' :''}}">RU</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/de/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'de') ? 'active' :''}}">DE</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/fr/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'fr') ? 'active' :''}}">FR</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/pl/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'pl') ? 'active' :''}}">PL</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/hu/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'hu') ? 'active' :''}}">HU</a>
                        </li>
                        <li>|</li>
                        <li>
                            <a href="{{url().'/gr/bboil'}}"
                               class="cursor-pointer {{(App::getLocale() == 'gr') ? 'active' :''}}">GR</a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                <ul class="nav navbar-nav navbar-right">
                    <li><a href="{{url().'/'.App::getLocale()}}?solutions"
                           class="cursor-pointer">{{ Lang::get('lang.solutions') }}</a></li>
                    <li><a href="{{url().'/'.App::getLocale()}}?company"
                           class="cursor-pointer">{{ Lang::get('lang.aboutCompany') }}</a></li>
                    <li><a
                                @if(App::getLocale() == 'bg')
                                href="http://bboilrf.com/forum/"
                                @else
                                href="http://bboilrf.com/forum-en/"
                                @endif
                                class="cursor-pointer">{{ Lang::get('lang.forum') }}</a></li>
                    <li>
                        <a class="cursor-pointer"
                           href="/{{App::getLocale()}}/news">{{ Lang::get('lang.NewsWelcome') }}</a>
                    </li>
                    <li><a href="{{url().'/'.App::getLocale()}}?contacts"
                           class="cursor-pointer">{{ Lang::get('lang.contacts') }}</a></li>
                    <li><a href="https://sys.prosmartsystem.com/bg/" target="_blank"
                           class="cursor-pointer">{{ Lang::get('lang.login') }}</a></li>
                </ul>
            </div>
        </nav>
    </section>
    <div class="clearfix"></div>
    <div class="col-lg-10 col-lg-offset-1 text-justify">
        {!! Lang::get('lang.CookieInfo') !!}
    </div>
    <section
            class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree clear-left-right-padding border-bottom-light-blue">
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 layer-tree-header clear-left-right-padding">
            <div class="col-lg-6 col-lg-offset-3 col-md-8 col-md-offset-2 col-sm-12 col-xs-12 layer-tree-header-inner">
                <div class="standart-margin-top col-lg-7 col-lg-offset-1 col-md-7 col-md-offset-1 col-sm-7 col-sm-offset-1 col-xs-7 col-xs-offset-1 unisans-regular-regular custom-input clear-left-right-padding">
                    {!! Form::open(array('name' => 'subscribe-form-bottom', 'id' => 'subscribe-form-bottom')) !!}
                    <input type="text" placeholder="{{ Lang::get('lang.email') }}" name="email"/>
                    {!! Form::close() !!}
                </div>
                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-4 unisans-regular-regular standart-margin-top">
                    <button id='subscribe-btn-bottom' style="margin-left: -5px;"
                            class="custom-btn-blue-bold-fill-to-blue-fill unisans-bold font-16 font-12-xs">{{ Lang::get('lang.send') }}</button>
                </div>
            </div>
        </div>
        <div class="clearfix"></div>
        <div class="layer-tree-under-header text-center">
            <div class="font-30 unisans-regular-italic color-light-blue">
                {!! Lang::get('lang.layer3UnderHeaderMsg') !!}
            </div>
            <div data-target="#modal-ticket" data-toggle="modal"
                 class="text-center cursor-pointer">
                <img src="{{ asset('images/technical_advice.png') }}" width="100"/>
                <div>
                    <span type="button" style="color:#374771;">{{ Lang::get('lang.technicalSupport') }}</span>
                </div>
            </div>
            <br/>
            <div class="color-light-gray font-18">- Pro Smart Ltd.</div>
            <br/>
        </div>
        <div class="clearfix"></div>
    </section>
    <div class="clearfix"></div>


    @include('blocks.analytics')
@endsection