<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Lang;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;

use App;
use Illuminate\Http\Request;
use App\Mail\ContactMail;
use App\Mail\TicketMail;
use App\Mail\RequestMail;

class HomeController extends Controller
{

  function getHome()
  {
      return view('home')->with(array('currentPage' => 'home'));
  }

  function getAbout()
  {
      return view('about')->with(array('currentPage' => 'about'));
  }

  function getSmartHome()
  {
      return view('smart-home')->with(array('currentPage' => 'smart-home'));
  }

  function getHVAC()
  {
      return view('hvac')->with(array('currentPage' => 'hvac'));
  }

  function getAccessControl()
  {
      return view('access-control')->with(array('currentPage' => 'access-control'));
  }

  function getAccelerateYourBusiness()
  {
      return view('accelerate-your-business')->with(array('currentPage' => 'accelerate-your-business'));
  }

  function getProducts()
  {
      return view('products')->with(array('currentPage' => 'products'));
  }

  function getWhiteLabelPage()
  {
      return view('white-label')->with(array('currentPage' => 'white-label'));
  }

  function getFAQ()
  {
      return view('faq')->with(array('currentPage' => 'faq'));
  }

  function getBboilPage()
  {
      return view('products.bboil')->with(array('currentPage' => 'bboil'));
  }

  function getBgatePage()
  {
      return view('products.bgate')->with(array('currentPage' => 'bgate'));
  }

  function getBboilRfPage()
  {
      return view('products.bboil-rf')->with(array('currentPage' => 'bboil-rf'));
  }

  function getBSafeFPage()
  {
      return view('products.bsafe-f')->with(array('currentPage' => 'bsafe-f'));
  }

  function getBSafeWPage()
  {
      return view('products.bsafe-w')->with(array('currentPage' => 'bsafe-w'));
  }

  function getBSafeAPage()
  {
      return view('products.bsafe-a')->with(array('currentPage' => 'bsafe-a'));
  }

  function getPSPlugPage()
  {
      return view('products.ps-plug')->with(array('currentPage' => 'ps-plug'));
  }
  function getCookieInfo()
  {
      return view('cookie-info-page')->with(array('currentPage' => 'cookie-info'));
  }
  public function setCookieAgreement()
  {
      Cookie::queue('pss_cookie_agreement', true, 9999999);
      return redirect()->to(URL::previous());
  }

  public function sendMessage(Request $request)
  {

      $validator = Validator::make(Input::all(), array(
              'name' => 'required',
              'message' => 'required',
              'email' => 'required|email',
          )
      );

      if ($validator->fails()) {
          return json_encode(array(
              'success' => false,
              'errors' => $validator->getMessageBag()->toArray()
          ), 400);
      } else {

          $data = array(
              'email' => Input::get('email'),
              'name' => Input::get('name'),
              'message' => Input::get('message')
          );

          Mail::send(new ContactMail($request));

          return json_encode(['success' => true]);
      }

  }

  public function sendTicket(Request $request)
  {

      $validator = Validator::make(Input::all(), array(
              'deviceType' => 'required',
              'subject' => 'required',
              'message' => 'required',
              'email' => 'required|email',
          )
      );

      if ($validator->fails()) {
          return json_encode(array(
              'success' => false,
              'errors' => $validator->getMessageBag()->toArray()
          ), 400);
      } else {

          $data = array(
              'email' => Input::get('email'),
              'deviceType' => Input::get('deviceType'),
              'serialNumber' => Input::get('serialNumber'),
              'subject' => Input::get('subject'),
              'message' => Input::get('message')
          );

          Mail::send(new TicketMail($request));

          // Mail::send('email.ticket-request', array('data' => $data), function ($message) use ($data) {
          //     $message->to('milen@dsi.bg');
          // })->with($data);

          return json_encode(['success' => true]);
      }

  }
  public function sendRequest(Request $request)
  {

      $validator = Validator::make(Input::all(), array(
              'name' => 'required',
              'businessName' => 'required',
              'phone' => 'required',
              'email' => 'required|email',
              'message' => 'required',
          )
      );

      if ($validator->fails()) {
          return json_encode(array(
              'success' => false,
              'errors' => $validator->getMessageBag()->toArray()
          ), 400);
      } else {

          $data = array(
              'email' => Input::get('email'),
              'name' => Input::get('name'),
              'phone' => Input::get('phone'),
              'businessName' => Input::get('businessName'),
              'message' => Input::get('message')
          );

        Mail::send(new RequestMail($request));

          return json_encode(['success' => true]);
      }

  }
}
