<?php
/**
 * 
 * @author User
 *
 */
class WC_Braintree_Checkout_Manager {

	public static function init() {
		// add_action ( 'woocommerce_after_cart_totals', __CLASS__ . '::after_cart_totals' );
		add_action ( 'woocommerce_proceed_to_checkout', __CLASS__ . '::after_cart_totals', 1 );
		add_action ( 'bfwc_cart_form_fields', __CLASS__ . '::output_cart_fields' );
		add_action ( 'woocommerce_checkout_before_customer_details', __CLASS__ . '::output_checkout_banner' );
		/*
		 * add_action ( 'woocommerce_before_add_to_cart_button', array(
		 * __CLASS__, 'output_product_buttons'
		 * ) , 20);
		 */
		add_action ( 'woocommerce_after_add_to_cart_button', array( 
				__CLASS__, 'output_product_buttons' 
		) );
		add_action ( 'woocommerce_before_add_to_cart_button', array( 
				__CLASS__, 'output_product_data' 
		), 10 );
	}

	public static function after_cart_totals() {
		if (WC ()->cart->needs_payment ()) {
			$gateways = array();
			foreach ( WC ()->payment_gateways ()->get_available_payment_gateways () as $gateway ) {
				if ($gateway->supports ( 'bfwc_cart_checkout' )) {
					if ($gateway->is_cart_checkout_enabled ()) {
						$gateways[ $gateway->id ] = $gateway;
					}
				}
			}
			if (count ( $gateways ) > 0) {
				bwc_get_template ( 'cart/cart-fields.php', array( 
						'gateways' => $gateways 
				) );
			}
		}
	}

	public static function output_cart_fields() {
		if (bwc_applepay_cart_checkout_enabled () || bwc_paypal_cart_checkout_enabled ()) {
			$checkout = WC ()->checkout ();
			$cart = WC ()->cart;
			if (WC ()->cart->needs_shipping ()) {
				$fields = WC ()->checkout ()->get_checkout_fields ( 'shipping' );
				foreach ( $fields as $key => $field ) {
					printf ( '<input type="hidden" id="%1$s" name="%1$s"/>', $key );
				}
			}
			$fields = WC ()->checkout ()->get_checkout_fields ( 'billing' );
			foreach ( $fields as $key => $field ) {
				printf ( '<input type="hidden" id="%1$s" name="%1$s"/>', $key );
			}
			printf ( '<input type="hidden" id="bfwc_cart_total" value="%s"/>', $cart->total );
			printf ( '<input type="hidden" id="bfwc_cart_currency" value="%1$s"/>', get_woocommerce_currency() );
		}
	}

	public static function output_checkout_banner() {
		$available_gateways = WC ()->payment_gateways ()->get_available_payment_gateways ();
		$gateways = array();
		if (WC ()->cart->needs_payment ()) {
			foreach ( $available_gateways as $gateway ) {
				if ($gateway->supports ( 'bfwc_autofill_checkout_fields' )) {
					if ($gateway->checkout_banner_enabled ()) {
						$gateways[ $gateway->id ] = $gateway;
					}
				}
			}
			if ($gateways) {
				bwc_get_template ( 'checkout/checkout-banner.php', array( 
						'gateways' => $gateways 
				) );
			}
		}
	}

	public static function output_product_buttons() {
		global $product;
		if (bwcs_subscriptions_active () && WC_Subscriptions_Product::is_subscription ( $product )) {
			if (WC_Subscriptions_Product::get_trial_length ( $product )) {
				return;
			}
			if (WC_Subscriptions_Synchroniser::is_product_synced ( $product )) {
				return;
			}
		}
		$available_gateways = WC ()->payment_gateways ()->get_available_payment_gateways ();
		$gateways = array();
		foreach ( $available_gateways as $gateway ) {
			if ($gateway->supports ( 'bfwc_product_checkout' )) {
				if ($gateway->product_checkout_enabled ()) {
					$gateways[ $gateway->id ] = $gateway;
				}
			}
		}
		if ($gateways) {
			bwc_get_template ( 'product/product-fields.php', array( 
					'gateways' => $gateways 
			) );
		}
	}

	public static function output_product_data() {
		global $product;
		if (bwc_applepay_product_checkout_enabled () && $product->is_in_stock()) {
			printf ( '<input type="hidden" id="bfwc_cart_currency" value="%1$s"/>', get_woocommerce_currency() );
			printf ( '<input type="hidden" id="bfwc_product_price" value="%1$s"/>', $product->get_price () );
			printf ( '<input type="hidden" id="bfwc_product_data" data-product="%1$s"/>', htmlspecialchars ( wp_json_encode ( array( 
					'price' => $product->get_price (), 
					'title' => $product->get_title (), 
					'post_id' => $product->get_id (), 
					'needs_shipping' => $product->needs_shipping () 
			) ) ) );
			$checkout = WC ()->checkout ();
			$cart = WC ()->cart;
			if ($product->needs_shipping()) {
				$fields = WC ()->checkout ()->get_checkout_fields ( 'shipping' );
				foreach ( $fields as $key => $field ) {
					printf ( '<input type="hidden" id="%1$s" name="%1$s"/>', $key );
				}
			}
			$fields = WC ()->checkout ()->get_checkout_fields ( 'billing' );
			foreach ( $fields as $key => $field ) {
				printf ( '<input type="hidden" id="%1$s" name="%1$s"/>', $key );
			}
			add_filter ( 'woocommerce_terms_is_checked_default', function ($checked) {
				return true;
			} );
			echo '<div style="display:none">';
			wc_get_template ( 'checkout/terms.php' );
			echo '</div>';
		}
	}
}
WC_Braintree_Checkout_Manager::init ();