jQuery(function($){
	if(typeof braintree_applepay_cart_vars === 'undefined'){
		return;
	}
	
	var applepay = {
			vars: braintree_applepay_cart_vars,
			form_id: '#bfwc-cart-fields-form',
			gateway_id: braintree_applepay_cart_vars.gateway_id,
			needs_shipping: braintree_applepay_cart_vars.needs_shipping === "1",
			container: 'li.bfwc_cart_gateway_' + braintree_applepay_cart_vars.gateway_id,
			message_container: '.shop_table',
			applepay_button: '.apple-pay-button',
			nonce_selector: '.bfwc-nonce-value',
			terms_checked: false,
			init: function(){
				$(document.body).on('bfwc_applepay_cart_tokenize_method', this.validate_cart_page);
				this.initialize();
				//this.onshippingcontactselected({shippingContact: {}});
			},
			show_gateway: function(){
				$(applepay.container).show();
			},
			updated_page: function(){
				applepay.show_gateway();
				$('[name="terms"]').prop('checked', applepay.terms_checked);
			},
			initialize: function(){
				if(typeof braintree === "undefined"){
					setTimeout(applepay.initialize, 1500);
					return;
				}
				if(applepay.can_initialize_applepay()){
					if(typeof braintree_applepay_cart_client_token === 'undefined'){
						this.submit_error({
							code: 'INVALID_CLIENT_TOKEN'
						});
						return;
					}
					this.show_gateway();
					braintree.client.create({
						authorization: braintree_applepay_cart_client_token
					}, function(err, clientInstance){
						if(err){
							applepay.submit_error(err);
							return;
						}
						braintree.applePay.create({
							client: clientInstance
						}, function(err, applePayInstance){
							if(err){
								applepay.submit_error(err);
								return;
							}
							applepay.applePayInstance = applePayInstance;
							$(document.body).on('updated_wc_div, updated_cart_totals', applepay.updated_page);
							$(document.body).on('change', '[name="terms"]', function(){
								applepay.terms_checked = $(this).is(':checked');
							});
							var promise = ApplePaySession.canMakePaymentsWithActiveCard(applePayInstance.merchantIdentifier);
							
							promise.then(function(bool){
								if(!bool){
									//display Setup Apple Pay button
								}
								$(document.body).on('click', applepay.applepay_button, applepay.tokenize_method);
							});
							
						})
					});
				}else{
					if($('.bfwc_cart_gateway').length == 1){
						$('.bfwc-cart-gateways-container').hide();
					}
				}
			},
			tokenize_method: function(e){
				e.preventDefault();
				if($(document.body).triggerHandler('bfwc_applepay_cart_tokenize_method') === false){
					return;
				}
				if(applepay.has_nonce()){
					applepay.process_order();
				}else{
					var paymentRequest = applepay.applePayInstance.createPaymentRequest({
						total: {
							label: applepay.vars.store_name,
							amount: applepay.get_cart_total(),
							type: 'final'
						},
						currencyCode: $('#bfwc_cart_currency').val(),
						lineItems: applepay.get_line_items(),
						requiredBillingContactFields: applepay.get_billing_fields_array(),
						requiredShippingContactFields: applepay.get_shipping_fields_array(),
						//billingContact: applepay.get_billing_contact(),
						//shippingContact: applepay.get_shipping_contact(),
						shippingMethods: $('.woocommerce-shipping-methods').length > 0 ? applepay.vars.shipping_methods : []
					});
					try{
						var applePaySession = new ApplePaySession(3, paymentRequest);
						applepay.applePaySession = applePaySession;
						applePaySession.onvalidatemerchant = applepay.onvalidatemerchant;
						applePaySession.onshippingcontactselected = applepay.onshippingcontactselected;
						applePaySession.onshippingmethodselected = applepay.onshippingmethodselected;
						applePaySession.onpaymentauthorized = applepay.onpaymentauthorized;
						applePaySession.begin();
					}catch(err){
						applepay.submit_error(err);
						return;
					}
				}
			},
			onvalidatemerchant: function(event){
				applepay.applePayInstance.performValidation({
					validationURL: event.validationURL,
					displayName: applepay.vars.store_name
				}, function(err, merchantSession){
					if(err){
						applepay.submit_error(err);
						applepay.applePaySession.abort();
						return;
					}
					applepay.applePaySession.completeMerchantValidation(merchantSession);
				})
			},
			onshippingcontactselected: function(event){
				//call rest service and update cart totals using new shipping address.
				var shippingContact = event.shippingContact;
				$.ajax({
					type: 'POST',
					dataType : 'json',
					url: applepay.vars.routes.shipping_address,
					data: shippingContact,
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, jqXHR){
						//update totals;
						if(response.success){
							applepay.applePaySession.completeShippingContactSelection(response.data);
							//update the cart totals html
							$('#calc_shipping_country').val(shippingContact.countryCode);
							$('#calc_shipping_state').val(shippingContact.administrativeArea);
							$('#calc_shipping_city').val(shippingContact.locality);
							$('#calc_shipping_postcode').val(shippingContact.postalCode);
							$('.woocommerce-shipping-calculator').trigger('submit');
						}else{
							applepay.applePaySession.abort();
							applepay.submit_error(response.messages);
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						applepay.applePaySession.abort();
						applepay.submit_error(errorThrown);
					}
				});
			},
			onshippingmethodselected: function(event){
				//call rest service and update cart totals using new shipping method.
				var shippingMethod = event.shippingMethod;
				$.ajax({
					type: 'POST',
					dataType : 'json',
					url: applepay.vars.routes.shipping_method,
					data: shippingMethod,
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce', applepay.vars._wpnonce);
					},
					success: function(response, status, jqXHR){
						//update totals;
						if(response.success){
							applepay.applePaySession.completeShippingMethodSelection(response.shippingMethodUpdate);
							//update the selected shipping method on the cart page.
							$('input[name^="shipping_method"]').val(shippingMethod.identifier);
							$('.cart_totals').replaceWith(response.cart_totals);
							$( document.body ).trigger( 'updated_cart_totals' );
						}else{
							applepay.applePaySession.abort();
							applepay.submit_error(response.messages);
						}
					},
					error: function(jqXHR, textStatus, errorThrown){
						applepay.applePaySession.abort();
						applepay.submit_error(errorThrown);
					}
				});
			},
			onpaymentauthorized: function(event){
				applepay.applePayInstance.tokenize({
					token: event.payment.token
				}, function(err, response){
					if(err){
						applepay.submit_error(err);
						applepay.applePaySession.completePayment(ApplePaySession.STATUS_FAILURE);
						return;
					}
					applepay.applePaySession.completePayment(ApplePaySession.STATUS_SUCCESS);
					applepay.set_nonce(response.nonce);
					applepay.populate_address_data(event.payment);
					applepay.tokenize_response = {payment: event.payment, response: response};
					//call service
					applepay.process_order();
				})
			},
			process_order: function(){
				// create the order using ajax;
				$form = $(applepay.form_id);
				$.blockUI({
					message : null,
					overlayCSS : {
						background : '#fff',
						opacity : 0.6
					}
				});
				$.ajax({
					type : 'POST',
					url : applepay.vars.routes.order,
					data : $form.serialize(),
					dataType : 'json',
					beforeSend : function(xhr, settings) {
						xhr.setRequestHeader('X-WP-Nonce',
								applepay.vars._wpnonce);
					},
					success : function(result, status, jqXHR) {
						applepay.vars._wpnonce = jqXHR
								.getResponseHeader('X-WP-Nonce');
						if (result.reload) {
							window.location.reload();
							return;
						}
						if (result.result === 'success') {
							window.location = result.redirect;
						} else {
							if (result.messages) {
								applepay.submit_error(result.messages);
							}
							applepay.set_nonce("");
							$.unblockUI();
						}
					},
					error : function(jqXHR, textStatus, errorThrown) {
						applepay.set_nonce("");
						applepay.submit_error(errorThrown);
						$.unblockUI();
					}
				});
			},
			can_initialize_applepay: function(){
				return window.ApplePaySession && ApplePaySession.canMakePayments();
			},
			submit_error : function(error) {
				applepay.clear_error();
				$(document.body).triggerHandler('bfwc_submit_error', {
					error : error,
					element : applepay.message_container
				});
			},
			set_nonce: function(nonce){
				$(applepay.container).find(applepay.nonce_selector).val(nonce);
			},
			has_nonce: function(){
				return $(applepay.container).find(applepay.nonce_selector).val().length > 0;
			},
			get_cart_total: function(){
				return $("#bfwc_cart_total").val();
			},
			get_line_items: function(){
				var object = JSON.parse($("#bfwc_applepay_line_items").val());
				return object.line_items;
			},
			get_billing_fields_array: function(){
				return ["postalAddress"];
			},
			get_shipping_fields_array: function(){
				var fields = [];
				if(applepay.vars.needs_shipping === "1"){
					fields.push("postalAddress");
				}
				if($("#billing_email").length){
					fields.push("email");
				}
				if($("#billing_phone").length){
					fields.push("phone");
				}
				return fields;
			},
			get_billing_contact: function(){
				var mappings = applepay.get_object_mappings();
				var billingContact = {};
				$.each(mappings, function(k, obj){
					var val = obj.get("#billing");
					if(val != null && val.length > 0){
						billingContact[k] = val;
					}
				});
				return billingContact;
			},
			get_shipping_contact: function(){
				var mappings = applepay.get_object_mappings();
				var shippingContact = {
						emailAddress: mappings.emailAddress.get(),
						phoneNumber: mappings.phoneNumber.get()
				};
				if(applepay.vars.needs_shipping === "1"){
					$.each(mappings, function(k, obj){
						var val = obj.get("#shipping");
						if(val != null && val.length > 0){
							shippingContact[k] = val;
						}
					});
				}
				return shippingContact;
			},
			get_object_mappings: function(){
				return {
					"givenName": {
						get: function(prefix){
							return $(prefix + "_first_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_first_name").val(v);
						}
					},
					"familyName": {
						get: function(prefix){
							return $(prefix + "_last_name").val();
						},
						set: function(v, prefix){
							$(prefix + "_last_name").val(v);
						}
					},
					"addressLines": {
						get: function(prefix){
							var addressLines = [];
							if($(prefix + "_address_1").val() != ''){
								addressLines.push($(prefix + "_address_1").val());
							}
							if($(prefix + "_address_2").val() != ''){
								addressLines.push($(prefix + "_address_2").val());
							}
							return addressLines;
						},
						set: function(v, prefix){
							$(prefix + "_address_1").val(v[0]);
							if(v.length == 2){
								$(prefix + "_address_2").val(v[0]);
							}
						}
					},
					"administrativeArea": {
						get: function(prefix){
							return $(prefix + "_state").val();
						},
						set: function(v, prefix){
							if(v.length == 2){
								$(prefix + "_state").val(v.toUpperCase());
							}else{
								$(prefix + '_state option').each(function(){
									var $this = $(this);
									var text = $this.text().toLowerCase();
									v = v.toLowerCase();
									if(text.indexOf(v) >= 0){
										$(prefix + "_state").val($this.val());
									}
								});
							}
						}
					},
					"locality": {
						get: function(prefix){
							return $(prefix + "_city").val();
						},
						set: function(v, prefix){
							$(prefix + "_city").val(v);
						}
					},
					"postalCode": {
						get: function(prefix){
							return $(prefix + "_postcode").val();
						},
						set: function(v, prefix){
							$(prefix + "_postcode").val(v);
						}
					},
					"phoneNumber": {
						get: function(prefix){
							return $("#billing_phone").val();
						},
						set: function(v, prefix){
							$("#billing_phone").val(v);
						}
					},
					"emailAddress": {
						get: function(prefix){
							return $("#billing_email").val();
						},
						set: function(v, prefix){
							$("#billing_email").val(v);
						}
					},
					"countryCode": {
						get: function(prefix){
							return $(prefix + "_country").val();
						},
						set: function(v, prefix){
							$(prefix + "_country").val(v);
						}
					}
				}
			},
			populate_address_data: function(response){
				if(response.shippingContact){
					//populate the shipping fields
					var mappings = applepay.get_object_mappings();
					$.each(response.shippingContact, function(k, v){
						if(mappings[k]){
							mappings[k].set(v, "#shipping");
						}
					});
				}
				if(response.billingContact){
					//populate the billing fields
					var mappings = applepay.get_object_mappings();
					$.each(response.billingContact, function(k, v){
						if(mappings[k]){
							if(mappings[k]){
								mappings[k].set(v, "#billing");
							}
						}
					});
				}
			},
			has_error: function(){
				return $('#bfwc_checkout_error').length > 0;
			},
			clear_error: function(){
				$('#bfwc_checkout_error').remove();
			},
			validate_cart_page: function(){
				if($('[name="terms"]').length){
					if(!$('[name="terms"]').is(':checked')){
						applepay.submit_error(applepay.vars.messages.terms);
						return false;
					}
				}
			}
	};
	
	applepay.init();
});