<?php

namespace Buttonizer\Admin\Ajax;

class SaveData
{
    public function __construct()
    {
        // Is this user logged in?
        if ( wp_get_current_user()->ID === 0 ) {
            exit( json_encode( [
                'status'  => 'error',
                'message' => 'You are not logged in',
            ] ) );
        }
        // Is this a administrator?
        if ( !current_user_can( 'administrator' ) ) {
            exit( json_encode( [
                'status'  => 'error',
                'message' => 'You must have administrator rights to save your settings.',
            ] ) );
        }
        switch ( $_GET['save'] ) {
            case 'categories':
                $this->saveCategories();
                break;
            default:
                echo  json_encode( [
                    'status'  => 'error',
                    'message' => 'No function handled',
                ] ) ;
                break;
        }
    }
    
    private function saveCategories()
    {
        echo  json_encode( [
            'status'  => 'error',
            'message' => 'You do not have Buttonizer Pro.',
        ] ) ;
    }

}